/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.animloader.AnimationWrapper;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.items.gear.JetpackGlider;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.ClientProxy;
import com.hbm.main.MainRegistry;
import com.hbm.main.ResourceManager;
import com.hbm.packet.JetpackSyncPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.ParticleFakeBrightness;
import com.hbm.particle.ParticleHeatDistortion;
import com.hbm.particle.ParticleJetpackTrail;
import com.hbm.particle.rocket.ParticleRocketPlasma;
import com.hbm.render.RenderHelper;
import com.hbm.render.misc.ColorGradient;
import com.hbm.sound.MovingSoundJetpack;
import com.hbm.util.BobMathUtil;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovementInput;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector4f;

public class JetpackHandler {
    public static final String JETPACK_NBT = "hbmJetpackAdvanced";
    public static Method r_setSize;
    public static Field r_ticksElytraFlying;
    private static boolean jet_key_down;
    private static boolean hover_key_down;
    private static boolean hud_key_down;
    private static Map<PlayerKey, JetpackInfo> perPlayerInfo;
    private static float[] keroseneColor;
    private static float[] nitanColor;
    private static float[] bfColor;
    private static ColorGradient keroseneGradient;
    private static ColorGradient nitanGradient;
    private static ColorGradient bfGradient;

    public static JetpackInfo get(EntityPlayer p) {
        return perPlayerInfo.get(new PlayerKey(p));
    }

    public static void put(EntityPlayer p, JetpackInfo j) {
        perPlayerInfo.put(new PlayerKey(p), j);
    }

    public static boolean hasJetpack(EntityPlayer p) {
        ItemStack chest = (ItemStack)p.field_71071_by.field_70460_b.get(2);
        ItemStack stack = ArmorModHandler.pryMod(chest, 1);
        return stack.func_77973_b() == ModItems.jetpack_glider;
    }

    public static FluidTank getTank(EntityPlayer p) {
        ItemStack chest = (ItemStack)p.field_71071_by.field_70460_b.get(2);
        ItemStack stack = ArmorModHandler.pryMod(chest, 1);
        return ((JetpackGlider)stack.func_77973_b()).getTank(stack);
    }

    public static void setTank(EntityPlayer p, FluidTank tank) {
        ItemStack chest = (ItemStack)p.field_71071_by.field_70460_b.get(2);
        ItemStack stack = ArmorModHandler.pryMod(chest, 1);
        ((JetpackGlider)stack.func_77973_b()).setTank(stack, tank);
    }

    public static float getSpeed(Fluid f) {
        if (f == null) {
            return 0.0f;
        }
        if (f == ModForgeFluids.KEROSENE) {
            return 0.3f;
        }
        if (f == ModForgeFluids.NITAN) {
            return 0.5f;
        }
        if (f == ModForgeFluids.BALEFIRE) {
            return 1.5f;
        }
        return 0.0f;
    }

    public static int getDrain(Fluid f) {
        if (f == null) {
            return 0;
        }
        if (f == ModForgeFluids.KEROSENE) {
            return 1;
        }
        if (f == ModForgeFluids.NITAN) {
            return 1;
        }
        if (f == ModForgeFluids.BALEFIRE) {
            return 1;
        }
        return 0;
    }

    public static ColorGradient getGradientFromFuel(Fluid fuel) {
        if (fuel == ModForgeFluids.BALEFIRE) {
            return bfGradient;
        }
        if (fuel == ModForgeFluids.NITAN) {
            return nitanGradient;
        }
        return keroseneGradient;
    }

    public static float[] getBrightnessColorFromFuel(Fluid fuel) {
        if (fuel == ModForgeFluids.BALEFIRE) {
            return bfColor;
        }
        if (fuel == ModForgeFluids.NITAN) {
            return nitanColor;
        }
        return keroseneColor;
    }

    @SideOnly(value=Side.CLIENT)
    public static void inputUpdate(InputUpdateEvent e) {
        boolean jKey;
        EntityPlayer player = e.getEntityPlayer();
        if (!JetpackHandler.hasJetpack(player)) {
            return;
        }
        FluidTank fuelTank = JetpackHandler.getTank(player);
        JetpackInfo info = JetpackHandler.get(player);
        if (info == null) {
            info = new JetpackInfo(true);
            JetpackHandler.put(player, info);
            info.dirty = true;
        }
        if ((jKey = ClientProxy.jetpackActivate.func_151470_d()) && !jet_key_down && System.currentTimeMillis() - JetpackHandler.getAnimTime(player) > 1000L) {
            JetpackHandler.toggleOpenState(player);
        }
        jet_key_down = jKey;
        boolean hKey = ClientProxy.jetpackHover.func_151470_d();
        if (hKey && !hover_key_down) {
            JetpackHandler.toggleHoverState(player);
        }
        hover_key_down = hKey;
        boolean hudKey = ClientProxy.jetpackHud.func_151470_d();
        if (hudKey && !hud_key_down) {
            JetpackHandler.toggleHUDState(player);
        }
        hud_key_down = hudKey;
        float thrust = info.thrust;
        if (JetpackHandler.jetpackActive(player) && player.func_70090_H()) {
            info.failureTicks = 80;
        }
        if (JetpackHandler.jetpackActive(player) && !player.field_70122_E && info.failureTicks <= 0 && fuelTank.getFluidAmount() > 0) {
            float speed = JetpackHandler.getSpeed(fuelTank.getFluid().getFluid());
            player.field_71075_bZ.field_75100_b = false;
            MovementInput m = e.getMovementInput();
            boolean sprint = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
            if (player.func_70051_ag()) {
                player.func_70031_b(sprint);
            }
            if (JetpackHandler.isHovering(player)) {
                m.field_192832_b = (float)((double)m.field_192832_b * ((player.func_70051_ag() ? 0.17 : 0.1) * (double)speed));
                m.field_78902_a *= 0.1f * speed;
                player.field_70159_w -= (double)(MathHelper.func_76126_a((float)((float)Math.toRadians(player.field_70759_as))) * m.field_192832_b);
                player.field_70179_y += (double)(MathHelper.func_76134_b((float)((float)Math.toRadians(player.field_70759_as))) * m.field_192832_b);
                player.field_70159_w -= (double)(MathHelper.func_76126_a((float)((float)Math.toRadians(player.field_70759_as - 90.0f))) * m.field_78902_a);
                player.field_70179_y += (double)(MathHelper.func_76134_b((float)((float)Math.toRadians(player.field_70759_as - 90.0f))) * m.field_78902_a);
                player.field_70181_x *= 0.75;
                player.field_70181_x += 0.05;
                float extraMY = 0.0f;
                if (m.field_78901_c) {
                    m.field_78901_c = false;
                    extraMY = (float)((double)extraMY + 0.3 * (double)speed);
                }
                if (m.field_78899_d) {
                    m.field_78899_d = false;
                    extraMY = (float)((double)extraMY - Math.min(0.3, 0.3 * (double)speed));
                }
                player.field_70181_x += (double)extraMY;
                float diff = Math.abs(m.field_192832_b) + Math.abs(m.field_78902_a) + extraMY + 0.4f - thrust;
                JetpackHandler.setThrust(player, thrust + diff * 0.3f);
                m.field_192832_b = sprint ? 0.81f : 0.0f;
                m.field_78902_a = 0.0f;
            } else {
                float boost = m.field_78901_c ? speed : 0.0f;
                float diff = MathHelper.func_76131_a((float)BobMathUtil.remap(boost, 0.0f, 2.0f, 0.0f, 4.0f), (float)0.0f, (float)2.0f) - thrust;
                JetpackHandler.setThrust(player, thrust + diff * 0.2f);
                Vec3d look = player.func_70040_Z();
                if (m.field_78901_c) {
                    player.field_70159_w += look.field_72450_a * (double)boost * 0.5;
                    player.field_70181_x += look.field_72448_b * (double)boost * 0.5;
                    if (look.field_72448_b > 0.0) {
                        player.field_70181_x += look.field_72448_b * (double)0.08f;
                    }
                    player.field_70179_y += look.field_72449_c * (double)boost * 0.5;
                }
                m.field_192832_b = 0.0f;
                m.field_78902_a = 0.0f;
                if (player.field_70181_x < -0.08) {
                    Vec3d vec = player.func_70040_Z();
                    double mo = player.field_70181_x * -0.4;
                    player.field_70181_x += mo * (1.0 - Math.abs(vec.field_72448_b));
                    player.field_70159_w += vec.field_72450_a * mo;
                    player.field_70181_x += vec.field_72448_b * mo * (1.0 - Math.abs(vec.field_72448_b));
                    player.field_70179_y += vec.field_72449_c * mo;
                }
            }
            info.prevThrust = thrust;
        } else {
            float diff = -thrust;
            JetpackHandler.setThrust(player, thrust + diff * 0.3f);
            info.prevThrust = thrust;
        }
    }

    public static void serverTick() {
        Iterator<Map.Entry<PlayerKey, JetpackInfo>> itr = perPlayerInfo.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<PlayerKey, JetpackInfo> e = itr.next();
            EntityPlayer player = e.getKey().player;
            if (player.field_70128_L) {
                itr.remove();
                continue;
            }
            if (player.field_70170_p.field_72995_K) continue;
            JetpackInfo info = e.getValue();
            if (JetpackHandler.jetpackActive(player)) {
                FluidTank tank = JetpackHandler.getTank(player);
                int drain = (int)Math.ceil((float)JetpackHandler.getDrain(tank.getFluid() == null ? null : tank.getFluid().getFluid()) * info.thrust);
                if ((double)info.thrust < 1.0E-4) {
                    drain = 0;
                }
                tank.drain(drain, true);
                JetpackHandler.setTank(player, tank);
            }
            if (player.field_70181_x > -0.5) {
                player.field_70143_R = 0.0f;
            }
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new JetpackSyncPacket(player), (Entity)player);
        }
    }

    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayer player = e.player;
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(JETPACK_NBT)) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(JETPACK_NBT);
            JetpackInfo j = new JetpackInfo(player.field_70170_p.field_72995_K);
            j.readFromNBT(tag);
            JetpackHandler.put(e.player, j);
            PacketDispatcher.sendTo(new JetpackSyncPacket(player), (EntityPlayerMP)player);
        }
    }

    public static void loadNBT(EntityPlayer player) {
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(JETPACK_NBT)) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(JETPACK_NBT);
            JetpackInfo j = new JetpackInfo(player.field_70170_p.field_72995_K);
            j.readFromNBT(tag);
            JetpackHandler.put(player, j);
            PacketDispatcher.wrapper.sendToAllTracking((IMessage)new JetpackSyncPacket(player), (Entity)((EntityPlayerMP)player));
        }
    }

    public static void worldLoad(WorldEvent.Load e) {
        for (EntityPlayer player : e.getWorld().field_73010_i) {
            JetpackHandler.loadNBT(player);
        }
    }

    public static void saveNBT(EntityPlayer player) {
        JetpackInfo info;
        if (JetpackHandler.hasJetpack(player) && (info = JetpackHandler.get(player)) != null) {
            NBTTagCompound tag = info.writeToNBT(new NBTTagCompound());
            ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(2);
            if (stack.func_190926_b()) {
                return;
            }
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74782_a(JETPACK_NBT, (NBTBase)tag);
        }
    }

    public static void worldSave(WorldEvent.Save e) {
        for (EntityPlayer player : e.getWorld().field_73010_i) {
            JetpackHandler.saveNBT(player);
        }
    }

    public static void startTracking(PlayerEvent.StartTracking e) {
        EntityPlayer player;
        JetpackInfo j;
        if (!e.getEntityPlayer().field_70170_p.field_72995_K && e.getTarget() instanceof EntityPlayer && e.getEntityPlayer() instanceof EntityPlayerMP && (j = JetpackHandler.get(player = (EntityPlayer)e.getTarget())) != null) {
            PacketDispatcher.wrapper.sendTo((IMessage)new JetpackSyncPacket(player), (EntityPlayerMP)e.getEntityPlayer());
        }
    }

    public static void postPlayerTick(EntityPlayer player) {
        JetpackInfo j = JetpackHandler.get(player);
        if (j == null) {
            return;
        }
        if (r_setSize == null) {
            r_setSize = ReflectionHelper.findMethod(Entity.class, (String)"setSize", (String)"func_70105_a", (Class[])new Class[]{Float.TYPE, Float.TYPE});
        }
        if (JetpackHandler.jetpackActive(player) && !player.field_70122_E && j.failureTicks <= 0 && JetpackHandler.getTank(player).getFluidAmount() > 0) {
            if (JetpackHandler.isHovering(player)) {
                try {
                    r_setSize.invoke((Object)player, Float.valueOf(player.field_70130_N), Float.valueOf(1.8f));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (j != null && j.jetpackFlyTime >= 0 && player.field_70170_p.field_72995_K) {
                    j.jetpackFlyTime = -1;
                }
            } else {
                try {
                    r_setSize.invoke((Object)player, Float.valueOf(player.field_70130_N), Float.valueOf(0.6f));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (j != null && player.field_70170_p.field_72995_K) {
                    ++j.jetpackFlyTime;
                }
            }
        } else if (j != null && j.jetpackFlyTime >= 0 && player.field_70170_p.field_72995_K) {
            j.jetpackFlyTime = -1;
            try {
                r_setSize.invoke((Object)player, Float.valueOf(player.field_70130_N), Float.valueOf(1.8f));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderHUD(EntityPlayer p, ScaledResolution res) {
        if (!JetpackHandler.hasJetpack(p)) {
            return;
        }
        JetpackInfo info = JetpackHandler.get(p);
        if (info == null) {
            return;
        }
        if (info.useCompactHUD) {
            float maxHeight = 0.78125f;
            float maxHeightPixels = 50.0f * maxHeight;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.jetpack_hud_small);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GlStateManager.func_179141_d();
            RenderHelper.drawGuiRect(0.0f, (float)res.func_78328_b() - maxHeightPixels, 0.0f, 1.0f - maxHeight, 50.0f, maxHeightPixels, 1.0f, 1.0f);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            float oX = 0.12109375f;
            float width = 0.34375f - oX;
            float oY = 0.03125f;
            float height = 0.12109375f - oY;
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            float thrust = info.prevThrust + (info.thrust - info.prevThrust) * MainRegistry.proxy.partialTicks();
            float thrustDegrees = MathHelper.func_76131_a((float)(thrust * 100.0f - 27.0f), (float)-27.0f, (float)200.0f);
            GL11.glPushMatrix();
            float rX = oX * 50.0f + 7.9101562f;
            float rY = (float)res.func_78328_b() - (maxHeightPixels - maxHeightPixels * oY) + 14.5f * maxHeightPixels / 256.0f;
            GL11.glTranslated((double)(rX + 22.851562f), (double)(rY + 0.296875f * maxHeightPixels), (double)0.0);
            GL11.glRotated((double)thrustDegrees, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-rX), (double)(-rY), (double)0.0);
            RenderHelper.drawGuiRect(oX * 50.0f, (float)res.func_78328_b() - (maxHeightPixels - maxHeightPixels * oY), oX, oY, width * 50.0f, height * 50.0f, oX + width, oY + height);
            GL11.glPopMatrix();
            FluidTank tank = JetpackHandler.getTank(p);
            float fuelDegrees = (float)tank.getFluidAmount() / (float)tank.getCapacity();
            fuelDegrees = fuelDegrees * 227.0f - 27.0f;
            GL11.glPushMatrix();
            GL11.glTranslated((double)rX, (double)(rY + 0.296875f * maxHeightPixels), (double)0.0);
            GL11.glRotated((double)fuelDegrees, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-rX), (double)(-rY), (double)0.0);
            RenderHelper.drawGuiRect(oX * 50.0f, (float)res.func_78328_b() - (maxHeightPixels - maxHeightPixels * oY), oX, oY, width * 50.0f, height * 50.0f, oX + width, oY + height);
            GL11.glPopMatrix();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.jetpack_hud_small_text);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            float yOffset = 0.0f;
            float yPosition = 0.0f;
            float yHeight = 0.0f;
            if (info.failureTicks > 0) {
                yOffset = 0.59375f;
                yHeight = 0.8125f - yOffset;
                yPosition = -0.5f;
            } else if (JetpackHandler.jetpackActive(p)) {
                if (info.hover) {
                    yOffset = 0.1953125f;
                    yHeight = 0.359375f - yOffset;
                    yPosition = -10.25f;
                } else {
                    yOffset = 0.0078125f;
                    yHeight = 0.1796875f - yOffset;
                    yPosition = -14.75f;
                }
            } else {
                yOffset = 0.3671875f;
                yHeight = 0.5859375f - yOffset;
                yPosition = -6.0f;
            }
            RenderHelper.drawGuiRect(0.0f, (float)(res.func_78328_b() - 25) - (yOffset - yOffset * 25.0f) - yPosition, 0.0f, yOffset, 50.0f, 25.0f * yHeight, 1.0f, yOffset + yHeight);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.jetpack_hud_large);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GlStateManager.func_179141_d();
            RenderHelper.drawGuiRect(0.0f, res.func_78328_b() - 80, 0.0f, 0.0f, 80.0f, 80.0f, 0.5f, 1.0f);
            GlStateManager.func_179118_c();
            boolean active = JetpackHandler.jetpackActive(p);
            boolean hover = JetpackHandler.isHovering(p);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            float oX = 0.078125f;
            float width = 0.3359375f - oX;
            if (active) {
                RenderHelper.drawGuiRect(oX * 80.0f, res.func_78328_b() - 40, 0.5f + oX * 0.5f, 0.5f, width * 80.0f, 40.0f, 0.5f + (width + oX) * 0.5f, 1.0f);
            }
            oX = 0.3359375f;
            width = 0.55078125f - oX;
            if (hover) {
                RenderHelper.drawGuiRect(oX * 80.0f, res.func_78328_b() - 40, 0.5f + oX * 0.5f, 0.5f, width * 80.0f, 40.0f, 0.5f + (width + oX) * 0.5f, 1.0f);
            }
            oX = 0.55078125f;
            width = 0.7480469f - oX;
            if (!hover) {
                RenderHelper.drawGuiRect(oX * 80.0f, res.func_78328_b() - 40, 0.5f + oX * 0.5f, 0.5f, width * 80.0f, 40.0f, 0.5f + (width + oX) * 0.5f, 1.0f);
            }
            oX = 0.7480469f;
            width = 1.0f - oX;
            if (info.failureTicks > 0) {
                RenderHelper.drawGuiRect(oX * 80.0f, res.func_78328_b() - 40, 0.5f + oX * 0.5f, 0.5f, width * 80.0f, 40.0f, 0.5f + (width + oX) * 0.5f, 1.0f);
            }
            oX = 0.095703125f;
            width = 0.26171875f - oX;
            float oY = 0.2890625f;
            float height = 0.33398438f - oY;
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            float thrust = info.prevThrust + (info.thrust - info.prevThrust) * MainRegistry.proxy.partialTicks();
            float thrustDegrees = MathHelper.func_76131_a((float)(thrust * 100.0f - 27.0f), (float)-27.0f, (float)200.0f);
            GL11.glPushMatrix();
            float rX = oX * 80.0f + 9.609375f;
            float rY = (float)res.func_78328_b() - (80.0f - oY * 80.0f) + 1.796875f;
            GL11.glTranslated((double)rX, (double)rY, (double)0.0);
            GL11.glRotated((double)thrustDegrees, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-rX), (double)(-rY), (double)0.0);
            RenderHelper.drawGuiRect(oX * 80.0f, (float)res.func_78328_b() - (80.0f - oY * 80.0f), 0.5f + oX * 0.5f, oY, width * 80.0f, height * 80.0f, 0.5f + (width + oX) * 0.5f, oY + height);
            GL11.glPopMatrix();
            FluidTank tank = JetpackHandler.getTank(p);
            float fuelDegrees = (float)tank.getFluidAmount() / (float)tank.getCapacity();
            fuelDegrees = fuelDegrees * 227.0f - 27.0f;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(rX + 27.96875f), (double)rY, (double)0.0);
            GL11.glRotated((double)fuelDegrees, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-rX), (double)(-rY), (double)0.0);
            RenderHelper.drawGuiRect(oX * 80.0f, (float)res.func_78328_b() - (80.0f - oY * 80.0f), 0.5f + oX * 0.5f, oY, width * 80.0f, height * 80.0f, 0.5f + (width + oX) * 0.5f, oY + height);
            GL11.glPopMatrix();
            if (tank.getFluid() != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                TextureAtlasSprite fuel = FFUtils.getTextureFromFluid(tank.getFluid().getFluid());
                RenderHelper.drawGuiRect(66.8f, (float)res.func_78328_b() - 71.3f, fuel.func_94209_e(), fuel.func_94206_g(), 6.5f, 6.8f, fuel.func_94212_f(), fuel.func_94210_h());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void preRenderPlayer(EntityPlayer player) {
        if (!JetpackHandler.hasJetpack(player) || !JetpackHandler.jetpackActive(player)) {
            return;
        }
        GL11.glPushMatrix();
        float partialTicks = MainRegistry.proxy.partialTicks();
        double playerPosX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double playerPosY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double playerPosZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        double offsetX = playerPosX - TileEntityRendererDispatcher.field_147554_b;
        double offsetY = playerPosY - TileEntityRendererDispatcher.field_147555_c;
        double offsetZ = playerPosZ - TileEntityRendererDispatcher.field_147552_d;
        GL11.glTranslated((double)offsetX, (double)offsetY, (double)offsetZ);
        JetpackInfo j = JetpackHandler.get(player);
        if (JetpackHandler.isHovering(player)) {
            if (j != null) {
                float prevMX = (float)(player.field_70169_q - j.prevPrevPosX);
                float prevMZ = (float)(player.field_70166_s - j.prevPrevPosZ);
                float mX = (float)(player.field_70165_t - player.field_70169_q);
                float mZ = (float)(player.field_70161_v - player.field_70166_s);
                float motionX = prevMX + (mX - prevMX) * MainRegistry.proxy.partialTicks();
                float motionZ = prevMZ + (mZ - prevMZ) * MainRegistry.proxy.partialTicks();
                float angle = (float)(Math.atan2(motionX, motionZ) + 1.5707963267948966);
                float amount = MathHelper.func_76131_a((float)MathHelper.func_76129_c((float)(motionX * motionX + motionZ * motionZ)), (float)0.0f, (float)2.0f);
                GL11.glRotated((double)((double)amount * 22.5), (double)Math.toDegrees(MathHelper.func_76126_a((float)angle)), (double)0.0, (double)Math.toDegrees(MathHelper.func_76134_b((float)angle)));
            }
        } else if (!player.field_70122_E && j != null && j.failureTicks <= 0 && JetpackHandler.getTank(player).getFluidAmount() > 0) {
            float angle;
            Vec3d look = player.func_70676_i(MainRegistry.proxy.partialTicks());
            float renderYaw = JetpackHandler.interpolateRotation(player.field_70760_ar, player.field_70761_aq, MainRegistry.proxy.partialTicks());
            GlStateManager.func_179114_b((float)(180.0f - renderYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            float time = (float)j.jetpackFlyTime + MainRegistry.proxy.partialTicks();
            float mult = BobMathUtil.remap01_clamp(time * time * 0.5f, 0.0f, 100.0f);
            GL11.glRotated((double)((-player.field_70125_A - 90.0f) * mult), (double)1.0, (double)0.0, (double)0.0);
            Vector2f lookXZ = new Vector2f((float)look.field_72450_a, (float)look.field_72449_c);
            Vector2f rotXZ = new Vector2f(MathHelper.func_76134_b((float)((float)Math.toRadians(renderYaw + 90.0f))), MathHelper.func_76126_a((float)((float)Math.toRadians(renderYaw + 90.0f))));
            if (lookXZ.lengthSquared() != 0.0f && rotXZ.lengthSquared() != 0.0f && !Float.isNaN(angle = (float)Math.acos(Math.max(Vector2f.dot((Vector2f)(lookXZ = (Vector2f)lookXZ.normalise()), (Vector2f)(rotXZ = (Vector2f)rotXZ.normalise())), 0.0f)))) {
                float cross = lookXZ.y * rotXZ.x - rotXZ.y * lookXZ.x;
                GL11.glRotated((double)(Math.toDegrees(angle) * (double)Math.signum(cross) * (double)mult), (double)0.0, (double)1.0, (double)0.0);
            }
            GlStateManager.func_179114_b((float)(-(180.0f - renderYaw)), (float)0.0f, (float)1.0f, (float)0.0f);
            if (j != null) {
                if (r_ticksElytraFlying == null) {
                    r_ticksElytraFlying = ReflectionHelper.findField(EntityLivingBase.class, (String)"ticksElytraFlying", (String)"field_184629_bo");
                }
                try {
                    r_ticksElytraFlying.setInt(player, j.jetpackFlyTime);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        GL11.glTranslated((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
    }

    protected static float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    @SideOnly(value=Side.CLIENT)
    public static void postRenderPlayer(EntityPlayer player) {
        if (!JetpackHandler.hasJetpack(player) || !JetpackHandler.jetpackActive(player)) {
            return;
        }
        if (!JetpackHandler.isHovering(player) && JetpackHandler.getTank(player).getFluidAmount() > 0) {
            JetpackInfo info = JetpackHandler.get(player);
            if (!player.field_70122_E && info.failureTicks <= 0 && info.particleSpawnPositions != null && player.field_70159_w * player.field_70159_w + player.field_70181_x * player.field_70181_x + player.field_70179_y * player.field_70179_y > 2.25) {
                ClientProxy.deferredRenderers.add(() -> {
                    if (info.trails[0] == null) {
                        info.trails[0] = new ParticleJetpackTrail(player.field_70170_p);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)info.trails[0]);
                        info.trails[1] = new ParticleJetpackTrail(player.field_70170_p);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)info.trails[1]);
                    }
                    info.trails[0].tryAddNewPos(info.particleSpawnPositions[0]);
                    info.trails[1].tryAddNewPos(info.particleSpawnPositions[1]);
                });
            } else {
                info.trails[0] = null;
                info.trails[1] = null;
            }
            if (r_ticksElytraFlying == null) {
                r_ticksElytraFlying = ReflectionHelper.findField(EntityLivingBase.class, (String)"ticksElytraFlying", (String)"field_184629_bo");
            }
            try {
                r_ticksElytraFlying.setInt(player, 0);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientTick(TickEvent.ClientTickEvent e) {
        block20: {
            EntityPlayerSP p;
            block19: {
                p = Minecraft.func_71410_x().field_71439_g;
                if (e.phase != TickEvent.Phase.END) break block19;
                for (EntityPlayer player : p.field_70170_p.field_73010_i) {
                    if (!JetpackHandler.jetpackActive(player) || player.field_70122_E) continue;
                    player.field_70721_aZ = 0.0f;
                    player.field_184619_aG = 0.0f;
                    player.field_184618_aE = 0.0f;
                }
                break block20;
            }
            if (e.phase != TickEvent.Phase.START) break block20;
            Iterator<Map.Entry<PlayerKey, JetpackInfo>> itr = perPlayerInfo.entrySet().iterator();
            while (itr.hasNext()) {
                FluidTank tank;
                Particle part;
                Map.Entry<PlayerKey, JetpackInfo> entry = itr.next();
                EntityPlayer player = entry.getKey().player;
                if (player.field_70128_L) {
                    if (entry.getValue().sound != null) {
                        entry.getValue().sound.end();
                    }
                    itr.remove();
                    continue;
                }
                if (!player.field_70170_p.field_72995_K) continue;
                JetpackInfo j = entry.getValue();
                if ((double)j.thrust > 0.001) {
                    if (j.sound == null) {
                        j.sound = new MovingSoundJetpack(player, HBMSoundHandler.jetpack, SoundCategory.PLAYERS);
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)j.sound);
                    }
                } else if (j.sound != null) {
                    j.sound.end();
                    j.sound = null;
                }
                if (player == Minecraft.func_71410_x().field_71439_g) {
                    if (j.failureTicks > 0) {
                        j.dirty = true;
                    }
                    j.failureTicks = Math.max(0, j.failureTicks - 1);
                }
                j.prevPrevPosX = player.field_70169_q;
                j.prevPrevPosZ = player.field_70166_s;
                Iterator<Particle> it = j.booster_particles.iterator();
                while (it.hasNext()) {
                    part = it.next();
                    part.func_189213_a();
                    if (part.func_187113_k()) continue;
                    it.remove();
                }
                it = j.distortion_particles.iterator();
                while (it.hasNext()) {
                    part = it.next();
                    part.func_189213_a();
                    if (part.func_187113_k()) continue;
                    it.remove();
                }
                it = j.brightness_particles.iterator();
                while (it.hasNext()) {
                    part = it.next();
                    part.func_189213_a();
                    if (part.func_187113_k()) continue;
                    it.remove();
                }
                boolean active = JetpackHandler.jetpackActive(player);
                FluidTank fluidTank = tank = active ? JetpackHandler.getTank(player) : null;
                if (active && !player.field_70122_E && tank.getFluid() != null) {
                    ColorGradient grad = JetpackHandler.getGradientFromFuel(tank.getFluid().getFluid());
                    float[] color = JetpackHandler.getBrightnessColorFromFuel(tank.getFluid().getFluid());
                    if (j.thrust > 0.05f) {
                        float thrust = j.thrust - 0.4f;
                        float speed = -1.0f - 2.0f * thrust;
                        float scale = 4.0f + 2.0f * thrust;
                        int numParticles = 3;
                        for (int i = 0; i < numParticles; ++i) {
                            float iN = (float)i / (float)numParticles;
                            float randX = (float)(p.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f);
                            float randZ = (float)(p.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f);
                            j.booster_particles.add(new ParticleRocketPlasma(p.field_70170_p, -1.8, iN * speed, 4.0, scale, grad).motion(randX - 0.1f, speed, randZ));
                            randX = (float)(p.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f);
                            randZ = (float)(p.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f);
                            j.booster_particles.add(new ParticleRocketPlasma(p.field_70170_p, 1.8, iN * speed, 4.0, scale, grad).motion(randX + 0.1f, speed, randZ));
                        }
                        if (player.field_70170_p.func_82737_E() % (long)(2 - player.field_70170_p.field_73012_v.nextInt(2)) == 0L) {
                            j.brightness_particles.add(new ParticleFakeBrightness(p.field_70170_p, 1.8, -1.0, 4.0, 20.0f + thrust * 10.0f, 6 + player.field_70170_p.field_73012_v.nextInt(2)).color(color[0], color[1], color[2], MathHelper.func_76131_a((float)(0.05f + thrust * 0.1f), (float)0.0f, (float)1.0f)).enableLocalSpaceCorrection());
                            j.brightness_particles.add(new ParticleFakeBrightness(p.field_70170_p, -1.8, -1.0, 4.0, 20.0f + thrust * 10.0f, 6 + player.field_70170_p.field_73012_v.nextInt(2)).color(color[0], color[1], color[2], MathHelper.func_76131_a((float)(0.05f + thrust * 0.1f), (float)0.0f, (float)1.0f)).enableLocalSpaceCorrection());
                        }
                        if (player.field_70170_p.field_73012_v.nextInt(2) == 0) {
                            j.distortion_particles.add(new ParticleHeatDistortion(p.field_70170_p, 1.8, -1.0, 4.0, 5.0f + thrust, 1.5f + thrust * 3.0f, 5, player.field_70170_p.field_73012_v.nextFloat() * 20.0f).motion(0.1f, speed * 0.5f, 0.0f).enableLocalSpaceCorrection());
                        }
                        if (player.field_70170_p.field_73012_v.nextInt(2) == 0) {
                            j.distortion_particles.add(new ParticleHeatDistortion(p.field_70170_p, -1.8, -1.0, 4.0, 5.0f + thrust, 1.5f + thrust * 3.0f, 5, player.field_70170_p.field_73012_v.nextFloat() * 20.0f).motion(-0.1f, speed * 0.5f, 0.0f).enableLocalSpaceCorrection());
                        }
                    }
                }
                player.field_70158_ak = true;
                if (player != Minecraft.func_71410_x().field_71439_g || !j.dirty) continue;
                PacketDispatcher.wrapper.sendToServer((IMessage)new JetpackSyncPacket(player));
                j.dirty = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleCameraTransform(EntityViewRenderEvent.CameraSetup e) {
        if (JetpackHandler.jetpackActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && !JetpackHandler.isHovering((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O > 0 && !Minecraft.func_71410_x().field_71439_g.field_70122_E) {
            GL11.glTranslated((double)0.0, (double)-1.22, (double)0.0);
        }
    }

    public static void toggleOpenState(EntityPlayer p) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null) {
            j = new JetpackInfo(p.field_70170_p.field_72995_K);
            JetpackHandler.put(p, j);
        }
        j.dirty = true;
        j.animTime = System.currentTimeMillis();
        j.opening = !j.opening;
    }

    public static void toggleHoverState(EntityPlayer p) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null) {
            j = new JetpackInfo(p.field_70170_p.field_72995_K);
            JetpackHandler.put(p, j);
        }
        j.dirty = true;
        j.hover = !j.hover;
    }

    public static void toggleHUDState(EntityPlayer p) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null) {
            j = new JetpackInfo(p.field_70170_p.field_72995_K);
            JetpackHandler.put(p, j);
        }
        j.dirty = true;
        j.useCompactHUD = !j.useCompactHUD;
    }

    public static void setThrust(EntityPlayer p, float thrust) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null) {
            j = new JetpackInfo(p.field_70170_p.field_72995_K);
            JetpackHandler.put(p, j);
        }
        if (j.thrust != thrust) {
            j.dirty = true;
            j.thrust = thrust;
        }
    }

    public static boolean isHovering(EntityPlayer p) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null) {
            return false;
        }
        return j.hover;
    }

    public static boolean isOpening(EntityPlayer p) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null) {
            return true;
        }
        return j.opening;
    }

    public static boolean useCompactHUD(EntityPlayer p) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null) {
            return false;
        }
        return j.useCompactHUD;
    }

    public static long getAnimTime(EntityPlayer p) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null) {
            return 0L;
        }
        return j.animTime;
    }

    public static boolean jetpackActive(EntityPlayer p) {
        JetpackInfo j = JetpackHandler.get(p);
        if (j == null || !JetpackHandler.hasJetpack(p)) {
            return false;
        }
        return j.opening && System.currentTimeMillis() - j.animTime > 1000L;
    }

    static {
        jet_key_down = false;
        hover_key_down = false;
        hud_key_down = false;
        perPlayerInfo = new HashMap<PlayerKey, JetpackInfo>();
        keroseneColor = new float[]{1.0f, 0.6f, 0.5f};
        nitanColor = new float[]{1.0f, 0.5f, 1.0f};
        bfColor = new float[]{0.4f, 1.0f, 0.7f};
        keroseneGradient = new ColorGradient({1.0f, 0.918f, 0.882f, 1.0f, 0.0f}, {0.887f, 1.0f, 0.0f, 1.0f, 0.177f}, {1.0f, 0.19f, 0.0f, 1.0f, 0.336f}, {1.0f, 0.14f, 0.0f, 1.0f, 0.85f}, {1.0f, 0.14f, 0.0f, 0.0f, 1.0f});
        nitanGradient = new ColorGradient({0.845f, 0.779f, 1.0f, 1.0f, 0.0f}, {1.0f, 0.3f, 1.0f, 1.0f, 0.122f}, {0.7f, 0.4f, 1.0f, 1.0f, 0.389f}, {0.35f, 0.2f, 1.0f, 1.0f, 0.891f}, {0.1f, 0.1f, 1.0f, 0.0f, 1.0f});
        bfGradient = new ColorGradient({1.0f, 0.95f, 0.279f, 1.0f, 0.0f}, {1.0f, 0.9f, 0.1f, 1.0f, 0.122f}, {0.013f, 1.0f, 0.068f, 1.0f, 0.389f}, {0.2f, 1.0f, 0.3f, 1.0f, 0.891f}, {0.0f, 1.0f, 0.4f, 0.0f, 1.0f});
    }

    public static class PlayerKey {
        public EntityPlayer player;

        public PlayerKey(EntityPlayer player) {
            this.player = player;
        }

        public int hashCode() {
            return System.identityHashCode(this.player);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PlayerKey)) {
                return false;
            }
            return this.player == ((PlayerKey)obj).player;
        }
    }

    public static class JetpackInfo {
        public boolean opening;
        public boolean hover = false;
        public float thrust;
        public int jetpackFlyTime;
        public int failureTicks = 0;
        public boolean dirty = true;
        public boolean useCompactHUD = false;
        public long animTime;
        public Vec3d[] particleSpawnPositions = null;
        public double prevPrevPosX;
        public double prevPrevPosZ;
        public float prevThrust;
        @SideOnly(value=Side.CLIENT)
        public MovingSoundJetpack sound;
        @SideOnly(value=Side.CLIENT)
        public List<Particle> booster_particles;
        @SideOnly(value=Side.CLIENT)
        public List<Particle> brightness_particles;
        @SideOnly(value=Side.CLIENT)
        public List<Particle> distortion_particles;
        @SideOnly(value=Side.CLIENT)
        public ParticleJetpackTrail[] trails;

        public JetpackInfo(boolean client) {
            if (client) {
                this.initClient();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void initClient() {
            this.sound = null;
            this.booster_particles = new ArrayList<Particle>();
            this.brightness_particles = new ArrayList<Particle>();
            this.distortion_particles = new ArrayList<Particle>();
            this.trails = new ParticleJetpackTrail[2];
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74757_a("opening", this.opening);
            tag.func_74757_a("hover", this.hover);
            tag.func_74776_a("thrust", this.thrust);
            tag.func_74768_a("flyTime", this.jetpackFlyTime);
            tag.func_74757_a("compact", this.useCompactHUD);
            tag.func_74768_a("failureTicks", this.failureTicks);
            return tag;
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.opening = tag.func_74767_n("opening");
            this.hover = tag.func_74767_n("hover");
            this.thrust = tag.func_74760_g("thrust");
            this.jetpackFlyTime = tag.func_74762_e("flyTime");
            this.useCompactHUD = tag.func_74767_n("compact");
            this.failureTicks = tag.func_74762_e("failureTicks");
            this.dirty = true;
        }

        public void write(ByteBuf buf) {
            buf.writeBoolean(this.opening);
            buf.writeBoolean(this.hover);
            buf.writeFloat(this.thrust);
            buf.writeInt(this.jetpackFlyTime);
            buf.writeBoolean(this.useCompactHUD);
            buf.writeInt(this.failureTicks);
        }

        public void read(ByteBuf buf) {
            this.opening = buf.readBoolean();
            this.hover = buf.readBoolean();
            this.thrust = buf.readFloat();
            this.jetpackFlyTime = buf.readInt();
            this.useCompactHUD = buf.readBoolean();
            this.failureTicks = buf.readInt();
        }

        public void setFromServer(JetpackInfo other) {
            if (other.opening != this.opening) {
                this.animTime = System.currentTimeMillis();
            }
            this.opening = other.opening;
            this.hover = other.hover;
            this.thrust = other.thrust;
            this.jetpackFlyTime = other.jetpackFlyTime;
            this.useCompactHUD = other.useCompactHUD;
            this.failureTicks = other.failureTicks;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class JetpackLayer
    implements LayerRenderer<EntityPlayer> {
        public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!JetpackHandler.hasJetpack(player)) {
                return;
            }
            GL11.glPushMatrix();
            GlStateManager.func_179089_o();
            GL11.glTranslated((double)0.0, (double)0.9, (double)1.25);
            GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
            if (player.func_70093_af()) {
                GL11.glTranslated((double)0.0, (double)5.4, (double)1.0);
                GL11.glRotated((double)Math.toDegrees(0.5), (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslated((double)0.0, (double)-4.0, (double)0.0);
            }
            GlStateManager.func_179103_j((int)7425);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.jetpack_tex);
            long startTime = JetpackHandler.getAnimTime(player);
            boolean reverse = !JetpackHandler.isOpening(player);
            AnimationWrapper w = new AnimationWrapper(startTime, ResourceManager.jetpack_activate);
            if (reverse) {
                w.reverse();
            }
            w.onEnd(new AnimationWrapper.EndResult(AnimationWrapper.EndType.STAY, null));
            ResourceManager.jetpack.controller.setAnim(w);
            ResourceManager.jetpack.renderAnimated(System.currentTimeMillis());
            GlStateManager.func_179103_j((int)7424);
            float[] matrix = new float[16];
            GL11.glGetFloat((int)2982, (FloatBuffer)ClientProxy.AUX_GL_BUFFER);
            ClientProxy.AUX_GL_BUFFER.get(matrix);
            ClientProxy.AUX_GL_BUFFER.rewind();
            ClientProxy.deferredRenderers.add(() -> {
                GL11.glPushMatrix();
                ClientProxy.AUX_GL_BUFFER.put(matrix);
                ClientProxy.AUX_GL_BUFFER.rewind();
                GL11.glLoadMatrix((FloatBuffer)ClientProxy.AUX_GL_BUFFER);
                JetpackInfo j = JetpackHandler.get(player);
                if (j != null) {
                    j.particleSpawnPositions = BobMathUtil.worldFromLocal(new Vector4f(5.25f, 0.2f, 2.75f, 1.0f), new Vector4f(-5.25f, 0.2f, 2.75f, 1.0f));
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(ResourceManager.fresnel_ms);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179132_a((boolean)false);
                    Entity entityIn = Minecraft.func_71410_x().func_175606_aa();
                    float f1 = MathHelper.func_76134_b((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
                    float f2 = MathHelper.func_76126_a((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
                    float f3 = -f2 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
                    float f4 = f1 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
                    float f5 = MathHelper.func_76134_b((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
                    for (Particle p : j.distortion_particles) {
                        p.func_180434_a(Tessellator.func_178181_a().func_178180_c(), entityIn, partialTicks, f1, f5, f2, f3, f4);
                    }
                    GlStateManager.func_179132_a((boolean)false);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    for (Particle p : j.booster_particles) {
                        p.func_180434_a(Tessellator.func_178181_a().func_178180_c(), entityIn, partialTicks, f1, f5, f2, f3, f4);
                    }
                    for (Particle p : j.brightness_particles) {
                        p.func_180434_a(Tessellator.func_178181_a().func_178180_c(), entityIn, partialTicks, f1, f5, f2, f3, f4);
                    }
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179084_k();
                }
                GL11.glPopMatrix();
            });
            GL11.glPopMatrix();
        }

        public boolean func_177142_b() {
            return false;
        }
    }
}

