/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ItemModCladding;
import com.hbm.lib.Library;
import com.hbm.potion.HbmPotion;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class HazmatRegistry {
    private static Map<Item, Double> entries = new HashMap<Item, Double>();

    public static void registerHazmat(Item item, double resistance) {
        entries.put(item, resistance);
    }

    public static double getResistance(ItemStack stack) {
        if (stack == null) {
            return 0.0;
        }
        float cladding = HazmatRegistry.getCladding(stack);
        Double d = entries.get(stack.func_77973_b());
        if (d != null) {
            return d + (double)cladding;
        }
        return cladding;
    }

    public static float getCladding(ItemStack stack) {
        ItemStack[] mods;
        ItemStack cladding;
        if (stack.func_77942_o() && stack.func_77978_p().func_74760_g("hfr_cladding") > 0.0f) {
            return stack.func_77978_p().func_74760_g("hfr_cladding");
        }
        if (ArmorModHandler.hasMods(stack) && (cladding = (mods = ArmorModHandler.pryMods(stack))[5]) != null && cladding.func_77973_b() instanceof ItemModCladding) {
            return (float)((ItemModCladding)cladding.func_77973_b()).rad;
        }
        return 0.0f;
    }

    public static float getResistance(EntityLivingBase player) {
        float res = 0.0f;
        if (player.func_110124_au().toString().equals(Library.HbMinecraft) || player.func_110124_au().toString().equals(Library.Drillgon) || player.func_110124_au().toString().equals(Library.Alcater)) {
            res += 1.0f;
        }
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_190926_b()) continue;
            res = (float)((double)res + HazmatRegistry.getResistance(stack));
        }
        PotionEffect radx = player.func_70660_b((Potion)HbmPotion.radx);
        if (radx != null) {
            res += 0.1f * (float)(1 + radx.func_76458_c());
        }
        return res;
    }

    public static double fixRounding(double value) {
        return BigDecimal.valueOf(value).setScale(4, RoundingMode.HALF_UP).doubleValue();
    }

    public static void registerHazmats() {
        double helmet = 0.2;
        double chest = 0.4;
        double legs = 0.3;
        double boots = 0.1;
        double iron = 0.0225;
        double gold = 0.03;
        double steel = 0.045;
        double titanium = 0.045;
        double alloy = 0.07;
        double cobalt = 0.125;
        double hazYellow = 0.6;
        double hazRed = 1.0;
        double hazGray = 2.0;
        double liquidator = 2.4;
        double paa = 3.0;
        double t45 = 1.0;
        double ajr = 1.3;
        double hev = 1.6;
        double bj = 1.0;
        double rpa = 2.0;
        double fau = 4.0;
        double dns = 6.0;
        double security = 0.01;
        double star = 0.25;
        double cmb = 1.3;
        double schrab = 3.0;
        double euph = 10.0;
        HazmatRegistry.registerHazmat(ModItems.hazmat_helmet, HazmatRegistry.fixRounding(hazYellow * helmet));
        HazmatRegistry.registerHazmat(ModItems.hazmat_plate, HazmatRegistry.fixRounding(hazYellow * chest));
        HazmatRegistry.registerHazmat(ModItems.hazmat_legs, HazmatRegistry.fixRounding(hazYellow * legs));
        HazmatRegistry.registerHazmat(ModItems.hazmat_boots, HazmatRegistry.fixRounding(hazYellow * boots));
        HazmatRegistry.registerHazmat(ModItems.hazmat_helmet_red, HazmatRegistry.fixRounding(hazRed * helmet));
        HazmatRegistry.registerHazmat(ModItems.hazmat_plate_red, HazmatRegistry.fixRounding(hazRed * chest));
        HazmatRegistry.registerHazmat(ModItems.hazmat_legs_red, HazmatRegistry.fixRounding(hazRed * legs));
        HazmatRegistry.registerHazmat(ModItems.hazmat_boots_red, HazmatRegistry.fixRounding(hazRed * boots));
        HazmatRegistry.registerHazmat(ModItems.hazmat_helmet_grey, HazmatRegistry.fixRounding(hazGray * helmet));
        HazmatRegistry.registerHazmat(ModItems.hazmat_plate_grey, HazmatRegistry.fixRounding(hazGray * chest));
        HazmatRegistry.registerHazmat(ModItems.hazmat_legs_grey, HazmatRegistry.fixRounding(hazGray * legs));
        HazmatRegistry.registerHazmat(ModItems.hazmat_boots_grey, HazmatRegistry.fixRounding(hazGray * boots));
        HazmatRegistry.registerHazmat(ModItems.liquidator_helmet, HazmatRegistry.fixRounding(liquidator * helmet));
        HazmatRegistry.registerHazmat(ModItems.liquidator_plate, HazmatRegistry.fixRounding(liquidator * chest));
        HazmatRegistry.registerHazmat(ModItems.liquidator_legs, HazmatRegistry.fixRounding(liquidator * legs));
        HazmatRegistry.registerHazmat(ModItems.liquidator_boots, HazmatRegistry.fixRounding(liquidator * boots));
        HazmatRegistry.registerHazmat(ModItems.t45_helmet, HazmatRegistry.fixRounding(t45 * helmet));
        HazmatRegistry.registerHazmat(ModItems.t45_plate, HazmatRegistry.fixRounding(t45 * chest));
        HazmatRegistry.registerHazmat(ModItems.t45_legs, HazmatRegistry.fixRounding(t45 * legs));
        HazmatRegistry.registerHazmat(ModItems.t45_boots, HazmatRegistry.fixRounding(t45 * boots));
        HazmatRegistry.registerHazmat(ModItems.ajr_helmet, HazmatRegistry.fixRounding(ajr * helmet));
        HazmatRegistry.registerHazmat(ModItems.ajr_plate, HazmatRegistry.fixRounding(ajr * chest));
        HazmatRegistry.registerHazmat(ModItems.ajr_legs, HazmatRegistry.fixRounding(ajr * legs));
        HazmatRegistry.registerHazmat(ModItems.ajr_boots, HazmatRegistry.fixRounding(ajr * boots));
        HazmatRegistry.registerHazmat(ModItems.ajro_helmet, HazmatRegistry.fixRounding(ajr * helmet));
        HazmatRegistry.registerHazmat(ModItems.ajro_plate, HazmatRegistry.fixRounding(ajr * chest));
        HazmatRegistry.registerHazmat(ModItems.ajro_legs, HazmatRegistry.fixRounding(ajr * legs));
        HazmatRegistry.registerHazmat(ModItems.ajro_boots, HazmatRegistry.fixRounding(ajr * boots));
        HazmatRegistry.registerHazmat(ModItems.rpa_helmet, HazmatRegistry.fixRounding(rpa * helmet));
        HazmatRegistry.registerHazmat(ModItems.rpa_plate, HazmatRegistry.fixRounding(rpa * chest));
        HazmatRegistry.registerHazmat(ModItems.rpa_legs, HazmatRegistry.fixRounding(rpa * legs));
        HazmatRegistry.registerHazmat(ModItems.rpa_boots, HazmatRegistry.fixRounding(rpa * boots));
        HazmatRegistry.registerHazmat(ModItems.bj_helmet, HazmatRegistry.fixRounding(bj * helmet));
        HazmatRegistry.registerHazmat(ModItems.bj_plate, HazmatRegistry.fixRounding(bj * chest));
        HazmatRegistry.registerHazmat(ModItems.bj_plate_jetpack, HazmatRegistry.fixRounding(bj * chest));
        HazmatRegistry.registerHazmat(ModItems.bj_legs, HazmatRegistry.fixRounding(bj * legs));
        HazmatRegistry.registerHazmat(ModItems.bj_boots, HazmatRegistry.fixRounding(bj * boots));
        HazmatRegistry.registerHazmat(ModItems.hev_helmet, HazmatRegistry.fixRounding(hev * helmet));
        HazmatRegistry.registerHazmat(ModItems.hev_plate, HazmatRegistry.fixRounding(hev * chest));
        HazmatRegistry.registerHazmat(ModItems.hev_legs, HazmatRegistry.fixRounding(hev * legs));
        HazmatRegistry.registerHazmat(ModItems.hev_boots, HazmatRegistry.fixRounding(hev * boots));
        HazmatRegistry.registerHazmat(ModItems.fau_helmet, HazmatRegistry.fixRounding(fau * helmet));
        HazmatRegistry.registerHazmat(ModItems.fau_plate, HazmatRegistry.fixRounding(fau * chest));
        HazmatRegistry.registerHazmat(ModItems.fau_legs, HazmatRegistry.fixRounding(fau * legs));
        HazmatRegistry.registerHazmat(ModItems.fau_boots, HazmatRegistry.fixRounding(fau * boots));
        HazmatRegistry.registerHazmat(ModItems.dns_helmet, HazmatRegistry.fixRounding(dns * helmet));
        HazmatRegistry.registerHazmat(ModItems.dns_plate, HazmatRegistry.fixRounding(dns * chest));
        HazmatRegistry.registerHazmat(ModItems.dns_legs, HazmatRegistry.fixRounding(dns * legs));
        HazmatRegistry.registerHazmat(ModItems.dns_boots, HazmatRegistry.fixRounding(dns * boots));
        HazmatRegistry.registerHazmat(ModItems.paa_helmet, HazmatRegistry.fixRounding(paa * helmet));
        HazmatRegistry.registerHazmat(ModItems.paa_plate, HazmatRegistry.fixRounding(paa * chest));
        HazmatRegistry.registerHazmat(ModItems.paa_legs, HazmatRegistry.fixRounding(paa * legs));
        HazmatRegistry.registerHazmat(ModItems.paa_boots, HazmatRegistry.fixRounding(paa * boots));
        HazmatRegistry.registerHazmat(ModItems.hazmat_paa_helmet, HazmatRegistry.fixRounding(paa * helmet));
        HazmatRegistry.registerHazmat(ModItems.hazmat_paa_plate, HazmatRegistry.fixRounding(paa * chest));
        HazmatRegistry.registerHazmat(ModItems.hazmat_paa_legs, HazmatRegistry.fixRounding(paa * legs));
        HazmatRegistry.registerHazmat(ModItems.hazmat_paa_boots, HazmatRegistry.fixRounding(paa * boots));
        HazmatRegistry.registerHazmat(ModItems.security_helmet, HazmatRegistry.fixRounding(security * helmet));
        HazmatRegistry.registerHazmat(ModItems.security_plate, HazmatRegistry.fixRounding(security * chest));
        HazmatRegistry.registerHazmat(ModItems.security_legs, HazmatRegistry.fixRounding(security * legs));
        HazmatRegistry.registerHazmat(ModItems.security_boots, HazmatRegistry.fixRounding(security * boots));
        HazmatRegistry.registerHazmat(ModItems.starmetal_helmet, HazmatRegistry.fixRounding(star * helmet));
        HazmatRegistry.registerHazmat(ModItems.starmetal_plate, HazmatRegistry.fixRounding(star * chest));
        HazmatRegistry.registerHazmat(ModItems.starmetal_legs, HazmatRegistry.fixRounding(star * legs));
        HazmatRegistry.registerHazmat(ModItems.starmetal_boots, HazmatRegistry.fixRounding(star * boots));
        HazmatRegistry.registerHazmat(ModItems.jackt, 0.1);
        HazmatRegistry.registerHazmat(ModItems.jackt2, 0.1);
        HazmatRegistry.registerHazmat(ModItems.gas_mask, 0.07);
        HazmatRegistry.registerHazmat(ModItems.gas_mask_m65, 0.095);
        HazmatRegistry.registerHazmat(ModItems.steel_helmet, HazmatRegistry.fixRounding(steel * helmet));
        HazmatRegistry.registerHazmat(ModItems.steel_plate, HazmatRegistry.fixRounding(steel * chest));
        HazmatRegistry.registerHazmat(ModItems.steel_legs, HazmatRegistry.fixRounding(steel * legs));
        HazmatRegistry.registerHazmat(ModItems.steel_boots, HazmatRegistry.fixRounding(steel * boots));
        HazmatRegistry.registerHazmat(ModItems.titanium_helmet, HazmatRegistry.fixRounding(titanium * helmet));
        HazmatRegistry.registerHazmat(ModItems.titanium_plate, HazmatRegistry.fixRounding(titanium * chest));
        HazmatRegistry.registerHazmat(ModItems.titanium_legs, HazmatRegistry.fixRounding(titanium * legs));
        HazmatRegistry.registerHazmat(ModItems.titanium_boots, HazmatRegistry.fixRounding(titanium * boots));
        HazmatRegistry.registerHazmat(ModItems.cobalt_helmet, HazmatRegistry.fixRounding(cobalt * helmet));
        HazmatRegistry.registerHazmat(ModItems.cobalt_plate, HazmatRegistry.fixRounding(cobalt * chest));
        HazmatRegistry.registerHazmat(ModItems.cobalt_legs, HazmatRegistry.fixRounding(cobalt * legs));
        HazmatRegistry.registerHazmat(ModItems.cobalt_boots, HazmatRegistry.fixRounding(cobalt * boots));
        HazmatRegistry.registerHazmat((Item)Items.field_151028_Y, HazmatRegistry.fixRounding(iron * helmet));
        HazmatRegistry.registerHazmat((Item)Items.field_151030_Z, HazmatRegistry.fixRounding(iron * chest));
        HazmatRegistry.registerHazmat((Item)Items.field_151165_aa, HazmatRegistry.fixRounding(iron * legs));
        HazmatRegistry.registerHazmat((Item)Items.field_151167_ab, HazmatRegistry.fixRounding(iron * boots));
        HazmatRegistry.registerHazmat((Item)Items.field_151169_ag, HazmatRegistry.fixRounding(gold * helmet));
        HazmatRegistry.registerHazmat((Item)Items.field_151171_ah, HazmatRegistry.fixRounding(gold * chest));
        HazmatRegistry.registerHazmat((Item)Items.field_151149_ai, HazmatRegistry.fixRounding(gold * legs));
        HazmatRegistry.registerHazmat((Item)Items.field_151151_aj, HazmatRegistry.fixRounding(gold * boots));
        HazmatRegistry.registerHazmat(ModItems.alloy_helmet, HazmatRegistry.fixRounding(alloy * helmet));
        HazmatRegistry.registerHazmat(ModItems.alloy_plate, HazmatRegistry.fixRounding(alloy * chest));
        HazmatRegistry.registerHazmat(ModItems.alloy_legs, HazmatRegistry.fixRounding(alloy * legs));
        HazmatRegistry.registerHazmat(ModItems.alloy_boots, HazmatRegistry.fixRounding(alloy * boots));
        HazmatRegistry.registerHazmat(ModItems.cmb_helmet, HazmatRegistry.fixRounding(cmb * helmet));
        HazmatRegistry.registerHazmat(ModItems.cmb_plate, HazmatRegistry.fixRounding(cmb * chest));
        HazmatRegistry.registerHazmat(ModItems.cmb_legs, HazmatRegistry.fixRounding(cmb * legs));
        HazmatRegistry.registerHazmat(ModItems.cmb_boots, HazmatRegistry.fixRounding(cmb * boots));
        HazmatRegistry.registerHazmat(ModItems.schrabidium_helmet, HazmatRegistry.fixRounding(schrab * helmet));
        HazmatRegistry.registerHazmat(ModItems.schrabidium_plate, HazmatRegistry.fixRounding(schrab * chest));
        HazmatRegistry.registerHazmat(ModItems.schrabidium_legs, HazmatRegistry.fixRounding(schrab * legs));
        HazmatRegistry.registerHazmat(ModItems.schrabidium_boots, HazmatRegistry.fixRounding(schrab * boots));
        HazmatRegistry.registerHazmat(ModItems.euphemium_helmet, HazmatRegistry.fixRounding(euph * helmet));
        HazmatRegistry.registerHazmat(ModItems.euphemium_plate, HazmatRegistry.fixRounding(euph * chest));
        HazmatRegistry.registerHazmat(ModItems.euphemium_legs, HazmatRegistry.fixRounding(euph * legs));
        HazmatRegistry.registerHazmat(ModItems.euphemium_boots, HazmatRegistry.fixRounding(euph * boots));
    }
}

