/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.forgefluid;

import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.FluidCombustionRecipes;
import com.hbm.inventory.FluidFlameRecipes;
import com.hbm.render.misc.EnumSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidTypeHandler {
    private static Map<String, FluidProperties> fluidProperties = new HashMap<String, FluidProperties>();
    public static final FluidProperties NONE = new FluidProperties(0, 0, 0, EnumSymbol.NONE, new FluidTrait[0]);

    public static void registerFluidProperties() {
        fluidProperties.put(FluidRegistry.WATER.getName(), new FluidProperties(0, 0, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.SPENTSTEAM.getName(), new FluidProperties(0, 0, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.STEAM.getName(), new FluidProperties(0, 0, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.HOTSTEAM.getName(), new FluidProperties(0, 0, 2, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.SUPERHOTSTEAM.getName(), new FluidProperties(0, 0, 3, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.ULTRAHOTSTEAM.getName(), new FluidProperties(0, 0, 4, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.COOLANT.getName(), new FluidProperties(1, 0, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.HOTCOOLANT.getName(), new FluidProperties(1, 0, 4, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.PERFLUOROMETHYL.getName(), new FluidProperties(1, 0, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(FluidRegistry.LAVA.getName(), new FluidProperties(4, 0, 0, EnumSymbol.NOWATER, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.HEAVYWATER.getName(), new FluidProperties(1, 0, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.HYDROGEN.getName(), new FluidProperties(1, 4, 0, 1.0f, EnumSymbol.CROYGENIC, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.DEUTERIUM.getName(), new FluidProperties(2, 4, 0, 1.2f, EnumSymbol.CROYGENIC, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.TRITIUM.getName(), new FluidProperties(3, 4, 0, 1.3f, EnumSymbol.RADIATION, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.OIL.getName(), new FluidProperties(2, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.HOTOIL.getName(), new FluidProperties(2, 3, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.CRACKOIL.getName(), new FluidProperties(2, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.HOTCRACKOIL.getName(), new FluidProperties(2, 3, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.HEAVYOIL.getName(), new FluidProperties(2, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.BITUMEN.getName(), new FluidProperties(2, 0, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.SMEAR.getName(), new FluidProperties(2, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.HEATINGOIL.getName(), new FluidProperties(2, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.RECLAIMED.getName(), new FluidProperties(2, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.PETROIL.getName(), new FluidProperties(1, 3, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.CHLORINE.getName(), new FluidProperties(3, 0, 0, EnumSymbol.OXIDIZER, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.PHOSGENE.getName(), new FluidProperties(4, 0, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.WOODOIL.getName(), new FluidProperties(2, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.COALCREOSOTE.getName(), new FluidProperties(3, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.COALOIL.getName(), new FluidProperties(2, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.COALGAS.getName(), new FluidProperties(1, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.COALGAS_LEADED.getName(), new FluidProperties(1, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.PETROIL_LEADED.getName(), new FluidProperties(1, 3, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.GASOLINE_LEADED.getName(), new FluidProperties(1, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.SYNGAS.getName(), new FluidProperties(1, 4, 2, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.FRACKSOL.getName(), new FluidProperties(1, 3, 3, EnumSymbol.ACID, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.LUBRICANT.getName(), new FluidProperties(2, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.NAPHTHA.getName(), new FluidProperties(2, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.DIESEL.getName(), new FluidProperties(1, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.LIGHTOIL.getName(), new FluidProperties(1, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.KEROSENE.getName(), new FluidProperties(1, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.GAS.getName(), new FluidProperties(1, 4, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.PETROLEUM.getName(), new FluidProperties(1, 4, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.AROMATICS.getName(), new FluidProperties(1, 4, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.UNSATURATEDS.getName(), new FluidProperties(1, 4, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.BIOGAS.getName(), new FluidProperties(1, 4, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.BIOFUEL.getName(), new FluidProperties(1, 2, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.ETHANOL.getName(), new FluidProperties(2, 3, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.FISHOIL.getName(), new FluidProperties(0, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.SUNFLOWEROIL.getName(), new FluidProperties(0, 1, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.COLLOID.getName(), new FluidProperties(0, 0, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.NITAN.getName(), new FluidProperties(2, 4, 1, 1.6f, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.UF6.getName(), new FluidProperties(4, 0, 2, 1.3f, EnumSymbol.RADIATION, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.PUF6.getName(), new FluidProperties(4, 0, 4, 1.4f, EnumSymbol.RADIATION, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.SAS3.getName(), new FluidProperties(5, 0, 4, 1.5f, EnumSymbol.RADIATION, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.SCHRABIDIC.getName(), new FluidProperties(5, 0, 5, 1.7f, EnumSymbol.ACID, FluidTrait.CORROSIVE_2));
        fluidProperties.put(ModForgeFluids.AMAT.getName(), new FluidProperties(6, 0, 6, 2.2f, EnumSymbol.ANTIMATTER, FluidTrait.AMAT));
        fluidProperties.put(ModForgeFluids.ASCHRAB.getName(), new FluidProperties(6, 1, 6, 2.5f, EnumSymbol.ANTIMATTER, FluidTrait.AMAT));
        fluidProperties.put(ModForgeFluids.ACID.getName(), new FluidProperties(3, 0, 1, 1.05f, EnumSymbol.OXIDIZER, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.SULFURIC_ACID.getName(), new FluidProperties(3, 0, 2, 1.3f, EnumSymbol.ACID, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.NITRIC_ACID.getName(), new FluidProperties(3, 0, 3, 1.4f, EnumSymbol.ACID, FluidTrait.CORROSIVE_2));
        fluidProperties.put(ModForgeFluids.SOLVENT.getName(), new FluidProperties(2, 3, 0, 1.45f, EnumSymbol.ACID, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.RADIOSOLVENT.getName(), new FluidProperties(3, 3, 0, 1.6f, EnumSymbol.ACID, FluidTrait.CORROSIVE_2));
        fluidProperties.put(ModForgeFluids.NITROGLYCERIN.getName(), new FluidProperties(0, 4, 4, 1.5f, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.LIQUID_OSMIRIDIUM.getName(), new FluidProperties(5, 0, 5, 1.8f, EnumSymbol.OXIDIZER, FluidTrait.CORROSIVE_2));
        fluidProperties.put(ModForgeFluids.MUD_FLUID.getName(), new FluidProperties(4, 0, 3, 1.5f, EnumSymbol.OXIDIZER, FluidTrait.CORROSIVE_2));
        fluidProperties.put(ModForgeFluids.CRYOGEL.getName(), new FluidProperties(2, 0, 0, EnumSymbol.CROYGENIC, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.OXYGEN.getName(), new FluidProperties(3, 0, 0, 1.1f, EnumSymbol.CROYGENIC, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.XENON.getName(), new FluidProperties(0, 0, 0, 1.25f, EnumSymbol.ASPHYXIANT, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.BALEFIRE.getName(), new FluidProperties(4, 4, 5, 2.4f, EnumSymbol.RADIATION, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.MERCURY.getName(), new FluidProperties(2, 0, 0, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.PAIN.getName(), new FluidProperties(2, 0, 1, EnumSymbol.ACID, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.WASTEFLUID.getName(), new FluidProperties(2, 0, 1, EnumSymbol.RADIATION, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.WASTEGAS.getName(), new FluidProperties(2, 0, 1, EnumSymbol.RADIATION, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.GASOLINE.getName(), new FluidProperties(2, 0, 1, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.EXPERIENCE.getName(), new FluidProperties(0, 0, 0, 1.1f, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.PLASMA_DT.getName(), new FluidProperties(0, 4, 0, EnumSymbol.RADIATION, FluidTrait.NO_CONTAINER, FluidTrait.NO_ID));
        fluidProperties.put(ModForgeFluids.PLASMA_HD.getName(), new FluidProperties(0, 4, 0, EnumSymbol.RADIATION, FluidTrait.NO_CONTAINER, FluidTrait.NO_ID));
        fluidProperties.put(ModForgeFluids.PLASMA_HT.getName(), new FluidProperties(0, 4, 0, EnumSymbol.RADIATION, FluidTrait.NO_CONTAINER, FluidTrait.NO_ID));
        fluidProperties.put(ModForgeFluids.PLASMA_PUT.getName(), new FluidProperties(2, 3, 1, EnumSymbol.RADIATION, FluidTrait.NO_CONTAINER, FluidTrait.NO_ID));
        fluidProperties.put(ModForgeFluids.PLASMA_MX.getName(), new FluidProperties(0, 4, 1, EnumSymbol.RADIATION, FluidTrait.NO_CONTAINER, FluidTrait.NO_ID));
        fluidProperties.put(ModForgeFluids.PLASMA_BF.getName(), new FluidProperties(4, 5, 4, EnumSymbol.RADIATION, FluidTrait.NO_CONTAINER, FluidTrait.NO_ID));
        fluidProperties.put(ModForgeFluids.IONGEL.getName(), new FluidProperties(1, 0, 4, EnumSymbol.NONE, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.UU_MATTER.getName(), new FluidProperties(6, 2, 6, 2.0f, EnumSymbol.ACID, FluidTrait.CORROSIVE));
        fluidProperties.put(ModForgeFluids.TOXIC_FLUID.getName(), new FluidProperties(3, 0, 4, EnumSymbol.RADIATION, FluidTrait.CORROSIVE_2));
        fluidProperties.put(ModForgeFluids.RADWATER_FLUID.getName(), new FluidProperties(2, 0, 0, EnumSymbol.RADIATION, new FluidTrait[0]));
        fluidProperties.put(ModForgeFluids.MUD_FLUID.getName(), new FluidProperties(4, 0, 1, EnumSymbol.ACID, FluidTrait.CORROSIVE_2));
        fluidProperties.put(ModForgeFluids.CORIUM_FLUID.getName(), new FluidProperties(4, 0, 2, EnumSymbol.RADIATION, FluidTrait.CORROSIVE_2));
        fluidProperties.put(ModForgeFluids.VOLCANIC_LAVA_FLUID.getName(), new FluidProperties(4, 1, 1, EnumSymbol.NOWATER, new FluidTrait[0]));
        long baseline = 100000L;
        double demandVeryLow = 0.5;
        double demandLow = 1.0;
        double demandMedium = 1.5;
        double demandHigh = 2.0;
        double complexityRefinery = 1.1;
        double complexityFraction = 1.05;
        double complexityCracking = 1.25;
        double complexityCoker = 1.25;
        double complexityChemplant = 1.1;
        double complexityLubed = 1.15;
        double complexityLeaded = 1.5;
        double complexityVacuum = 3.0;
        double complexityReform = 2.5;
        double complexityHydro = 2.0;
        double flammabilityLow = 0.25;
        double flammabilityNormal = 1.0;
        double flammabilityHigh = 2.0;
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.OIL, (double)baseline * flammabilityLow * demandLow);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HOTOIL, (double)baseline * flammabilityLow * demandLow);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.OIL_DS, (double)baseline * flammabilityLow * demandLow * complexityHydro);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HOTOIL_DS, (double)baseline * flammabilityLow * demandLow * complexityHydro);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.CRACKOIL, (double)baseline * flammabilityLow * demandLow * complexityCracking);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HOTCRACKOIL, (double)baseline * flammabilityLow * demandLow * complexityCracking);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.CRACKOIL_DS, (double)baseline * flammabilityLow * demandLow * complexityCracking * complexityHydro);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HOTCRACKOIL_DS, (double)baseline * flammabilityLow * demandLow * complexityCracking * complexityHydro);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.OIL_COKER, (double)baseline * flammabilityLow * demandLow * complexityCoker);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.GAS, (double)baseline * flammabilityNormal * demandVeryLow, 1.5, FluidCombustionRecipes.FuelGrade.GAS);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.GAS_COKER, (double)baseline * flammabilityNormal * demandVeryLow * complexityCoker, 1.5, FluidCombustionRecipes.FuelGrade.GAS);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HEAVYOIL, (double)baseline / 0.5 * flammabilityLow * demandLow * complexityRefinery, 1.25, FluidCombustionRecipes.FuelGrade.LOW);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.SMEAR, (double)baseline / 0.35 * flammabilityLow * demandLow * complexityRefinery * complexityFraction, 1.25, FluidCombustionRecipes.FuelGrade.LOW);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.RECLAIMED, (double)baseline / 0.28 * flammabilityLow * demandLow * complexityRefinery * complexityFraction * complexityChemplant, 1.25, FluidCombustionRecipes.FuelGrade.LOW);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.PETROIL, (double)baseline / 0.28 * flammabilityLow * demandLow * complexityRefinery * complexityFraction * complexityChemplant * complexityLubed, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.PETROIL_LEADED, (double)baseline / 0.28 * flammabilityLow * demandLow * complexityRefinery * complexityFraction * complexityChemplant * complexityLubed * complexityLeaded, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HEATINGOIL, (double)baseline / 0.31 * flammabilityNormal * demandLow * complexityRefinery * complexityFraction * complexityFraction, 1.25, FluidCombustionRecipes.FuelGrade.LOW);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.NAPHTHA, (double)baseline / 0.25 * flammabilityLow * demandLow * complexityRefinery, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.NAPHTHA_DS, (double)baseline / 0.25 * flammabilityLow * demandLow * complexityRefinery * complexityHydro, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.NAPHTHA_CRACK, (double)baseline / 0.4 * flammabilityLow * demandLow * complexityRefinery * complexityCracking, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.NAPHTHA_COKER, (double)baseline / 0.25 * flammabilityLow * demandLow * complexityCoker, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.GASOLINE, (double)baseline / 0.2 * flammabilityNormal * demandLow * complexityRefinery * complexityChemplant, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.GASOLINE_LEADED, (double)baseline / 0.2 * flammabilityNormal * demandLow * complexityRefinery * complexityChemplant * complexityLeaded, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        double diesel = (double)baseline / 0.21 * flammabilityNormal * demandLow * complexityRefinery * complexityFraction;
        double diesel_crack = (double)baseline / 0.28 * flammabilityNormal * demandLow * complexityRefinery * complexityCracking * complexityFraction;
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.DIESEL, diesel, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.DIESEL_CRACK, diesel_crack, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.DIESEL_REFORM, diesel * complexityReform, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.DIESEL_CRACK_REFORM, diesel_crack * complexityReform, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.LIGHTOIL, (double)baseline / 0.15 * flammabilityNormal * demandHigh * complexityRefinery, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.LIGHTOIL_DS, (double)baseline / 0.15 * flammabilityNormal * demandHigh * complexityRefinery * complexityHydro, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.LIGHTOIL_CRACK, (double)baseline / 0.3 * flammabilityNormal * demandHigh * complexityRefinery * complexityCracking, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        double kerosene = (double)baseline / 0.09 * flammabilityNormal * demandHigh * complexityRefinery * complexityFraction;
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.KEROSENE, kerosene, 1.5, FluidCombustionRecipes.FuelGrade.AERO);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.KEROSENE_REFORM, kerosene * complexityReform, 1.5, FluidCombustionRecipes.FuelGrade.AERO);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.PETROLEUM, (double)baseline / 0.1 * flammabilityNormal * demandMedium * complexityRefinery, 1.5, FluidCombustionRecipes.FuelGrade.GAS);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.AROMATICS, (double)baseline / 0.15 * flammabilityLow * demandHigh * complexityRefinery * complexityCracking);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.UNSATURATEDS, (double)baseline / 0.15 * flammabilityHigh * demandHigh * complexityRefinery * complexityCracking);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.NITAN, kerosene * 25.0, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.BALEFIRE, kerosene * 100.0, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HEAVYOIL_VACUUM, (double)baseline / 0.4 * flammabilityLow * demandLow * complexityVacuum, 1.25, FluidCombustionRecipes.FuelGrade.LOW);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.REFORMATE, (double)baseline / 0.25 * flammabilityNormal * demandHigh * complexityVacuum, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.LIGHTOIL_VACUUM, (double)baseline / 0.2 * flammabilityNormal * demandHigh * complexityVacuum, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.SOURGAS, (double)baseline / 0.15 * flammabilityLow * demandVeryLow * complexityVacuum);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.XYLENE, (double)baseline / 0.15 * flammabilityNormal * demandMedium * complexityVacuum * complexityFraction, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HEATINGOIL_VACUUM, (double)baseline / 0.24 * flammabilityNormal * demandLow * complexityVacuum * complexityFraction, 1.25, FluidCombustionRecipes.FuelGrade.LOW);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.REFORMGAS, (double)baseline / 0.06 * flammabilityHigh * demandLow * complexityVacuum * complexityFraction, 1.5, FluidCombustionRecipes.FuelGrade.GAS);
        double coaloil = 4000000.0 * flammabilityLow * demandLow * complexityChemplant;
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.COALOIL, coaloil);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.COALGAS, coaloil / 0.3 * flammabilityNormal * demandMedium * complexityChemplant * complexityFraction, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.COALGAS_LEADED, coaloil / 0.3 * flammabilityNormal * demandMedium * complexityChemplant * complexityFraction * complexityLeaded, 1.5, FluidCombustionRecipes.FuelGrade.MEDIUM);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.ETHANOL, 275000.0, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.BIOGAS, 250000.0 * flammabilityLow, 1.25, FluidCombustionRecipes.FuelGrade.GAS);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.BIOFUEL, 500000.0, 2.5, FluidCombustionRecipes.FuelGrade.HIGH);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.WOODOIL, 110000.0);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.COALCREOSOTE, 250000.0);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.FISHOIL, 75000.0);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.SUNFLOWEROIL, 50000.0);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.SOLVENT, 100000.0);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.RADIOSOLVENT, 150000.0);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.SYNGAS, coaloil * 1.5, 1.25, FluidCombustionRecipes.FuelGrade.GAS);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.HYDROGEN, 5000.0, 3.0, FluidCombustionRecipes.FuelGrade.GAS);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.DEUTERIUM, 5000.0, 3.0, FluidCombustionRecipes.FuelGrade.GAS);
        FluidTypeHandler.registerCalculatedFuel(ModForgeFluids.TRITIUM, 5000.0, 3.0, FluidCombustionRecipes.FuelGrade.GAS);
    }

    private static void registerCalculatedFuel(Fluid fluid, double base) {
        FluidTypeHandler.registerCalculatedFuel(fluid, base, 0.0, null);
    }

    private static void registerCalculatedFuel(Fluid fluid, double base, double combustMult, FluidCombustionRecipes.FuelGrade grade) {
        long flammable = (long)(base / 1000.0);
        long combustible = (long)(base * combustMult);
        flammable = FluidTypeHandler.round(flammable);
        combustible = FluidTypeHandler.round(combustible);
        if (flammable > 0L) {
            FluidFlameRecipes.addBurnableFluid(fluid, flammable);
        }
        if (combustible > 0L && grade != null) {
            FluidCombustionRecipes.addFuel(fluid, grade, combustible);
        }
    }

    private static long round(long l) {
        if (l > 1000000000L) {
            return l - l % 10000000L;
        }
        if (l > 100000000L) {
            return l - l % 1000000L;
        }
        if (l > 10000000L) {
            return l - l % 100000L;
        }
        if (l > 1000000L) {
            return l - l % 10000L;
        }
        if (l > 100000L) {
            return l - l % 1000L;
        }
        if (l > 10000L) {
            return l - l % 100L;
        }
        if (l > 1000L) {
            return l - l % 10L;
        }
        return l;
    }

    public static FluidProperties getProperties(Fluid f) {
        if (f == null) {
            return NONE;
        }
        FluidProperties p = fluidProperties.get(f.getName());
        return p != null ? p : NONE;
    }

    public static FluidProperties getProperties(FluidStack f) {
        if (f == null) {
            return NONE;
        }
        return FluidTypeHandler.getProperties(f.getFluid());
    }

    public static float getDFCEfficiency(Fluid f) {
        FluidProperties prop = FluidTypeHandler.getProperties(f);
        return prop.dfcFuel;
    }

    public static boolean isAntimatter(Fluid f) {
        return FluidTypeHandler.containsTrait(f, FluidTrait.AMAT);
    }

    public static boolean isCorrosivePlastic(Fluid f) {
        return FluidTypeHandler.containsTrait(f, FluidTrait.CORROSIVE) || FluidTypeHandler.containsTrait(f, FluidTrait.CORROSIVE_2);
    }

    public static boolean isCorrosiveIron(Fluid f) {
        return FluidTypeHandler.containsTrait(f, FluidTrait.CORROSIVE_2);
    }

    public static boolean isHot(Fluid f) {
        if (f == null) {
            return false;
        }
        return f.getTemperature() >= 373;
    }

    public static boolean noID(Fluid f) {
        return FluidTypeHandler.containsTrait(f, FluidTrait.NO_ID);
    }

    public static boolean noContainer(Fluid f) {
        return FluidTypeHandler.containsTrait(f, FluidTrait.NO_CONTAINER);
    }

    public static boolean containsTrait(Fluid f, FluidTrait t) {
        if (f == null) {
            return false;
        }
        FluidProperties p = fluidProperties.get(f.getName());
        if (p == null) {
            return false;
        }
        return p.traits.contains((Object)t);
    }

    public static class FluidProperties {
        public final int poison;
        public final int flammability;
        public final int reactivity;
        public final float dfcFuel;
        public final EnumSymbol symbol;
        public final List<FluidTrait> traits = new ArrayList<FluidTrait>();

        public FluidProperties(int p, int f, int r, EnumSymbol symbol, FluidTrait ... traits) {
            this(p, f, r, 0.0f, symbol, traits);
        }

        public FluidProperties(int p, int f, int r, float dfc, EnumSymbol symbol, FluidTrait ... traits) {
            this.poison = p;
            this.flammability = f;
            this.reactivity = r;
            this.dfcFuel = dfc;
            this.symbol = symbol;
            this.traits.addAll(Arrays.asList(traits));
        }
    }

    public static enum FluidTrait {
        AMAT,
        CORROSIVE,
        CORROSIVE_2,
        NO_CONTAINER,
        NO_ID;

    }
}

