/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.forgefluid;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidContainerRegistry {
    private static Map<Item, FluidContainerData> containers = new HashMap<Item, FluidContainerData>();
    private static Map<Pair<Item, Fluid>, Item> containerToItem = new HashMap<Pair<Item, Fluid>, Item>();

    public static void registerContainer(Item item, Item container, FluidStack fluid) {
        containers.put(item, new FluidContainerData(container, fluid));
        containerToItem.put((Pair<Item, Fluid>)Pair.of((Object)container, (Object)fluid.getFluid()), item);
    }

    public static boolean hasFluid(Item item) {
        return containers.containsKey(item);
    }

    public static FluidStack getFluidFromItem(Item item) {
        FluidContainerData data = containers.get(item);
        if (data == null) {
            return null;
        }
        return data.containedFluid.copy();
    }

    public static Item getContainerItem(Item item) {
        FluidContainerData data = containers.get(item);
        if (data == null) {
            return Items.field_190931_a;
        }
        return data.container;
    }

    public static Item getFullContainer(Item item, Fluid f) {
        Item i = containerToItem.get(Pair.of((Object)item, (Object)f));
        if (i == null) {
            return Items.field_190931_a;
        }
        return i;
    }

    private static class FluidContainerData {
        public Item container;
        public FluidStack containedFluid;

        public FluidContainerData(Item container, FluidStack fluid) {
            this.container = container;
            this.containedFluid = fluid;
        }
    }
}

