/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.CompatibilityConfig;
import com.hbm.explosion.ExplosionNT;
import com.hbm.lib.ModDamageSource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class EntityShrapnel
extends EntityThrowable {
    public static final DataParameter<Byte> TRAIL = EntityDataManager.func_187226_a(EntityShrapnel.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityShrapnel(World world) {
        super(world);
    }

    public EntityShrapnel(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    public EntityShrapnel(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public void func_70088_a() {
        this.field_70180_af.func_187214_a(TRAIL, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.spawnFlameParticle();
        }
    }

    private void spawnFlameParticle() {
        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
    }

    protected void func_70184_a(@NotNull RayTraceResult mop) {
        if (!CompatibilityConfig.isWarDim(this.field_70170_p)) {
            this.func_70106_y();
            return;
        }
        this.handleEntityImpact(mop);
        this.handleBlockImpact(mop);
    }

    private void handleEntityImpact(RayTraceResult mop) {
        if (mop.field_72308_g != null) {
            mop.field_72308_g.func_70097_a(ModDamageSource.shrapnel, 15.0f);
        }
    }

    private void handleBlockImpact(RayTraceResult mop) {
        if (this.field_70173_aa <= 5) {
            return;
        }
        this.func_70106_y();
        byte trailType = (Byte)this.field_70180_af.func_187225_a(TRAIL);
        if (trailType == 2) {
            this.processVolcanoImpact(mop);
        } else if (trailType == 3) {
            this.placeMudBlock(mop);
        } else {
            this.spawnLavaParticles();
        }
        this.playExtinguishSound();
    }

    private void processVolcanoImpact(RayTraceResult mop) {
        if (this.field_70170_p.field_72995_K || mop.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos impactPos = mop.func_178782_a().func_177984_a();
        if (this.field_70181_x < -0.2 && this.field_70170_p.func_180495_p(impactPos).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, impactPos)) {
            this.field_70170_p.func_175656_a(impactPos, ModBlocks.volcanic_lava_block.func_176223_P());
            this.spreadGas(mop);
        }
        if (this.field_70181_x > 0.0) {
            this.triggerExplosion(mop);
        }
    }

    private void spreadGas(RayTraceResult mop) {
        BlockPos origin = mop.func_178782_a();
        for (int x = origin.func_177958_n() - 1; x <= origin.func_177958_n() + 1; ++x) {
            for (int y = origin.func_177956_o(); y <= origin.func_177956_o() + 2; ++y) {
                for (int z = origin.func_177952_p() - 1; z <= origin.func_177952_p() + 1; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150350_a) continue;
                    this.field_70170_p.func_175656_a(pos, ModBlocks.gas_monoxide.func_176223_P());
                }
            }
        }
    }

    private void triggerExplosion(RayTraceResult mop) {
        ExplosionNT explosion = new ExplosionNT(this.field_70170_p, null, (double)mop.func_178782_a().func_177958_n() + 0.5, (double)mop.func_178782_a().func_177956_o() + 0.5, (double)mop.func_178782_a().func_177952_p() + 0.5, 7.0f);
        explosion.addAttrib(ExplosionNT.ExAttrib.NODROP);
        explosion.addAttrib(ExplosionNT.ExAttrib.LAVA_V);
        explosion.addAttrib(ExplosionNT.ExAttrib.NOSOUND);
        explosion.addAttrib(ExplosionNT.ExAttrib.ALLMOD);
        explosion.addAttrib(ExplosionNT.ExAttrib.NOHURT);
        explosion.explode();
    }

    private void placeMudBlock(RayTraceResult mop) {
        BlockPos targetPos = mop.func_178782_a();
        if (targetPos == null) {
            return;
        }
        if (targetPos.func_177956_o() < 255 && targetPos.func_177956_o() > 0) {
            targetPos = targetPos.func_177984_a();
        }
        if (this.field_70170_p.func_180495_p(targetPos).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, targetPos)) {
            this.field_70170_p.func_175656_a(targetPos, ModBlocks.mud_block.func_176223_P());
        }
    }

    private void spawnLavaParticles() {
        for (int i = 0; i < 5; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void playExtinguishSound() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187659_cY, SoundCategory.HOSTILE, 1.0f, 1.0f);
    }

    public void setTrail(boolean enabled) {
        this.field_70180_af.func_187227_b(TRAIL, (Object)((byte)(enabled ? 1 : 0)));
    }

    public void setVolcano(boolean enabled) {
        this.field_70180_af.func_187227_b(TRAIL, (Object)((byte)(enabled ? 2 : 0)));
    }

    public void setWatz(boolean enabled) {
        this.field_70180_af.func_187227_b(TRAIL, (Object)((byte)(enabled ? 3 : 0)));
    }
}

