/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectable;
import com.hbm.config.WeaponConfig;
import com.hbm.entity.logic.EntityChunky;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.interfaces.IConstantRenderer;
import com.hbm.main.MainRegistry;
import com.hbm.packet.LoopedEntitySoundPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityMissileBaseAdvanced
extends EntityChunky
implements IConstantRenderer,
IRadarDetectable {
    public static final DataParameter<Integer> HEALTH = EntityDataManager.func_187226_a(EntityMissileBaseAdvanced.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final double particleSpeed = 1.75;
    int startX;
    int startZ;
    int targetX;
    int targetZ;
    double velocity;
    double decelY;
    double accelXZ;
    boolean isCluster = false;
    public static double acceleration = 1.0;
    public int health;

    public EntityMissileBaseAdvanced(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
        this.startX = (int)this.field_70165_t;
        this.startZ = (int)this.field_70161_v;
        this.targetX = (int)this.field_70165_t;
        this.targetZ = (int)this.field_70161_v;
        this.health = this.getHP();
    }

    public EntityMissileBaseAdvanced(World world, float x, float y, float z, int a, int b) {
        super(world);
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.startX = (int)x;
        this.startZ = (int)z;
        this.targetX = a;
        this.targetZ = b;
        this.field_70181_x = 2.0;
        Vec3d vector = new Vec3d((double)(this.targetX - this.startX), 0.0, (double)(this.targetZ - this.startZ));
        this.accelXZ = this.decelY = 1.0 / vector.func_72433_c();
        this.decelY *= 2.0;
        this.velocity = 0.0;
        this.func_70105_a(1.5f, 9.0f);
        this.health = this.getHP();
    }

    public int getHP() {
        int n;
        switch (this.getTargetType()) {
            case MISSILE_TIER0: {
                n = 20;
                break;
            }
            case MISSILE_TIER1: {
                n = 30;
                break;
            }
            case MISSILE_TIER2: {
                n = 40;
                break;
            }
            case MISSILE_TIER3: {
                n = 50;
                break;
            }
            case MISSILE_TIER4: {
                n = 60;
                break;
            }
            default: {
                n = 10;
            }
        }
        return n;
    }

    public void setAcceleration(double multiplier) {
        acceleration = multiplier;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.health -= (int)amount;
            if (this.health <= 0) {
                this.func_70106_y();
                this.killMissile();
            }
            this.func_184212_Q().func_187227_b(HEALTH, (Object)this.health);
        }
        return true;
    }

    private void killMissile() {
        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true, false, true);
        ExplosionLarge.spawnShrapnelShower(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 15, 0.075);
        if (WeaponConfig.dropMissileParts) {
            ExplosionLarge.spawnMissileDebris(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, 0.25, this.getDebris(), this.getDebrisRareDrop());
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HEALTH, (Object)this.health);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.field_70159_w = nbt.func_74769_h("moX");
        this.field_70181_x = nbt.func_74769_h("moY");
        this.field_70179_y = nbt.func_74769_h("moZ");
        this.field_70165_t = nbt.func_74769_h("poX");
        this.field_70163_u = nbt.func_74769_h("poY");
        this.field_70161_v = nbt.func_74769_h("poZ");
        this.decelY = nbt.func_74769_h("decel");
        this.accelXZ = nbt.func_74769_h("accel");
        this.targetX = nbt.func_74762_e("tX");
        this.targetZ = nbt.func_74762_e("tZ");
        this.startX = nbt.func_74762_e("sX");
        this.startZ = nbt.func_74762_e("sZ");
        this.velocity = nbt.func_74769_h("veloc");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("moX", this.field_70159_w);
        nbt.func_74780_a("moY", this.field_70181_x);
        nbt.func_74780_a("moZ", this.field_70179_y);
        nbt.func_74780_a("poX", this.field_70165_t);
        nbt.func_74780_a("poY", this.field_70163_u);
        nbt.func_74780_a("poZ", this.field_70161_v);
        nbt.func_74780_a("decel", this.decelY);
        nbt.func_74780_a("accel", this.accelXZ);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tZ", this.targetZ);
        nbt.func_74768_a("sX", this.startX);
        nbt.func_74768_a("sZ", this.startZ);
        nbt.func_74780_a("veloc", this.velocity);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa < 10 && this.field_70170_p.field_72995_K) {
            ExplosionLarge.spawnParticlesRadial(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 15);
            return;
        }
        this.func_184212_Q().func_187227_b(HEALTH, (Object)this.health);
        this.doMovement();
        this.doContrail();
        this.checkImpact();
        this.checkCluster();
        PacketDispatcher.wrapper.sendToAll((IMessage)new LoopedEntitySoundPacket(this.func_145782_y()));
    }

    public void doContrail() {
        if (this.field_70170_p.field_72995_K) {
            Vec3 v = Vec3.createVectorHelper(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            v = v.normalize();
            int i = 0;
            while ((double)i < this.velocity) {
                MainRegistry.proxy.spawnParticle(this.field_70165_t - v.xCoord * (double)i, this.field_70163_u - v.yCoord * (double)i, this.field_70161_v - v.zCoord * (double)i, "exDark", new float[]{(float)(this.field_70159_w * -1.75), (float)(this.field_70181_x * -1.75), (float)(this.field_70179_y * -1.75)});
                ++i;
            }
        }
    }

    public void doMovement() {
        double oldPosY = this.field_70163_u;
        this.func_70012_b(this.field_70165_t + this.field_70159_w * this.velocity, this.field_70163_u + this.field_70181_x * this.velocity, this.field_70161_v + this.field_70179_y * this.velocity, (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI), (float)(Math.atan2(this.field_70181_x, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 180.0 / Math.PI) - 90.0f);
        this.field_70167_r = oldPosY;
        this.field_70181_x -= this.decelY * this.velocity;
        Vec3 vector = Vec3.createVectorHelper(this.targetX - this.startX, 0.0, this.targetZ - this.startZ);
        vector = vector.normalize();
        vector.xCoord *= this.accelXZ * this.velocity;
        vector.zCoord *= this.accelXZ * this.velocity;
        if (this.field_70181_x > 0.0) {
            this.field_70159_w += vector.xCoord;
            this.field_70179_y += vector.zCoord;
        }
        if (this.field_70181_x < 0.0) {
            this.field_70159_w -= vector.xCoord;
            this.field_70179_y -= vector.zCoord;
        }
        if (this.velocity < 5.0) {
            this.velocity += 0.005 * acceleration;
        }
    }

    public void checkCluster() {
        if (this.isCluster && !this.field_70170_p.field_72995_K && this.field_70163_u < 300.0 && this.field_70181_x < -1.0) {
            this.cluster();
            this.func_70106_y();
        }
    }

    public void checkImpact() {
        Block b = this.field_70170_p.func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)).func_177230_c();
        if (b != Blocks.field_150350_a && b != Blocks.field_150355_j && b != Blocks.field_150358_i || this.field_70163_u < 1.0) {
            if (this.field_70163_u < 1.0) {
                this.func_70012_b((int)this.field_70165_t, this.field_70170_p.func_189649_b((int)this.field_70165_t, (int)this.field_70161_v), (int)this.field_70161_v, 0.0f, 0.0f);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 100) {
                this.onImpact();
            }
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 5000.0;
    }

    public abstract void onImpact();

    public abstract List<ItemStack> getDebris();

    public abstract ItemStack getDebrisRareDrop();

    public void cluster() {
    }
}

