/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.missile;

import api.hbm.entity.IRadarDetectable;
import com.hbm.config.WeaponConfig;
import com.hbm.entity.missile.EntityMIRV;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.items.ModItems;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityMissileAntiBallistic
extends EntityMissileBaseAdvanced {
    private static final int explosionRange = 25;
    private static final int dmg = 50;
    public Entity tracking;
    public static final int activationTimer = 40;
    public static final double baseSpeed = 1.5;
    private static final int maxSpeed = 10;

    public EntityMissileAntiBallistic(World world) {
        super(world);
        this.func_70105_a(1.0f, 8.0f);
    }

    @Override
    public void doMovement() {
        if (this.velocity < 10.0) {
            this.velocity += 0.1;
        }
        if (this.field_70173_aa < 40) {
            this.field_70181_x = 1.5;
        } else {
            Entity prevTracking = this.tracking;
            if (this.tracking == null || this.tracking.field_70128_L) {
                this.targetMissile();
            }
            if (this.field_70170_p.field_72995_K && prevTracking == null && this.tracking != null) {
                ExplosionLarge.spawnShock(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 24, 3.0);
            }
            if (this.field_70173_aa > 600 || this.field_70163_u > 5000.0) {
                this.func_70106_y();
            } else if (this.tracking != null && !this.tracking.field_70128_L) {
                this.aimAtTarget();
            }
        }
        this.func_70012_b(this.field_70165_t + this.field_70159_w * this.velocity, this.field_70163_u + this.field_70181_x * this.velocity, this.field_70161_v + this.field_70179_y * this.velocity, (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI), (float)(Math.atan2(this.field_70181_x, MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) * 180.0 / Math.PI) - 90.0f);
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI) - 90.0f;
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    private void targetMissile() {
        List listOfMissiles = this.field_70170_p.func_72839_b(null, new AxisAlignedBB(this.field_70165_t - (double)WeaponConfig.radarRange, 0.0, this.field_70161_v - (double)WeaponConfig.radarRange, this.field_70165_t + (double)WeaponConfig.radarRange, 5000.0, this.field_70161_v + (double)WeaponConfig.radarRange));
        Entity target = null;
        double closest = Double.MAX_VALUE;
        for (Entity e : listOfMissiles) {
            double dis;
            if (e instanceof EntityMissileAntiBallistic || !(e instanceof EntityMissileBaseAdvanced) && !(e instanceof EntityMissileCustom) && !(e instanceof EntityMIRV) || !((dis = Math.pow(e.field_70165_t - this.field_70165_t, 2.0) + Math.pow(e.field_70163_u - this.field_70163_u, 2.0) + Math.pow(e.field_70161_v - this.field_70161_v, 2.0)) < closest)) continue;
            closest = dis;
            target = e;
        }
        this.tracking = target;
    }

    protected void aimAtTarget() {
        Vec3 delta = Vec3.createVectorHelper(this.tracking.field_70165_t - this.field_70165_t, this.tracking.field_70163_u - this.field_70163_u, this.tracking.field_70161_v - this.field_70161_v);
        double intercept = delta.length() / (1.5 * this.velocity);
        Vec3 predicted = Vec3.createVectorHelper(this.tracking.field_70165_t + (this.tracking.field_70165_t - this.tracking.field_70142_S) * intercept, this.tracking.field_70163_u + (this.tracking.field_70163_u - this.tracking.field_70137_T) * intercept, this.tracking.field_70161_v + (this.tracking.field_70161_v - this.tracking.field_70136_U) * intercept);
        Vec3 motion = Vec3.createVectorHelper(predicted.xCoord - this.field_70165_t, predicted.yCoord - this.field_70163_u, predicted.zCoord - this.field_70161_v).normalize();
        if (delta.length() < 25.0 && 40 < this.field_70173_aa) {
            this.func_70106_y();
            ExplosionLarge.explodeArea(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 25.0f, 50.0f, true, false, false);
        }
        this.field_70159_w = motion.xCoord * 1.5;
        this.field_70181_x = motion.yCoord * 1.5;
        this.field_70179_y = motion.zCoord * 1.5;
    }

    @Override
    public IRadarDetectable.RadarTargetType getTargetType() {
        return IRadarDetectable.RadarTargetType.MISSILE_AB;
    }

    @Override
    public List<ItemStack> getDebris() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(ModItems.plate_titanium, 4));
        list.add(new ItemStack(ModItems.thruster_small, 1));
        return list;
    }

    @Override
    public ItemStack getDebrisRareDrop() {
        return new ItemStack(ModItems.thruster_small);
    }

    @Override
    public void onImpact() {
        ExplosionLarge.explode(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0f, true, true, true);
    }
}

