/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.entity.logic.IChunkLoader;
import com.hbm.main.MainRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityChunky
extends Entity
implements IChunkLoader {
    private ForgeChunkManager.Ticket loaderTicket;
    private List<ChunkPos> loadedChunks = new ArrayList<ChunkPos>();

    public EntityChunky(World worldIn) {
        super(worldIn);
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    protected void func_70088_a() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket != ticket) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.loaderTicket);
            }
            this.loaderTicket = ticket;
            this.loaderTicket.setChunkListDepth(7);
            this.loaderTicket.bindEntity((Entity)this);
            this.forceLoadChunk(this.loaderTicket, this.field_70176_ah, this.field_70164_aj);
        }
    }

    @Override
    public void loadNeighboringChunks(int newChunkX, int newChunkZ, int oldChunkX, int oldChunkZ) {
        if (!(this.field_70170_p.field_72995_K || this.loaderTicket == null || newChunkX == oldChunkX && newChunkZ == oldChunkZ)) {
            this.loadedChunks.clear();
            this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ));
            if (this.field_70159_w != 0.0 && this.field_70179_y != 0.0) {
                int offsetX = this.field_70159_w > 0.0 ? 1 : -1;
                int offsetZ = this.field_70179_y > 0.0 ? 1 : -1;
                this.loadedChunks.add(new ChunkPos(newChunkX + offsetX, newChunkZ));
                this.loadedChunks.add(new ChunkPos(newChunkX, newChunkZ + offsetZ));
                this.loadedChunks.add(new ChunkPos(newChunkX + offsetX, newChunkZ + offsetZ));
            }
            for (ChunkPos chunk : this.loadedChunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkPos)chunk);
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.loaderTicket);
    }
}

