/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.interfaces.IConstantRenderer;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNukeTorex
extends Entity
implements IConstantRenderer {
    public static final DataParameter<Float> SCALE = EntityDataManager.func_187226_a(EntityNukeTorex.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityNukeTorex.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final int firstCondenseHeight = 130;
    public static final int secondCondenseHeight = 170;
    public static final int maxCloudlets = 20000;
    public static final double nr1 = 2.5;
    public static final double ng1 = 1.3;
    public static final double nb1 = 0.4;
    public static final double nr2 = 0.1;
    public static final double ng2 = 0.075;
    public static final double nb2 = 0.05;
    public static final double br1 = 1.0;
    public static final double bg1 = 2.0;
    public static final double bb1 = 0.5;
    public static final double br2 = 0.1;
    public static final double bg2 = 0.1;
    public static final double bb2 = 0.1;
    public double coreHeight = 3.0;
    public double convectionHeight = 3.0;
    public double torusWidth = 3.0;
    public double rollerSize = 1.0;
    public double heat = 1.0;
    public double lastSpawnY = -1.0;
    public ArrayList<Cloudlet> cloudlets = new ArrayList();
    public long startTime = 0L;
    public int maxAge = 1000;
    public float humidity = -1.0f;

    public EntityNukeTorex(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(20.0f, 40.0f);
        this.field_70178_ae = true;
        this.field_70158_ak = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("scale")) {
            this.setScale(nbt.func_74760_g("scale"));
        }
        if (nbt.func_74764_b("type")) {
            this.field_70180_af.func_187227_b(TYPE, (Object)nbt.func_74771_c("type"));
        }
        if (nbt.func_74764_b("time")) {
            this.startTime = nbt.func_74763_f("time");
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74776_a("scale", ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue());
        nbt.func_74774_a("type", ((Byte)this.field_70180_af.func_187225_a(TYPE)).byteValue());
        nbt.func_74772_a("time", this.startTime);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            long time = this.field_70170_p.func_82737_E();
            if (time < this.startTime || time - this.startTime > (long)this.maxAge) {
                this.func_70106_y();
            }
        } else {
            int i;
            double s = this.getScale();
            double cs = 1.5;
            if (this.field_70173_aa == 1) {
                this.setScale((float)s);
            }
            if (this.humidity == -1.0f) {
                this.humidity = this.field_70170_p.func_180494_b(this.func_180425_c()).func_76727_i();
            }
            if (this.lastSpawnY == -1.0) {
                this.lastSpawnY = this.field_70163_u - 3.0;
            }
            int spawnTarget = Math.max(this.field_70170_p.func_189649_b((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70161_v)) - 3, 1);
            double moveSpeed = 0.5;
            this.lastSpawnY = Math.abs((double)spawnTarget - this.lastSpawnY) < moveSpeed ? (double)spawnTarget : (this.lastSpawnY += moveSpeed * Math.signum((double)spawnTarget - this.lastSpawnY));
            double range = (this.torusWidth - this.rollerSize) * 0.5;
            double simSpeed = this.getSimulationSpeed();
            int lifetime = Math.min(this.field_70173_aa * this.field_70173_aa + 200, this.maxAge - this.field_70173_aa + 200);
            int toSpawn = (int)(0.6 * Math.min((double)Math.max(0, 20000 - this.cloudlets.size()), Math.ceil(10.0 * simSpeed * simSpeed * Math.min(1.0, 1200.0 / (double)lifetime))));
            for (i = 0; i < toSpawn; ++i) {
                double x2 = this.field_70165_t + this.field_70146_Z.nextGaussian() * range;
                double z = this.field_70161_v + this.field_70146_Z.nextGaussian() * range;
                Cloudlet cloud = new Cloudlet(x2, this.lastSpawnY, z, (float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI), 0, lifetime);
                cloud.setScale((float)(Math.sqrt(s) * 3.0 + (double)this.field_70173_aa * 0.0025 * s), (float)(Math.sqrt(s) * 3.0 + (double)this.field_70173_aa * 0.0025 * 6.0 * cs * s));
                this.cloudlets.add(cloud);
            }
            if ((double)this.field_70173_aa < 120.0 * s) {
                this.field_70170_p.func_175702_c(2);
            }
            if ((double)this.field_70173_aa * 2.0 < 160.0) {
                int cloudCount = (int)Math.min((double)this.field_70173_aa * 2.0, 100.0);
                int shockLife = (int)Math.max(s * 300.0 - (double)this.field_70173_aa * 2.0 * 10.0, 60.0);
                for (int i2 = 0; i2 < cloudCount; ++i2) {
                    Vec3 vec = Vec3.createVectorHelper(((double)this.field_70173_aa + this.field_70146_Z.nextDouble() * 2.0 - 2.0) * 2.0, 0.0, 0.0);
                    float rot = (float)(Math.PI * 2 * this.field_70146_Z.nextDouble());
                    vec.rotateAroundY(rot);
                    this.cloudlets.add(new Cloudlet(vec.xCoord + this.field_70165_t, this.field_70170_p.func_189649_b((int)(vec.xCoord + this.field_70165_t) + 1, (int)(vec.zCoord + this.field_70161_v)), vec.zCoord + this.field_70161_v, rot, 0, shockLife, TorexType.SHOCK).setScale((float)s * 5.0f, (float)s * 2.0f).setMotion(MathHelper.func_151237_a((double)(0.25 * (double)this.field_70173_aa - 5.0), (double)0.0, (double)1.0)));
                }
            }
            if (this.field_70173_aa < 200) {
                lifetime *= (int)s;
                for (i = 0; i < 2; ++i) {
                    Cloudlet cloud = new Cloudlet(this.field_70165_t, this.field_70163_u + this.coreHeight, this.field_70161_v, (float)(this.field_70146_Z.nextDouble() * 2.0 * Math.PI), 0, lifetime, TorexType.RING);
                    cloud.setScale((float)(Math.sqrt(s) * cs + (double)this.field_70173_aa * 0.0015 * s), (float)(Math.sqrt(s) * cs + (double)this.field_70173_aa * 0.0015 * 6.0 * cs * s));
                    this.cloudlets.add(cloud);
                }
            }
            if (this.humidity > 0.0f && (double)this.field_70173_aa * 2.0 < 180.0) {
                this.spawnCondensationClouds((double)this.field_70173_aa * 2.0 - 8.0, this.humidity, 130, 80, 4, s, cs);
                this.spawnCondensationClouds((double)this.field_70173_aa * 2.0 - 8.0, this.humidity, 170, 80, 2, s, cs);
            }
            this.cloudlets.removeIf(x -> x.isDead);
            for (Cloudlet cloud : this.cloudlets) {
                cloud.update();
            }
            this.coreHeight += 0.15;
            this.torusWidth += 0.05;
            this.rollerSize = this.torusWidth * 0.35;
            this.convectionHeight = this.coreHeight + this.rollerSize;
            int maxHeat = (int)(50.0 * s * s);
            this.heat = (double)maxHeat - Math.pow((double)(maxHeat * this.field_70173_aa) / (double)this.maxAge, 0.6);
        }
    }

    public void spawnCondensationClouds(double range, float humidity, int height, int count, int spreadAngle, double s, double cs) {
        if (range > 0.0 && this.field_70163_u + range > (double)height) {
            for (int i = 0; i < (int)((double)(5.0f * humidity * (float)count) / (double)spreadAngle); ++i) {
                for (int j = 1; j < spreadAngle; ++j) {
                    float angle = (float)(Math.PI * 2 * this.field_70146_Z.nextDouble());
                    Vec3 vec = Vec3.createVectorHelper(0.0, range, 0.0);
                    vec.rotateAroundZ((float)Math.acos(((double)height - this.field_70163_u) / range) + (float)Math.toRadians((double)(humidity * humidity * 90.0f * (float)j) * (0.1 * this.field_70146_Z.nextDouble() - 0.05)));
                    vec.rotateAroundY(angle);
                    Cloudlet cloud = new Cloudlet(this.field_70165_t + vec.xCoord, this.field_70163_u + vec.yCoord, this.field_70161_v + vec.zCoord, angle, 0, (int)((20.0 + range / 10.0) * (1.0 + this.field_70146_Z.nextDouble() * 0.1)), TorexType.CONDENSATION);
                    cloud.setScale(3.0f * (float)(cs * s), 4.0f * (float)(cs * s));
                    this.cloudlets.add(cloud);
                }
            }
        }
    }

    public EntityNukeTorex setScale(float scale) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(SCALE, (Object)Float.valueOf(scale));
        }
        this.coreHeight *= (double)scale;
        this.convectionHeight *= (double)scale;
        this.torusWidth *= (double)scale;
        this.rollerSize *= (double)scale;
        this.maxAge = (int)(900.0f * scale);
        return this;
    }

    public EntityNukeTorex setType(int type) {
        this.field_70180_af.func_187227_b(TYPE, (Object)((byte)type));
        return this;
    }

    public double getScale() {
        return ((Float)this.field_70180_af.func_187225_a(SCALE)).floatValue();
    }

    public byte getType() {
        return (Byte)this.field_70180_af.func_187225_a(TYPE);
    }

    public double getSimulationSpeed() {
        int simSlow = this.maxAge / 4;
        int life = this.field_70173_aa;
        if (life > this.maxAge) {
            return 0.0;
        }
        if (life > simSlow) {
            return 1.0 - (double)(life - simSlow) / (double)(this.maxAge - simSlow);
        }
        return 1.0;
    }

    public float getAlpha() {
        int life = this.field_70173_aa;
        int fadeOut = this.maxAge * 3 / 4;
        if (life > fadeOut) {
            float fac = (float)(life - fadeOut) / (float)(this.maxAge - fadeOut);
            return 1.0f - fac;
        }
        return 1.0f;
    }

    public Vec3 getInterpColor(double interp, byte type) {
        if (type == 0) {
            return Vec3.createVectorHelper(0.1 + 2.4 * interp, 0.075 + 1.225 * interp, 0.05 + 0.35000000000000003 * interp);
        }
        return Vec3.createVectorHelper(0.1 + 0.9 * interp, 0.1 + 1.9 * interp, 0.1 + 0.4 * interp);
    }

    public static void statFac(World world, double x, double y, double z, float scale) {
        EntityNukeTorex torex = new EntityNukeTorex(world).setScale(MathHelper.func_76131_a((float)(scale * 0.01f), (float)0.25f, (float)5.0f));
        torex.func_70107_b(x, y, z);
        torex.startTime = world.func_82737_E();
        world.func_72838_d((Entity)torex);
    }

    public static void statFacBale(World world, double x, double y, double z, float scale) {
        EntityNukeTorex torex = new EntityNukeTorex(world).setScale(MathHelper.func_76131_a((float)(scale * 0.01f), (float)0.25f, (float)5.0f)).setType(1);
        torex.func_70107_b(x, y, z);
        world.func_72838_d((Entity)torex);
    }

    public class Cloudlet {
        public double posX;
        public double posY;
        public double posZ;
        public double prevPosX;
        public double prevPosY;
        public double prevPosZ;
        public double motionX;
        public double motionY;
        public double motionZ;
        public int age;
        public int cloudletLife;
        public float angle;
        public boolean isDead = false;
        float rangeMod = 1.0f;
        public float colorMod = 1.0f;
        public Vec3 color;
        public Vec3 prevColor;
        public TorexType type;
        private float startingScale = 3.0f;
        private float growingScale = 5.0f;
        private double motionMult = 1.0;
        private double motionConvectionMult = 0.5;
        private double motionLiftMult = 0.625;
        private double motionRingMult = 0.5;
        private double motionCondensationMult = 1.0;
        private double motionShockwaveMult = 1.0;

        public Cloudlet(double posX, double posY, double posZ, float angle, int age, int maxAge) {
            this(posX, posY, posZ, angle, age, maxAge, TorexType.STANDARD);
        }

        public Cloudlet(double posX, double posY, double posZ, float angle, int age, int maxAge, TorexType type) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.age = age;
            this.cloudletLife = maxAge;
            this.angle = angle;
            this.rangeMod = 0.3f + EntityNukeTorex.this.field_70146_Z.nextFloat() * 0.7f;
            this.colorMod = 0.8f + EntityNukeTorex.this.field_70146_Z.nextFloat() * 0.2f;
            this.type = type;
            this.updateColor();
        }

        private void update() {
            Vec3 motion;
            ++this.age;
            if (this.age > this.cloudletLife) {
                this.isDead = true;
            }
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            Vec3 simPos = Vec3.createVectorHelper(EntityNukeTorex.this.field_70165_t - this.posX, 0.0, EntityNukeTorex.this.field_70161_v - this.posZ);
            double simPosX = EntityNukeTorex.this.field_70165_t + simPos.length();
            double simPosZ = EntityNukeTorex.this.field_70161_v + 0.0;
            if (this.type == TorexType.STANDARD) {
                Vec3 convection = this.getConvectionMotion(simPosX, simPosZ);
                Vec3 lift = this.getLiftMotion(simPosX, simPosZ);
                double factor = MathHelper.func_151237_a((double)((this.posY - EntityNukeTorex.this.field_70163_u) / EntityNukeTorex.this.coreHeight), (double)0.0, (double)1.0);
                this.motionX = convection.xCoord * factor + lift.xCoord * (1.0 - factor);
                this.motionY = convection.yCoord * factor + lift.yCoord * (1.0 - factor);
                this.motionZ = convection.zCoord * factor + lift.zCoord * (1.0 - factor);
            } else if (this.type == TorexType.RING) {
                motion = this.getRingMotion(simPosX, simPosZ);
                this.motionX = motion.xCoord;
                this.motionY = motion.yCoord;
                this.motionZ = motion.zCoord;
            } else if (this.type == TorexType.CONDENSATION) {
                motion = this.getCondensationMotion();
                this.motionX = motion.xCoord;
                this.motionY = motion.yCoord;
                this.motionZ = motion.zCoord;
            } else if (this.type == TorexType.SHOCK) {
                motion = this.getShockwaveMotion();
                this.motionX = motion.xCoord;
                this.motionY = motion.yCoord;
                this.motionZ = motion.zCoord;
            }
            double mult = this.motionMult * EntityNukeTorex.this.getSimulationSpeed();
            this.posX += this.motionX * mult;
            this.posY += this.motionY * mult;
            this.posZ += this.motionZ * mult;
            this.updateColor();
        }

        private Vec3 getCondensationMotion() {
            Vec3 delta = Vec3.createVectorHelper(this.posX - EntityNukeTorex.this.field_70165_t, 0.0, this.posZ - EntityNukeTorex.this.field_70161_v).normalize();
            double speed = this.motionCondensationMult * EntityNukeTorex.this.getScale() * 0.125;
            delta.xCoord *= speed;
            delta.yCoord = 0.0;
            delta.zCoord *= speed;
            return delta;
        }

        private Vec3 getShockwaveMotion() {
            Vec3 delta = Vec3.createVectorHelper(this.posX - EntityNukeTorex.this.field_70165_t, 0.0, this.posZ - EntityNukeTorex.this.field_70161_v).normalize();
            double speed = this.motionShockwaveMult * EntityNukeTorex.this.getScale() * 0.25;
            delta.xCoord *= speed;
            delta.yCoord = 0.0;
            delta.zCoord *= speed;
            return delta;
        }

        private Vec3 getRingMotion(double simPosX, double simPosZ) {
            if (simPosX > EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth * 2.0) {
                return Vec3.createVectorHelper(0.0, 0.0, 0.0);
            }
            Vec3 torusPos = Vec3.createVectorHelper(EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth, EntityNukeTorex.this.field_70163_u + EntityNukeTorex.this.coreHeight * 0.5, EntityNukeTorex.this.field_70161_v);
            Vec3 delta = Vec3.createVectorHelper(torusPos.xCoord - simPosX, torusPos.yCoord - this.posY, torusPos.zCoord - simPosZ);
            double roller = EntityNukeTorex.this.rollerSize * (double)this.rangeMod * 0.25;
            double dist = delta.length() / roller - 1.0;
            double func = 1.0 - Math.pow(Math.E, -dist);
            float angle = (float)(func * Math.PI * 0.5);
            Vec3 rot = Vec3.createVectorHelper(-delta.xCoord / dist, -delta.yCoord / dist, -delta.zCoord / dist);
            rot.rotateAroundZ(angle);
            Vec3 motion = Vec3.createVectorHelper(torusPos.xCoord + rot.xCoord - simPosX, torusPos.yCoord + rot.yCoord - this.posY, torusPos.zCoord + rot.zCoord - simPosZ);
            motion = motion.normalize();
            motion.rotateAroundY(this.angle);
            double speed = this.motionRingMult * 0.5;
            motion.xCoord *= speed;
            motion.yCoord *= speed;
            motion.zCoord *= speed;
            return motion;
        }

        private Vec3 getConvectionMotion(double simPosX, double simPosZ) {
            if (simPosX > EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth * 2.0) {
                return Vec3.createVectorHelper(0.0, 0.0, 0.0);
            }
            Vec3 torusPos = Vec3.createVectorHelper(EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth, EntityNukeTorex.this.field_70163_u + EntityNukeTorex.this.coreHeight, EntityNukeTorex.this.field_70161_v);
            Vec3 delta = Vec3.createVectorHelper(torusPos.xCoord - simPosX, torusPos.yCoord - this.posY, torusPos.zCoord - simPosZ);
            double roller = EntityNukeTorex.this.rollerSize * (double)this.rangeMod;
            double dist = delta.length() / roller - 1.0;
            double func = 1.0 - Math.pow(Math.E, -dist);
            float angle = (float)(func * Math.PI * 0.5);
            Vec3 rot = Vec3.createVectorHelper(-delta.xCoord / dist, -delta.yCoord / dist, -delta.zCoord / dist);
            rot.rotateAroundZ(angle);
            Vec3 motion = Vec3.createVectorHelper(torusPos.xCoord + rot.xCoord - simPosX, torusPos.yCoord + rot.yCoord - this.posY, torusPos.zCoord + rot.zCoord - simPosZ);
            motion = motion.normalize();
            motion.rotateAroundY(this.angle);
            motion.xCoord *= this.motionConvectionMult;
            motion.yCoord *= this.motionConvectionMult;
            motion.zCoord *= this.motionConvectionMult;
            return motion;
        }

        private Vec3 getLiftMotion(double simPosX, double simPosZ) {
            double scale = MathHelper.func_151237_a((double)(1.0 - (simPosX - (EntityNukeTorex.this.field_70165_t + EntityNukeTorex.this.torusWidth))), (double)0.0, (double)1.0) * this.motionLiftMult;
            Vec3 motion = Vec3.createVectorHelper(EntityNukeTorex.this.field_70165_t - this.posX, EntityNukeTorex.this.field_70163_u + EntityNukeTorex.this.convectionHeight - this.posY, EntityNukeTorex.this.field_70161_v - this.posZ);
            motion = motion.normalize();
            motion.xCoord *= scale;
            motion.yCoord *= scale;
            motion.zCoord *= scale;
            return motion;
        }

        private void updateColor() {
            this.prevColor = this.color;
            double exX = EntityNukeTorex.this.field_70165_t;
            double exY = EntityNukeTorex.this.field_70163_u + EntityNukeTorex.this.coreHeight;
            double exZ = EntityNukeTorex.this.field_70161_v;
            double distX = exX - this.posX;
            double distY = exY - this.posY;
            double distZ = exZ - this.posZ;
            double distSq = distX * distX + distY * distY + distZ * distZ;
            double col = 2.0 / Math.max(distSq /= this.type == TorexType.SHOCK ? EntityNukeTorex.this.heat * 3.0 : EntityNukeTorex.this.heat, 1.0);
            byte type = EntityNukeTorex.this.getType();
            this.color = EntityNukeTorex.this.getInterpColor(col, type);
        }

        public Vec3 getInterpPos(float interp) {
            return Vec3.createVectorHelper(this.prevPosX + (this.posX - this.prevPosX) * (double)interp, this.prevPosY + (this.posY - this.prevPosY) * (double)interp, this.prevPosZ + (this.posZ - this.prevPosZ) * (double)interp);
        }

        public Vec3 getInterpColor(float interp) {
            if (this.type == TorexType.CONDENSATION) {
                return Vec3.createVectorHelper(1.0, 1.0, 1.0);
            }
            double greying = 0.0;
            if (this.type == TorexType.RING) {
                greying += 0.05;
            }
            return Vec3.createVectorHelper(this.prevColor.xCoord + (this.color.xCoord - this.prevColor.xCoord) * (double)interp + greying, this.prevColor.yCoord + (this.color.yCoord - this.prevColor.yCoord) * (double)interp + greying, this.prevColor.zCoord + (this.color.zCoord - this.prevColor.zCoord) * (double)interp + greying);
        }

        public float getAlpha() {
            float alpha = (1.0f - (float)this.age / (float)this.cloudletLife) * EntityNukeTorex.this.getAlpha();
            if (this.type == TorexType.CONDENSATION) {
                alpha = (float)((double)alpha * 0.25);
            }
            return MathHelper.func_76131_a((float)alpha, (float)1.0E-4f, (float)1.0f);
        }

        public float getScale() {
            return this.startingScale + (float)this.age / (float)this.cloudletLife * this.growingScale;
        }

        public Cloudlet setScale(float start, float grow) {
            this.startingScale = start;
            this.growingScale = grow;
            return this;
        }

        public Cloudlet setMotion(double mult) {
            this.motionMult = mult;
            return this;
        }
    }

    public static enum TorexType {
        STANDARD,
        RING,
        CONDENSATION,
        SHOCK;

    }
}

