/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.crafting.handlers;

import com.hbm.items.ModItems;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.HbmWorldUtility;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MKUCraftingHandler
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public static ItemStack[] MKURecipe;
    private static long lastSeed;

    public boolean func_77569_a(InventoryCrafting inventory, World world) {
        if (world == null || world.field_73011_w == null || world.func_72912_H() == null || HbmWorldUtility.getProviderWorld(world.field_73011_w) == null) {
            return false;
        }
        if (MKURecipe == null || world.func_72905_C() != lastSeed) {
            MKUCraftingHandler.generateRecipe(world);
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = inventory.func_70463_b(i % 3, i / 3);
            ItemStack recipe = MKURecipe[i];
            if (stack.func_190926_b() && recipe == null || !stack.func_190926_b() && recipe != null && stack.func_77973_b() == recipe.func_77973_b() && stack.func_77952_i() == recipe.func_77952_i()) continue;
            return false;
        }
        return true;
    }

    public static void generateRecipe(World world) {
        if (world == null || world.field_73011_w == null || world.func_72912_H() == null || HbmWorldUtility.getProviderWorld(world.field_73011_w) == null || lastSeed == world.func_72905_C() && MKURecipe != null) {
            return;
        }
        lastSeed = world.func_72905_C();
        List<ItemStack> list = Arrays.asList(new ItemStack(ModItems.powder_iodine), new ItemStack(ModItems.powder_fire), new ItemStack(ModItems.dust), new ItemStack(ModItems.nugget_mercury), new ItemStack(ModItems.morning_glory), new ItemStack(ModItems.syringe_metal_empty), null, null, null);
        Collections.shuffle(list, new Random(world.func_72905_C()));
        MKURecipe = list.toArray(new ItemStack[9]);
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inventory) {
        return this.func_77571_b();
    }

    public ItemStack func_77571_b() {
        return new ItemStack(ModItems.syringe_mkunicorn);
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public static void initMKU(World world) {
        if (MKURecipe == null) {
            MKUCraftingHandler.generateRecipe(world);
        }
    }

    public static String printOrder(World world) {
        MKUCraftingHandler.initMKU(world);
        StringBuilder answer = new StringBuilder();
        answer.append("\u00a7dMKU Recipe for Seed \u00a7f").append(world.func_72905_C()).append("\u00a7d:\n");
        for (int i = 0; i < 9; ++i) {
            answer.append("\u00a75(\u00a7d").append(i / 3 + 1).append("\u00a75/\u00a7d").append(i % 3 + 1).append("\u00a75): \u00a7f").append(MKURecipe[i] == null ? "-" : MKURecipe[i].func_82833_r()).append("\n");
        }
        return answer.toString();
    }
}

