/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network.energy;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.network.energy.TileEntityCableBaseNT;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCableGauge
extends BlockContainer
implements ILookOverlay,
ITooltipProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockCableGauge(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149647_a(MainRegistry.blockTab);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCableGauge();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        this.addStandardInfo(tooltip);
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntityCableGauge)) {
            return;
        }
        TileEntityCableGauge diode = (TileEntityCableGauge)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(Library.getShortNumber(diode.deltaLastSecond) + "HE/s");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
    public static class TileEntityCableGauge
    extends TileEntityCableBaseNT
    implements INBTPacketReceiver,
    SimpleComponent {
        private long lastMeasurement = 10L;
        private long deltaSecond = 0L;
        public long deltaLastSecond = 0L;

        @Override
        public void func_73660_a() {
            super.func_73660_a();
            if (!this.field_145850_b.field_72995_K && this.network != null) {
                long total = this.network.getTotalTransfer();
                long deltaTick = total - this.lastMeasurement;
                this.lastMeasurement = total;
                try {
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        this.deltaLastSecond = this.deltaSecond;
                        this.deltaSecond = 0L;
                        NBTTagCompound data = new NBTTagCompound();
                        data.func_74772_a("deltaS", this.deltaLastSecond);
                        INBTPacketReceiver.networkPack(this, data, 25);
                    }
                    this.deltaSecond += deltaTick;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void networkUnpack(NBTTagCompound nbt) {
            this.deltaLastSecond = Math.max(nbt.func_74763_f("deltaS"), 0L);
        }

        public String getComponentName() {
            return "power_gauge";
        }

        @Callback(doc="getPowerPerS(); returns the power(long) per s traveling through the gauge.")
        public Object[] getPowerPerS(Context context, Arguments args) {
            return new Object[]{this.deltaLastSecond};
        }
    }
}

