/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.block.IToolable;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemScraps;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityMachineStrandCaster;
import com.hbm.util.I18nUtil;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.jetbrains.annotations.NotNull;

public class MachineStrandCaster
extends BlockDummyable
implements ICrucibleAcceptor,
ILookOverlay,
IToolable {
    public MachineStrandCaster(Material material, String name) {
        super(material, name);
    }

    @Override
    public int[] getDimensions() {
        return new int[]{0, 0, 6, 0, 1, 0};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    public TileEntity func_149915_a(@NotNull World world, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineStrandCaster();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(true, false, true, false, true);
        }
        return null;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        MultiblockHandlerXR.fillSpace(world, x += dir.offsetX * o, y, z += dir.offsetZ * o, new int[]{2, 0, 1, 0, 1, 0}, (Block)this, dir);
        this.makeExtra(world, x + rot.offsetX - dir.offsetX, y, z + rot.offsetZ - dir.offsetZ);
        this.makeExtra(world, x - dir.offsetX, y, z - dir.offsetZ);
        this.makeExtra(world, x - dir.offsetX * 5, y, z - dir.offsetZ * 5);
        this.makeExtra(world, x + rot.offsetX - dir.offsetX * 5, y, z + rot.offsetZ - dir.offsetZ * 5);
        this.makeExtra(world, x + rot.offsetX - dir.offsetX, y + 2, z + rot.offsetZ - dir.offsetZ);
        this.makeExtra(world, x - dir.offsetX, y + 2, z - dir.offsetZ);
        this.makeExtra(world, x + rot.offsetX, y + 2, z + rot.offsetZ);
        this.makeExtra(world, x, y + 2, z);
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos pos, ForgeDirection side, Mats.MaterialStack stack) {
        return false;
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos pos, ForgeDirection side, Mats.MaterialStack stack) {
        return null;
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos pos, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        block6: {
            block5: {
                TileEntity poured = world.func_175625_s(pos);
                if (!(poured instanceof TileEntityProxyCombo)) break block5;
                TileEntityProxyCombo combo = (TileEntityProxyCombo)poured;
                if (combo.molten) break block6;
            }
            return false;
        }
        BlockPos corePos = this.findCore((IBlockAccess)world, pos);
        if (corePos == null) {
            return false;
        }
        TileEntity tile = world.func_175625_s(corePos);
        if (!(tile instanceof TileEntityMachineStrandCaster)) {
            return false;
        }
        TileEntityMachineStrandCaster caster = (TileEntityMachineStrandCaster)tile;
        return caster.canAcceptPartialPour(world, new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), dX, dY, dZ, side, stack);
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos pos, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        block6: {
            block5: {
                TileEntity poured = world.func_175625_s(pos);
                if (!(poured instanceof TileEntityProxyCombo)) break block5;
                TileEntityProxyCombo combo = (TileEntityProxyCombo)poured;
                if (combo.molten) break block6;
            }
            return stack;
        }
        int[] posC = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (posC == null) {
            return stack;
        }
        TileEntity tile = world.func_175625_s(new BlockPos(posC[0], posC[1], posC[2]));
        if (!(tile instanceof TileEntityMachineStrandCaster)) {
            return stack;
        }
        TileEntityMachineStrandCaster caster = (TileEntityMachineStrandCaster)tile;
        return caster.pour(world, pos, dX, dY, dZ, side, stack);
    }

    public boolean func_180639_a(World world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        int[] coords = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        TileEntityMachineStrandCaster caster = (TileEntityMachineStrandCaster)world.func_175625_s(new BlockPos(coords[0], coords[1], coords[2]));
        if (caster != null) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() == ModItems.mold && caster.inventory.getStackInSlot(0).func_190926_b()) {
                caster.inventory.setStackInSlot(0, heldItem.func_77946_l());
                caster.inventory.getStackInSlot(0).func_190920_e(1);
                player.func_184586_b(hand).func_190918_g(1);
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, HBMSoundHandler.upgradePlug, SoundCategory.BLOCKS, 1.0f, 1.0f);
                caster.func_70296_d();
                return true;
            }
            if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemTool && heldItem.func_77973_b().getToolClasses(heldItem).contains("shovel")) {
                if (caster.amount > 0) {
                    ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(caster.type, caster.amount));
                    if (!player.field_71071_by.func_70441_a(scrap)) {
                        EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, scrap);
                        world.func_72838_d((Entity)item);
                    } else {
                        player.field_71069_bz.func_75142_b();
                    }
                    caster.amount = 0;
                    caster.type = null;
                    caster.func_70296_d();
                }
                return true;
            }
        }
        return this.standardOpenBehavior(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player, 0);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMachineStrandCaster) {
            TileEntityMachineStrandCaster caster = (TileEntityMachineStrandCaster)te;
            if (caster.amount > 0) {
                ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(caster.type, caster.amount));
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, scrap);
                world.func_72838_d((Entity)item);
                caster.amount = 0;
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        BlockPos corePos = this.findCore((IBlockAccess)world, new BlockPos(x, y, z));
        if (corePos == null) {
            return;
        }
        TileEntityMachineStrandCaster caster = (TileEntityMachineStrandCaster)world.func_175625_s(corePos);
        ArrayList<String> text = new ArrayList<String>();
        if (caster != null) {
            if (caster.inventory.getStackInSlot(0).func_190926_b()) {
                text.add(ChatFormatting.RED + I18nUtil.resolveKey("foundry.noCast", new Object[0]));
            } else if (caster.inventory.getStackInSlot(0).func_77973_b() == ModItems.mold) {
                text.add(ChatFormatting.BLUE + caster.getInstalledMold().getTitle());
            }
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFF4000, 0x401000, text);
    }

    @Override
    public boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        if (!MultiblockHandlerXR.checkSpace(world, x += dir.offsetX * o, y, z += dir.offsetZ * o, this.getDimensions(), x, y, z, dir)) {
            return false;
        }
        return MultiblockHandlerXR.checkSpace(world, x, y, z, new int[]{2, 0, 1, 0, 1, 0}, x, y, z, dir);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        BlockPos corePos = this.findCore((IBlockAccess)world, new BlockPos(x, y, z));
        TileEntityMachineStrandCaster caster = (TileEntityMachineStrandCaster)world.func_175625_s(corePos);
        if (Objects.requireNonNull(caster).inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        if (!player.field_71071_by.func_70441_a(caster.inventory.getStackInSlot(0).func_77946_l())) {
            EntityItem item = new EntityItem(world, (double)x + 0.5, (double)(y + 1), (double)z + 0.5, caster.inventory.getStackInSlot(0).func_77946_l());
            world.func_72838_d((Entity)item);
        } else {
            player.field_71069_bz.func_75142_b();
        }
        caster.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        caster.func_70296_d();
        return true;
    }
}

