/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyableMBB;
import com.hbm.blocks.ILookOverlay;
import com.hbm.lib.InventoryHelper;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityMachineFENSU;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.oredict.OreDictionary;

public class MachineFENSU
extends BlockDummyableMBB
implements ILookOverlay {
    public MachineFENSU(Material materialIn, String s) {
        super(materialIn, s);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineFENSU();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{4, 0, 1, 1, 2, 2};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            ItemStack drop = new ItemStack((Block)this);
            int[] posCore = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            TileEntity te = posCore == null ? world.func_175625_s(pos) : world.func_175625_s(new BlockPos(posCore[0], posCore[1], posCore[2]));
            if (te instanceof TileEntityMachineFENSU) {
                TileEntityMachineFENSU battery = (TileEntityMachineFENSU)te;
                NBTTagCompound nbt = new NBTTagCompound();
                battery.writeNBT(nbt);
                if (!nbt.func_82582_d()) {
                    drop.func_77982_d(nbt);
                }
            }
            InventoryHelper.spawnItemStack(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
        }
        return world.func_175698_g(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos1, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int[] pos = this.findCore((IBlockAccess)world, pos1.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p());
            if (pos == null) {
                return false;
            }
            BlockPos corePos = new BlockPos(pos[0], pos[1], pos[2]);
            TileEntityMachineFENSU entity = (TileEntityMachineFENSU)world.func_175625_s(corePos);
            if (entity != null) {
                if (!player.func_184586_b(hand).func_190926_b()) {
                    int[] ores;
                    for (int ore : ores = OreDictionary.getOreIDs((ItemStack)player.func_184586_b(hand))) {
                        String name = OreDictionary.getOreName((int)ore);
                        if (name.equals("dyeLightBlue")) {
                            name = "dyeLight_Blue";
                        }
                        if (name.equals("dyeLightGray")) {
                            name = "dyeSilver";
                        }
                        if (name.length() <= 3 || !name.startsWith("dye")) continue;
                        try {
                            entity.color = EnumDyeColor.valueOf((String)name.substring(3, name.length()).toUpperCase());
                            entity.func_70296_d();
                            world.func_184138_a(corePos, state, state, 6);
                            if (!player.func_184812_l_()) {
                                player.func_184586_b(hand).func_190918_g(1);
                            }
                            return true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)21, (World)world, (int)pos[0], (int)pos[1], (int)pos[2]);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        int[] posCore = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        TileEntity te = posCore == null ? world.func_175625_s(pos) : world.func_175625_s(new BlockPos(posCore[0], posCore[1], posCore[2]));
        if (stack.func_77942_o() && te instanceof TileEntityMachineFENSU) {
            TileEntityMachineFENSU battery = (TileEntityMachineFENSU)te;
            if (stack.func_82837_s()) {
                battery.setCustomName(stack.func_82833_r());
            }
            try {
                NBTTagCompound stackNBT = stack.func_77978_p();
                if (stackNBT.func_74764_b("NBT_PERSISTENT_KEY")) {
                    battery.readNBT(stackNBT);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityMachineFENSU) {
            InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)((TileEntityMachineFENSU)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityMachineFENSU)) {
            return 0;
        }
        TileEntityMachineFENSU battery = (TileEntityMachineFENSU)te;
        return (int)battery.getPowerRemainingScaled(15L);
    }

    public void func_190948_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        NBTTagCompound nbt;
        super.func_190948_a(stack, worldIn, list, flagIn);
        list.add("Change color using dyes");
        long charge = 0L;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("NBT_PERSISTENT_KEY")) {
            charge = nbt.func_74775_l("NBT_PERSISTENT_KEY").func_74763_f("power");
        }
        if (charge == 0L) {
            list.add("\u00a7c0\u00a74/9.22EHE \u00a7c(0.0%)\u00a7r");
        } else {
            double percent = (double)Math.round(1000.0 * ((double)charge / 9.223372036854776E18)) * 0.1;
            String color = "\u00a7e";
            String color2 = "\u00a76";
            if (percent < 25.0) {
                color = "\u00a7c";
                color2 = "\u00a74";
            } else if (percent >= 75.0) {
                color = "\u00a7a";
                color2 = "\u00a72";
            }
            list.add(color + Library.getShortNumber(charge) + color2 + "/9.22EHE " + color + "(" + percent + "%)\u00a7r");
        }
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (!(te instanceof TileEntityMachineFENSU)) {
            return;
        }
        TileEntityMachineFENSU battery = (TileEntityMachineFENSU)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add("\u00a76<> \u00a7rStored Energy: " + Library.getShortNumber(battery.power) + "/9.22EHE");
        if (battery.powerDelta == 0L) {
            text.add("\u00a7e-- \u00a7r0HE/s");
        } else if (battery.powerDelta > 0L) {
            text.add("\u00a7a-> \u00a7r" + Library.getShortNumber(battery.powerDelta) + "HE/s");
        } else {
            text.add("\u00a7c<- \u00a7r" + Library.getShortNumber(-battery.powerDelta) + "HE/s");
        }
        text.add("&[" + Library.getColorProgress((double)battery.power / 9.223372036854776E18) + "&]    " + Library.getPercentage((double)battery.power / 9.223372036854776E18) + "%");
        ILookOverlay.printGeneric(event, this.func_149732_F(), 0xFFFF00, 0x404000, text);
    }
}

