/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.lib.InventoryHelper;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityDiFurnace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineDiFurnace
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool EXT = PropertyBool.func_177716_a((String)"ext");
    private final boolean isActive;
    private static boolean keepInventory;

    public MachineDiFurnace(Material materialIn, String s, boolean state) {
        super(materialIn);
        this.isActive = state;
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149647_a(MainRegistry.machineTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)EXT, (Comparable)Boolean.valueOf(false)));
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.machine_difurnace_off);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDiFurnace();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityDiFurnace entity = (TileEntityDiFurnace)world.func_175625_s(pos);
            if (entity != null) {
                player.openGui((Object)MainRegistry.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!keepInventory && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityDiFurnace) {
            InventoryHelper.dropInventoryItems(worldIn, pos, (TileEntityDiFurnace)tileentity);
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, EXT});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)EXT) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(meta & 7));
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        boolean ext = (meta & 8) != 0;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)EXT, (Comparable)Boolean.valueOf(ext));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public static void updateBlockState(boolean isProcessing, boolean ext, World world, BlockPos pos) {
        IBlockState i = world.func_180495_p(pos);
        TileEntity entity = world.func_175625_s(pos);
        keepInventory = true;
        IBlockState newState = i;
        if (isProcessing && i.func_177230_c() != ModBlocks.machine_difurnace_on) {
            newState = ModBlocks.machine_difurnace_on.func_176223_P();
        } else if (!isProcessing && i.func_177230_c() != ModBlocks.machine_difurnace_off) {
            newState = ModBlocks.machine_difurnace_off.func_176223_P();
        }
        newState = newState.func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)i.func_177229_b((IProperty)FACING))).func_177226_a((IProperty)EXT, (Comparable)Boolean.valueOf(ext));
        if (newState != i) {
            world.func_180501_a(pos, newState, 2);
        }
        keepInventory = false;
        if (entity != null) {
            entity.func_145829_t();
            world.func_175690_a(pos, entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isActive) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double x0 = (double)pos.func_177958_n() + 0.5;
            double y0 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0 + 0.2;
            double z0 = (double)pos.func_177952_p() + 0.5;
            double sideOff = 0.52f;
            double sideRand = (double)rand.nextFloat() * 0.5 - 0.25;
            double xOff = (double)rand.nextFloat() * 0.375 - 0.1875;
            double zOff = (double)rand.nextFloat() * 0.375 - 0.1875;
            double smokeY = pos.func_177956_o() + 1;
            if (worldIn.func_180495_p(pos.func_177967_a(EnumFacing.UP, 1)).func_177230_c() == ModBlocks.machine_difurnace_ext) {
                smokeY += 1.0;
            }
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, x0 - sideOff, y0, z0 + sideRand, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + xOff, smokeY, z0 + zOff, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, x0 + sideOff, y0, z0 + sideRand, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + xOff, smokeY, z0 + zOff, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, x0 + sideRand, y0, z0 - sideOff, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + xOff, smokeY, z0 + zOff, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, x0 + sideRand, y0, z0 + sideOff, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x0 + xOff, smokeY, z0 + zOff, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)ModBlocks.machine_difurnace_off));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

