/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityChungus;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.FluidStack;

public class MachineChungus
extends BlockDummyable
implements ILookOverlay {
    public MachineChungus(Material mat, String s) {
        super(mat, s);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityChungus();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, true, true);
        }
        return null;
    }

    public boolean func_180639_a(World world, BlockPos pos1, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            int z;
            int y;
            int x = pos1.func_177958_n();
            int[] pos = this.findCore((IBlockAccess)world, x, y = pos1.func_177956_o(), z = pos1.func_177952_p());
            if (pos == null) {
                return true;
            }
            TileEntityChungus entity = (TileEntityChungus)world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
            if (entity != null) {
                ForgeDirection dir = ForgeDirection.getOrientation(entity.func_145832_p() - 10);
                ForgeDirection turn = dir.getRotation(ForgeDirection.DOWN);
                int iX = entity.func_174877_v().func_177958_n() + dir.offsetX + turn.offsetX * 2;
                int iX2 = entity.func_174877_v().func_177958_n() + dir.offsetX * 2 + turn.offsetX * 2;
                int iZ = entity.func_174877_v().func_177952_p() + dir.offsetZ + turn.offsetZ * 2;
                int iZ2 = entity.func_174877_v().func_177952_p() + dir.offsetZ * 2 + turn.offsetZ * 2;
                if (!(x != iX && x != iX2 || z != iZ && z != iZ2 || y >= entity.func_174877_v().func_177956_o() + 2)) {
                    world.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, HBMSoundHandler.chungus_lever, SoundCategory.BLOCKS, 1.5f, 1.0f);
                    if (!world.field_72995_K) {
                        int newFill = 0;
                        if (entity.types[0] == ModForgeFluids.STEAM) {
                            entity.types[0] = ModForgeFluids.HOTSTEAM;
                            entity.types[1] = ModForgeFluids.STEAM;
                            newFill = entity.tanks[0].getFluidAmount() / 10;
                        } else if (entity.types[0] == ModForgeFluids.HOTSTEAM) {
                            entity.types[0] = ModForgeFluids.SUPERHOTSTEAM;
                            entity.types[1] = ModForgeFluids.HOTSTEAM;
                            newFill = entity.tanks[0].getFluidAmount() / 10;
                        } else if (entity.types[0] == ModForgeFluids.SUPERHOTSTEAM) {
                            entity.types[0] = ModForgeFluids.ULTRAHOTSTEAM;
                            entity.types[1] = ModForgeFluids.SUPERHOTSTEAM;
                            newFill = entity.tanks[0].getFluidAmount() / 10;
                        } else if (entity.types[0] == ModForgeFluids.ULTRAHOTSTEAM) {
                            entity.types[0] = ModForgeFluids.STEAM;
                            entity.types[1] = ModForgeFluids.SPENTSTEAM;
                            newFill = Math.min(entity.tanks[0].getFluidAmount() * 1000, entity.tanks[0].getCapacity());
                        }
                        entity.tanks[0].setFluid(new FluidStack(entity.types[0], newFill));
                        entity.tanks[1].setFluid(null);
                        entity.func_70296_d();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{3, 0, 0, 3, 2, 2};
    }

    @Override
    public int getOffset() {
        return 3;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{4, -4, 0, 3, 1, 1}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{3, 0, 6, -1, 1, 1}, (Block)this, dir);
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{2, 0, 10, -7, 1, 1}, (Block)this, dir);
        world.func_180501_a(new BlockPos(x + dir.offsetX, y + 2, z + dir.offsetZ), this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(dir.ordinal())), 3);
        this.makeExtra(world, x + dir.offsetX, y + 2, z + dir.offsetZ);
        this.makeExtra(world, x + dir.offsetX * (o - 10), y, z + dir.offsetZ * (o - 10));
        ForgeDirection side = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, x + dir.offsetX * o + side.offsetX * 2, y, z + dir.offsetZ * o + side.offsetZ * 2);
        this.makeExtra(world, x + dir.offsetX * o - side.offsetX * 2, y, z + dir.offsetZ * o - side.offsetZ * 2);
    }

    @Override
    protected boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        if (!MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, this.getDimensions(), x, y, z, dir)) {
            return false;
        }
        if (!MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{3, 0, 6, -1, 1, 1}, x, y, z, dir)) {
            return false;
        }
        if (!MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, new int[]{2, 0, 10, -7, 1, 1}, x, y, z, dir)) {
            return false;
        }
        return world.func_180495_p(new BlockPos(x + dir.offsetX, y + 2, z + dir.offsetZ)).func_177230_c().func_176196_c(world, new BlockPos(x + dir.offsetX, y + 2, z + dir.offsetZ));
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (!(te instanceof TileEntityChungus)) {
            return;
        }
        TileEntityChungus chungus = (TileEntityChungus)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(Library.getShortNumber(chungus.power) + "/" + Library.getShortNumber(100000000000L) + " HE");
        text.add("\u00a7a-> \u00a7r" + Library.getShortNumber(20L * chungus.powerProduction) + "HE/s");
        if (chungus.types[0] != null) {
            text.add("\u00a7a-> \u00a7r" + chungus.types[0].getLocalizedName(new FluidStack(chungus.types[0], 1)) + ": " + chungus.tanks[0].getFluidAmount() + "/" + chungus.tanks[0].getCapacity() + "mB");
        }
        if (chungus.types[1] != null) {
            text.add("\u00a7c<- \u00a7r" + chungus.types[1].getLocalizedName(new FluidStack(chungus.types[1], 1)) + ": " + chungus.tanks[1].getFluidAmount() + "/" + chungus.tanks[1].getCapacity() + "mB");
        }
        ILookOverlay.printGeneric(event, this.func_149732_F(), 0xFFFF00, 0x404000, text);
    }
}

