/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.lib.InventoryHelper;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityMachineBoiler;
import com.hbm.tileentity.machine.TileEntityMachineBoilerElectric;
import com.hbm.tileentity.machine.TileEntityMachineBoilerRTG;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MachineBoiler
extends BlockContainer {
    private static boolean keepInventory;
    public static final PropertyDirection FACING;
    private final boolean isActive;

    public MachineBoiler(Material materialIn, boolean active, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149647_a(MainRegistry.machineTab);
        this.isActive = active;
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this == ModBlocks.machine_boiler_off || this == ModBlocks.machine_boiler_on) {
            return new TileEntityMachineBoiler();
        }
        if (this == ModBlocks.machine_boiler_electric_off || this == ModBlocks.machine_boiler_electric_on) {
            return new TileEntityMachineBoilerElectric();
        }
        if (this == ModBlocks.machine_boiler_rtg_off || this == ModBlocks.machine_boiler_rtg_on) {
            return new TileEntityMachineBoilerRTG();
        }
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this == ModBlocks.machine_boiler_off || this == ModBlocks.machine_boiler_on) {
            return Item.func_150898_a((Block)ModBlocks.machine_boiler_off);
        }
        if (this == ModBlocks.machine_boiler_electric_off || this == ModBlocks.machine_boiler_electric_on) {
            return Item.func_150898_a((Block)ModBlocks.machine_boiler_electric_off);
        }
        if (this == ModBlocks.machine_boiler_rtg_off || this == ModBlocks.machine_boiler_rtg_on) {
            return Item.func_150898_a((Block)ModBlocks.machine_boiler_rtg_off);
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
        super.func_176213_c(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityMachineBoiler) {
                ((TileEntityMachineBoiler)tileentity).setCustomName(stack.func_82833_r());
            }
            if (tileentity instanceof TileEntityMachineBoilerElectric) {
                ((TileEntityMachineBoilerElectric)tileentity).setCustomName(stack.func_82833_r());
            }
            if (tileentity instanceof TileEntityMachineBoilerRTG) {
                ((TileEntityMachineBoilerRTG)tileentity).setCustomName(stack.func_82833_r());
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityMachineBase entity;
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityMachineBoiler && (entity = (TileEntityMachineBoiler)te) != null) {
                player.openGui((Object)MainRegistry.instance, 72, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            if (te instanceof TileEntityMachineBoilerElectric && (entity = (TileEntityMachineBoilerElectric)te) != null) {
                player.openGui((Object)MainRegistry.instance, 73, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            if (te instanceof TileEntityMachineBoilerRTG && (entity = (TileEntityMachineBoilerRTG)te) != null) {
                player.openGui((Object)MainRegistry.instance, 127, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public static void updateBlockState(boolean isProcessing, World world, BlockPos pos) {
        IBlockState i = world.func_180495_p(pos);
        TileEntity entity = world.func_175625_s(pos);
        keepInventory = true;
        if (i.func_177230_c() == ModBlocks.machine_boiler_off || i.func_177230_c() == ModBlocks.machine_boiler_on) {
            if (isProcessing && i.func_177230_c() != ModBlocks.machine_boiler_on) {
                world.func_175656_a(pos, ModBlocks.machine_boiler_on.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)i.func_177229_b((IProperty)FACING))));
            } else if (!isProcessing && i.func_177230_c() != ModBlocks.machine_boiler_off) {
                world.func_175656_a(pos, ModBlocks.machine_boiler_off.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)i.func_177229_b((IProperty)FACING))));
            }
        }
        if (i.func_177230_c() == ModBlocks.machine_boiler_electric_off || i.func_177230_c() == ModBlocks.machine_boiler_electric_on) {
            if (isProcessing && i.func_177230_c() != ModBlocks.machine_boiler_electric_on) {
                world.func_175656_a(pos, ModBlocks.machine_boiler_electric_on.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)i.func_177229_b((IProperty)FACING))));
            } else if (i.func_177230_c() != ModBlocks.machine_boiler_electric_off) {
                world.func_175656_a(pos, ModBlocks.machine_boiler_electric_off.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)i.func_177229_b((IProperty)FACING))));
            }
        }
        if (i.func_177230_c() == ModBlocks.machine_boiler_rtg_off || i.func_177230_c() == ModBlocks.machine_boiler_rtg_on) {
            if (isProcessing && i.func_177230_c() != ModBlocks.machine_boiler_rtg_on) {
                world.func_175656_a(pos, ModBlocks.machine_boiler_rtg_on.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)i.func_177229_b((IProperty)FACING))));
            } else if (i.func_177230_c() != ModBlocks.machine_boiler_rtg_off) {
                world.func_175656_a(pos, ModBlocks.machine_boiler_rtg_off.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)i.func_177229_b((IProperty)FACING))));
            }
        }
        keepInventory = false;
        if (entity != null) {
            entity.func_145829_t();
            world.func_175690_a(pos, entity);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!keepInventory) {
            if (tileentity instanceof TileEntityMachineBoiler) {
                InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)((TileEntityMachineBoiler)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            if (tileentity instanceof TileEntityMachineBoilerElectric) {
                InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)((TileEntityMachineBoilerElectric)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            if (tileentity instanceof TileEntityMachineBoilerRTG) {
                InventoryHelper.dropInventoryItems(worldIn, pos, (ICapabilityProvider)((TileEntityMachineBoilerRTG)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isActive) {
            if (this == ModBlocks.machine_boiler_on) {
                EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
                double d0 = (double)pos.func_177958_n() + 0.5;
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
                double d2 = (double)pos.func_177952_p() + 0.5;
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                if (rand.nextDouble() < 0.1) {
                    worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                switch (enumfacing) {
                    case WEST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case EAST: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case NORTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case SOUTH: {
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                        worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                }
            } else if (this == ModBlocks.machine_boiler_electric_on) {
                EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
                double d0 = (double)pos.func_177958_n() + 0.5;
                double d1 = (double)pos.func_177956_o() + 0.25 + rand.nextDouble() * 6.0 / 16.0;
                double d2 = (double)pos.func_177952_p() + 0.5;
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                switch (enumfacing) {
                    case WEST: {
                        worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case EAST: {
                        worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case NORTH: {
                        worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case SOUTH: {
                        worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                }
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (this == ModBlocks.machine_boiler_on || this == ModBlocks.machine_boiler_off) {
            return new ItemStack(ModBlocks.machine_boiler_off);
        }
        if (this == ModBlocks.machine_boiler_electric_on || this == ModBlocks.machine_boiler_electric_off) {
            return new ItemStack(ModBlocks.machine_boiler_electric_off);
        }
        if (this == ModBlocks.machine_boiler_rtg_on || this == ModBlocks.machine_boiler_rtg_off) {
            return new ItemStack(ModBlocks.machine_boiler_rtg_off);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    static {
        FACING = BlockHorizontal.field_185512_D;
    }
}

