/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IToolable;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityProxyEnergy;
import com.hbm.tileentity.machine.TileEntityHeaterElectric;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HeaterElectric
extends BlockDummyable
implements ILookOverlay,
ITooltipProvider,
IToolable {
    public HeaterElectric(Material mat, String s) {
        super(mat, s);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityHeaterElectric();
        }
        if (this.hasExtra(meta)) {
            return new TileEntityProxyEnergy();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{0, 0, 1, 2, 1, 1};
    }

    @Override
    public int getOffset() {
        return 2;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        this.makeExtra(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        this.addStandardInfo(tooltip);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (!(te instanceof TileEntityHeaterElectric)) {
            return;
        }
        TileEntityHeaterElectric heater = (TileEntityHeaterElectric)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(String.format("%,d", heater.heatEnergy) + " TU");
        text.add("\u00a7a-> \u00a7r" + heater.getConsumption() + " HE/t");
        text.add("\u00a7c<- \u00a7r" + heater.getHeatGen() + " TU/t");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER && tool != IToolable.ToolType.HAND_DRILL) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        if (pos == null) {
            return false;
        }
        TileEntity te = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (!(te instanceof TileEntityHeaterElectric)) {
            return false;
        }
        TileEntityHeaterElectric tile = (TileEntityHeaterElectric)te;
        if (tool == IToolable.ToolType.SCREWDRIVER) {
            tile.toggleSettingUp();
        } else {
            tile.toggleSettingDown();
        }
        tile.func_70296_d();
        return true;
    }
}

