/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.block.IToolable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMold;
import com.hbm.items.machine.ItemScraps;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.InventoryHelper;
import com.hbm.tileentity.machine.TileEntityFoundryCastingBase;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class FoundryCastingBase
extends BlockContainer
implements ICrucibleAcceptor,
IToolable,
ILookOverlay {
    protected FoundryCastingBase(String s) {
        super(Material.field_151576_e);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149672_a(SoundType.field_185852_e);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public double getPH() {
        return 1.0;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(p)).canAcceptPartialPour(world, p, dX, dY, dZ, side, stack);
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(p)).pour(world, p, dX, dY, dZ, side, stack);
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(p)).canAcceptPartialFlow(world, p, side, stack);
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(p)).flow(world, p, side, stack);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityFoundryCastingBase cast = (TileEntityFoundryCastingBase)world.func_175625_s(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!cast.inventory.getStackInSlot(1).func_190926_b()) {
            if (!player.field_71071_by.func_70441_a(cast.inventory.getStackInSlot(1).func_77946_l())) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, cast.inventory.getStackInSlot(1).func_77946_l()));
            } else {
                player.field_71069_bz.func_75142_b();
            }
            cast.inventory.setStackInSlot(1, ItemStack.field_190927_a);
            cast.func_70296_d();
            world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 2);
            return true;
        }
        if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == ModItems.mold) {
            ItemMold.Mold mold = ((ItemMold)player.func_184586_b(hand).func_77973_b()).getMold(player.func_184586_b(hand));
            if (mold.size == cast.getMoldSize()) {
                ItemStack prevMold;
                if (!cast.inventory.getStackInSlot(0).func_190926_b() && !player.field_71071_by.func_70441_a(prevMold = cast.inventory.getStackInSlot(0))) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, prevMold));
                }
                ItemStack m = player.func_184586_b(hand).func_77946_l();
                m.func_190920_e(1);
                cast.inventory.setStackInSlot(0, m);
                player.func_184586_b(hand).func_190918_g(1);
                player.field_71069_bz.func_75142_b();
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, HBMSoundHandler.upgradePlug, SoundCategory.BLOCKS, 1.5f, 1.0f);
                cast.func_70296_d();
                world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 2);
                return true;
            }
        }
        if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof ItemTool && ((ItemTool)player.func_184586_b(hand).func_77973_b()).getToolClasses(player.func_184586_b(hand)).contains("shovel")) {
            if (cast.amount > 0) {
                ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(cast.type, cast.amount));
                if (!player.field_71071_by.func_70441_a(scrap)) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, scrap));
                } else {
                    player.field_71069_bz.func_75142_b();
                }
                cast.amount = 0;
                cast.type = null;
                cast.func_70296_d();
                world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 2);
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityFoundryCastingBase cast = (TileEntityFoundryCastingBase)world.func_175625_s(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (cast.amount > 0) {
            ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(cast.type, cast.amount));
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, scrap));
            cast.amount = 0;
        }
        InventoryHelper.dropInventoryItems(world, pos, (ICapabilityProvider)cast);
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        TileEntityFoundryCastingBase cast = (TileEntityFoundryCastingBase)world.func_175625_s(pos);
        if (cast.amount > 0 && cast.amount >= cast.getCapacity()) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.25 + rand.nextDouble() * 0.5, (double)pos.func_177956_o() + this.getPH(), (double)pos.func_177952_p() + 0.25 + rand.nextDouble() * 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        TileEntityFoundryCastingBase cast = (TileEntityFoundryCastingBase)world.func_175625_s(new BlockPos(x, y, z));
        if (cast.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        if (cast.amount > 0) {
            return false;
        }
        if (!player.field_71071_by.func_70441_a(cast.inventory.getStackInSlot(0).func_77946_l())) {
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, cast.inventory.getStackInSlot(0).func_77946_l()));
        } else {
            player.field_71069_bz.func_75142_b();
        }
        cast.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        return true;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntityFoundryCastingBase cast = (TileEntityFoundryCastingBase)world.func_175625_s(new BlockPos(x, y, z));
        ArrayList<String> text = new ArrayList<String>();
        if (cast.inventory.getStackInSlot(0).func_190926_b()) {
            text.add("\u00a7c" + I18nUtil.resolveKey("foundry.noCast", new Object[0]));
        } else if (cast.inventory.getStackInSlot(0).func_77973_b() == ModItems.mold) {
            ItemMold.Mold mold = ((ItemMold)cast.inventory.getStackInSlot(0).func_77973_b()).getMold(cast.inventory.getStackInSlot(0));
            text.add("\u00a7e" + mold.getTitle());
        }
        if (cast.type != null && cast.amount > 0) {
            text.add("&[" + cast.type.moltenColor + "&]" + I18nUtil.resolveKey(cast.type.getTranslationKey(), new Object[0]) + ": " + cast.amount + " / " + cast.getCapacity());
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFF4000, 0x401000, text);
    }
}

