/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import api.hbm.block.IToolable;
import com.hbm.blocks.BlockBase;
import com.hbm.blocks.ICustomBlockItem;
import com.hbm.blocks.ILookOverlay;
import com.hbm.handler.NTMToolHandler;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.IModelRegister;
import com.hbm.util.I18nUtil;
import com.hbm.util.InventoryUtil;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockToolConversion
extends BlockBase
implements IToolable,
ILookOverlay,
ICustomBlockItem {
    public static final PropertyBool TOOLED = PropertyBool.func_177716_a((String)"tooled");
    public static HashMap<Object[], Object> bufferedRecipes = new HashMap();
    public static HashMap<Object[], Object> bufferedTools = new HashMap();

    public BlockToolConversion(Material mat, String s) {
        super(mat, s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TOOLED, (Comparable)Boolean.valueOf(false)));
    }

    public static IToolable.ToolType quickLookup(ItemStack stack) {
        return IToolable.ToolType.getType(stack);
    }

    public static HashMap<Object[], Object> getRecipes(boolean recipes) {
        if (!bufferedRecipes.isEmpty()) {
            return recipes ? bufferedRecipes : bufferedTools;
        }
        for (Map.Entry<Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>, Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock>> entry : NTMToolHandler.conversions.entrySet()) {
            ArrayList<RecipesCommon.AStack> list = new ArrayList<RecipesCommon.AStack>();
            list.addAll(Arrays.asList(entry.getValue().getKey()));
            list.add(new RecipesCommon.ComparableStack(entry.getKey().getValue().block, 1, entry.getKey().getValue().meta));
            RecipesCommon.AStack[] inputInstance = list.toArray(new RecipesCommon.AStack[0]);
            bufferedRecipes.put(inputInstance, new ItemStack(entry.getValue().getValue().block, 1, entry.getValue().getValue().meta));
            bufferedTools.put(inputInstance, entry.getKey().getKey().stacksForDisplay.toArray(new ItemStack[0]));
        }
        return recipes ? bufferedRecipes : bufferedTools;
    }

    @Override
    public void registerItem() {
        BlockToolConversionItem itemBlock = new BlockToolConversionItem(this);
        itemBlock.setRegistryName(this.getRegistryName());
        itemBlock.func_77637_a(this.func_149708_J());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TOOLED});
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int meta = (Boolean)state.func_177229_b((IProperty)TOOLED) != false ? 1 : 0;
        return Collections.singletonList(new ItemStack(Item.func_150898_a((Block)this), 1, meta));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int meta = stack.func_77960_j();
        world.func_180501_a(pos, this.func_176203_a(meta), 3);
    }

    public String getTranslationKey(IBlockState state) {
        return super.func_149739_a() + ((Boolean)state.func_177229_b((IProperty)TOOLED) != false ? "_tooled" : "");
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TOOLED) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TOOLED, (Comparable)Boolean.valueOf(meta == 1));
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        if (world.field_72995_K) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        int meta = this.func_176201_c(state);
        Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock> result = NTMToolHandler.getConversions().get(new Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>(tool, new RecipesCommon.MetaBlock(this, meta)));
        if (result == null) {
            return false;
        }
        ArrayList<RecipesCommon.AStack> materials = new ArrayList<RecipesCommon.AStack>(Arrays.asList(result.getKey()));
        if (materials.isEmpty() || InventoryUtil.doesPlayerHaveAStacks(player, materials, true)) {
            world.func_180501_a(pos, this.func_176203_a(result.getValue().meta), 3);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        ItemStack held = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        IToolable.ToolType tool = BlockToolConversion.quickLookup(held);
        if (tool == null) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        int meta = this.func_176201_c(state);
        Tuple.Pair<RecipesCommon.AStack[], RecipesCommon.MetaBlock> result = NTMToolHandler.getConversions().get(new Tuple.Pair<IToolable.ToolType, RecipesCommon.MetaBlock>(tool, new RecipesCommon.MetaBlock(this, meta)));
        if (result == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.GOLD + "Requires:");
        for (RecipesCommon.AStack stack : result.getKey()) {
            try {
                ItemStack display = stack.extractForCyclingDisplay(20);
                text.add("- " + display.func_82833_r() + " x" + display.func_190916_E());
            }
            catch (Exception ex) {
                text.add(TextFormatting.RED + "- ERROR");
            }
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(state.func_177230_c().func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public class BlockToolConversionItem
    extends ItemBlock
    implements IModelRegister {
        public BlockToolConversionItem(Block block) {
            super(block);
            this.func_77627_a(true);
            this.canRepair = false;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i <= 1; ++i) {
                    list.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return super.func_77658_a() + (stack.func_77960_j() == 1 ? "_tooled" : "");
        }

        @Override
        public void registerModels() {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "tooled=false"));
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_tooled", "tooled=true"));
        }
    }
}

