/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.BlockBase;
import com.hbm.blocks.ModBlocks;
import com.hbm.hazard.HazardSystem;
import com.hbm.lib.ForgeDirection;
import com.hbm.main.MainRegistry;
import com.hbm.potion.HbmPotion;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ContaminationUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHazard
extends BlockBase {
    private float radIn = 0.0f;
    private float radMax = 0.0f;
    private float rad3d = 0.0f;
    private ExtDisplayEffect extEffect = null;
    private boolean beaconable = false;

    public BlockHazard(Material mat, String s) {
        super(mat, s);
    }

    public BlockHazard(String s) {
        this(Material.field_151573_f, s);
    }

    public BlockHazard(Material mat, SoundType type, String s) {
        this(mat, s);
        this.func_149672_a(type);
    }

    public BlockHazard(SoundType type, String s) {
        this(Material.field_151573_f, s);
        this.func_149672_a(type);
    }

    public BlockHazard setDisplayEffect(ExtDisplayEffect extEffect) {
        this.extEffect = extEffect;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        if (this.extEffect == null) {
            return;
        }
        switch (this.extEffect) {
            case RADFOG: 
            case SCHRAB: 
            case FLAMES: {
                this.sPart(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), rand);
                break;
            }
            case SPARKS: {
                break;
            }
            case LAVAPOP: {
                worldIn.func_175688_a(EnumParticleTypes.LAVA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                break;
            }
        }
    }

    private void sPart(World world, int x, int y, int z, Random rand) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir == ForgeDirection.DOWN && this.extEffect == ExtDisplayEffect.FLAMES || world.func_180495_p(new BlockPos(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)).func_185904_a() != Material.field_151579_a) continue;
            double ix = (double)((float)x + 0.5f + (float)dir.offsetX) + rand.nextDouble() * 3.0 - 1.5;
            double iy = (double)((float)y + 0.5f + (float)dir.offsetY) + rand.nextDouble() * 3.0 - 1.5;
            double iz = (double)((float)z + 0.5f + (float)dir.offsetZ) + rand.nextDouble() * 3.0 - 1.5;
            if (dir.offsetX != 0) {
                ix = (double)((float)x + 0.5f) + (double)dir.offsetX * 0.5 + rand.nextDouble() * (double)dir.offsetX;
            }
            if (dir.offsetY != 0) {
                iy = (double)((float)y + 0.5f) + (double)dir.offsetY * 0.5 + rand.nextDouble() * (double)dir.offsetY;
            }
            if (dir.offsetZ != 0) {
                iz = (double)((float)z + 0.5f) + (double)dir.offsetZ * 0.5 + rand.nextDouble() * (double)dir.offsetZ;
            }
            if (this.extEffect == ExtDisplayEffect.RADFOG) {
                world.func_175688_a(EnumParticleTypes.TOWN_AURA, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.extEffect == ExtDisplayEffect.SCHRAB) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "schrabfog");
                data.func_74780_a("posX", ix);
                data.func_74780_a("posY", iy);
                data.func_74780_a("posZ", iz);
                MainRegistry.proxy.effectNT(data);
            }
            if (this.extEffect != ExtDisplayEffect.FLAMES) continue;
            world.func_175688_a(EnumParticleTypes.FLAME, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, ix, iy, iz, 0.0, 0.1, 0.0, new int[0]);
        }
    }

    public BlockHazard addRadiation(float radiation) {
        this.radIn = radiation * 0.1f;
        this.radMax = radiation;
        return this;
    }

    public BlockHazard makeBeaconable() {
        this.beaconable = true;
        return this;
    }

    public BlockHazard addRad3d(int rad3d) {
        this.rad3d = rad3d;
        return this;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return this.beaconable;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.rad3d > 0.0f) {
            ContaminationUtil.radiate(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 32.0, this.rad3d, 0.0f, 0.0f, 0.0f, 0.0);
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
        if (this == ModBlocks.block_meteor_molten) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, ModBlocks.block_meteor_cobble.func_176223_P());
            }
            worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            return;
        }
        if (this.radIn > 0.0f) {
            RadiationSavedData.incrementRad(worldIn, pos, this.radIn, this.radIn * 10.0f);
        }
    }

    public int func_149738_a(World world) {
        if (this.rad3d > 0.0f) {
            return 20;
        }
        if (this.radIn > 0.0f) {
            return 60 + world.field_73012_v.nextInt(500);
        }
        return super.func_149738_a(world);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (this.radIn > 0.0f || this.rad3d > 0.0f) {
            this.func_149675_a(true);
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (this == ModBlocks.block_meteor_molten && !world.field_72995_K) {
            world.func_175656_a(pos, Blocks.field_150353_l.func_176223_P());
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            HazardSystem.applyHazards(this, (EntityLivingBase)entity);
        }
        if (entity instanceof EntityLivingBase && this == ModBlocks.brick_jungle_mystic) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)HbmPotion.taint, 300, 2));
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            HazardSystem.applyHazards(this, (EntityLivingBase)entity);
        }
        if (entity instanceof EntityLivingBase && this == ModBlocks.brick_jungle_mystic) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)HbmPotion.taint, 300, 2));
            return;
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this == ModBlocks.frozen_planks) {
            return Items.field_151126_ay;
        }
        if (this == ModBlocks.frozen_dirt) {
            return Items.field_151126_ay;
        }
        return Item.func_150898_a((Block)this);
    }

    public static enum ExtDisplayEffect {
        RADFOG,
        SPARKS,
        SCHRAB,
        FLAMES,
        LAVAPOP;

    }
}

