/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.fluid;

import com.hbm.blocks.ModBlocks;
import com.hbm.util.ContaminationUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class RadWaterBlock
extends BlockFluidClassic {
    private DamageSource damageSource;
    public int color;

    public RadWaterBlock(Fluid fluid, DamageSource source, String s, int color) {
        super(fluid, Material.field_151586_h);
        this.color = color;
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149647_a(null);
        this.setQuantaPerBlock(4);
        this.damageSource = source;
        this.displacements.put(this, false);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return true;
        }
        return super.canDisplace(world, pos);
    }

    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        if (!this.isWithinFluid((IBlockAccess)world, pos, ActiveRenderInfo.func_178806_a((Entity)entity, (double)partialTicks))) {
            BlockPos otherPos = pos.func_177979_c(this.densityDir);
            IBlockState otherState = world.func_180495_p(otherPos);
            return otherState.func_177230_c().getFogColor(world, otherPos, otherState, entity, originalColor, partialTicks);
        }
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        return new Vec3d((double)red, (double)green, (double)blue);
    }

    private boolean isWithinFluid(IBlockAccess world, BlockPos pos, Vec3d vec) {
        float filled = this.getFilledPercentage(world, pos);
        return filled < 0.0f ? vec.field_72448_b > (double)((float)pos.func_177956_o() + filled + 1.0f) : vec.field_72448_b < (double)((float)pos.func_177956_o() + filled);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            ContaminationUtil.contaminate((EntityLivingBase)entityIn, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 1.0f);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighbourPos) {
        super.func_189540_a(state, world, pos, neighborBlock, neighbourPos);
        this.reactToBlocks(world, pos.func_177974_f(), 2);
        this.reactToBlocks(world, pos.func_177976_e(), 2);
        this.reactToBlocks(world, pos.func_177984_a(), 1);
        this.reactToBlocks(world, pos.func_177977_b(), 3);
        this.reactToBlocks(world, pos.func_177968_d(), 2);
        this.reactToBlocks(world, pos.func_177978_c(), 2);
    }

    public void reactToBlocks(World world, BlockPos pos, int flag) {
        IBlockState block;
        if (world.func_180495_p(pos).func_185904_a() != Material.field_151586_h && (block = world.func_180495_p(pos)).func_185904_a() == Material.field_151587_i) {
            if (flag == 1) {
                world.func_175656_a(pos, ModBlocks.sellafield_slaked.func_176223_P());
            } else if (flag == 2) {
                world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
            } else if (flag == 3) {
                world.func_175656_a(pos, ModBlocks.gravel_obsidian.func_176223_P());
            }
        }
    }

    public int func_149738_a(World world) {
        return 15;
    }
}

