/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import api.hbm.block.IToolable;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.effect.EntityNukeTorex;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.entity.logic.EntityNukeExplosionMK5;
import com.hbm.interfaces.IBomb;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.bomb.TileEntityCrashedBomb;
import com.hbm.util.EnchantmentUtil;
import com.hbm.util.I18nUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockCrashedBomb
extends BlockContainer
implements IBomb,
IToolable {
    public static final int chanceDefuse = 100;
    public static final int chanceDefuseDesh = 1000;
    public static final int chanceJump = 10;
    public static final int chanceMine = 5;
    public static final PropertyEnum<EnumDudType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumDudType.class);

    public BlockCrashedBomb(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumDudType.BALEFIRE)));
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCrashedBomb();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < 4; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (fallDistance > 1.0f && worldIn.field_73012_v.nextInt(10) == 0) {
            this.explode(worldIn, pos);
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d && worldIn.field_73012_v.nextInt(5) == 0 && !EnchantmentUtil.hasEnchantment(player.func_184614_ca(), Enchantments.field_185306_r)) {
            this.explode(worldIn, pos);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        ItemStack itemstack = placer.func_184586_b(hand);
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)this)) {
            return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, itemstack.func_77952_i(), placer, hand);
        }
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.DEFUSER) {
            return false;
        }
        if (!world.field_72995_K) {
            Item toolItem = player.func_184586_b(hand).func_77973_b();
            int detChance = 1000;
            if (toolItem.getMaxDamage(player.func_184586_b(hand)) > 0) {
                detChance = 100;
            }
            BlockPos pos = new BlockPos(x, y, z);
            if (world.field_73012_v.nextInt(detChance) == 0 && !EnchantmentUtil.hasEnchantment(player.func_184586_b(hand), Enchantments.field_185306_r)) {
                this.explode(world, pos);
                return true;
            }
            int type = this.func_176201_c(world.func_180495_p(pos));
            world.func_175655_b(pos, false);
            if (type == 0) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.egg_balefire_shard)));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.plate_steel, 10 + world.field_73012_v.nextInt(15))));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.plate_titanium, 2 + world.field_73012_v.nextInt(7))));
            } else if (type == 1) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.ball_tnt, 16)));
            } else if (type == 2) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.ball_tnt, 8)));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.billet_plutonium, 4)));
            } else if (type == 3) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.ball_tnt, 8)));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.billet_plutonium, 2)));
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(ModItems.ingot_cobalt, 12)));
            }
            return true;
        }
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDudType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDudType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumDudType.values()[meta]));
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77952_i() == 0) {
            tooltip.add("\u00a7a[" + I18nUtil.resolveKey("trait.balefirebomb", new Object[0]) + "]\u00a7r");
            tooltip.add(" \u00a7e" + I18nUtil.resolveKey("desc.radius", (int)((double)BombConfig.fatmanRadius * 1.25)) + "\u00a7r");
        } else if (stack.func_77952_i() == 1) {
            tooltip.add("\u00a7c[" + I18nUtil.resolveKey("trait.extremebomb", new Object[0]) + "]\u00a7r");
            tooltip.add(" \u00a7e" + I18nUtil.resolveKey("desc.radius", 40) + "\u00a7r");
        } else if (stack.func_77952_i() == 2) {
            tooltip.add("\u00a7a[" + I18nUtil.resolveKey("trait.nuclearbomb", new Object[0]) + "]\u00a7r");
            tooltip.add(" \u00a7e" + I18nUtil.resolveKey("desc.radius", 35) + "\u00a7r");
            if (!BombConfig.disableNuclear) {
                tooltip.add("\u00a72[Fallout]\u00a7r");
                tooltip.add(" \u00a7aRadius: 70m\u00a7r");
            }
        } else if (stack.func_77952_i() == 3) {
            tooltip.add("\u00a7a[" + I18nUtil.resolveKey("trait.nuclearbomb", new Object[0]) + "]\u00a7r");
            tooltip.add(" \u00a7e" + I18nUtil.resolveKey("desc.radius", 25) + "\u00a7r");
            if (!BombConfig.disableNuclear) {
                tooltip.add("\u00a72[Fallout]\u00a7r");
                tooltip.add(" \u00a7aRadius: 75m\u00a7r");
            }
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            int type = this.func_176201_c(world.func_180495_p(pos));
            world.func_175698_g(pos);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (type == 0) {
                EntityBalefire bf = new EntityBalefire(world);
                bf.field_70165_t = x;
                bf.field_70163_u = y;
                bf.field_70161_v = z;
                bf.destructionRange = (int)((double)BombConfig.fatmanRadius * 1.25);
                world.func_72838_d((Entity)bf);
                if (BombConfig.enableNukeClouds) {
                    EntityNukeTorex.statFacBale(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 5, (double)pos.func_177952_p() + 0.5, (int)((double)BombConfig.fatmanRadius * 1.25));
                }
            } else if (type == 1) {
                world.func_72838_d((Entity)EntityNukeExplosionMK5.statFacNoRad(world, 40, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                if (BombConfig.enableNukeClouds) {
                    EntityNukeTorex.statFac(world, (double)x + 0.5, y + 5, (double)z + 0.5, 40.0f);
                }
            } else if (type == 2) {
                world.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(world, 35, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
                if (BombConfig.enableNukeClouds) {
                    if (MainRegistry.polaroidID == 11 || world.field_73012_v.nextInt(100) == 0) {
                        EntityNukeTorex.statFacBale(world, (double)x + 0.5, y + 5, (double)z + 0.5, 35.0f);
                    } else {
                        EntityNukeTorex.statFac(world, (double)x + 0.5, y + 5, (double)z + 0.5, 35.0f);
                    }
                }
            } else if (type == 3) {
                world.func_72838_d((Entity)EntityNukeExplosionMK5.statFac(world, 25, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5).moreFallout(25));
                if (BombConfig.enableNukeClouds) {
                    if (MainRegistry.polaroidID == 11 || world.field_73012_v.nextInt(100) == 0) {
                        EntityNukeTorex.statFacBale(world, (double)x + 0.5, y + 5, (double)z + 0.5, 25.0f);
                    } else {
                        EntityNukeTorex.statFac(world, (double)x + 0.5, y + 5, (double)z + 0.5, 25.0f);
                    }
                }
            }
        }
    }

    public static enum EnumDudType implements IStringSerializable
    {
        BALEFIRE("bale"),
        CONVENTIONAL("n2"),
        NUKE("nuke"),
        SALTED("salt");

        private final String name;

        private EnumDudType(String n2) {
            this.name = n2;
        }

        @NotNull
        public String func_176610_l() {
            return this.name;
        }
    }
}

