/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks;

import com.hbm.blocks.ModBlocks;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.interfaces.ICopiable;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.InventoryHelper;
import com.hbm.main.MainRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class BlockDummyable
extends BlockContainer
implements ICopiable {
    public static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)15);
    public static final int offset = 10;
    public static final int extra = 6;
    public static boolean safeRem = false;
    List<BlockPos> positions = new ArrayList<BlockPos>();
    public List<AxisAlignedBB> bounding = new ArrayList<AxisAlignedBB>();

    public BlockDummyable(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_149675_a(true);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.field_72995_K || safeRem) {
            return;
        }
        int metadata = (Integer)state.func_177229_b((IProperty)META);
        if (metadata >= 6) {
            metadata -= 6;
        }
        ForgeDirection dir = ForgeDirection.getOrientation(metadata).getOpposite();
        Block b = world.func_180495_p(new BlockPos(pos.func_177958_n() + dir.offsetX, pos.func_177956_o() + dir.offsetY, pos.func_177952_p() + dir.offsetZ)).func_177230_c();
        if (b.getClass() != this.getClass()) {
            world.func_175698_g(pos);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (world.field_72995_K) {
            return;
        }
        int metadata = (Integer)state.func_177229_b((IProperty)META);
        if (metadata >= 6) {
            metadata -= 6;
        }
        ForgeDirection dir = ForgeDirection.getOrientation(metadata).getOpposite();
        Block b = world.func_180495_p(new BlockPos(pos.func_177958_n() + dir.offsetX, pos.func_177956_o() + dir.offsetY, pos.func_177952_p() + dir.offsetZ)).func_177230_c();
        if (b.getClass() != this.getClass()) {
            world.func_175698_g(pos);
        }
    }

    public BlockPos findCore(IBlockAccess world, BlockPos pos) {
        this.positions.clear();
        int[] p = this.findCoreRec(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (p == null) {
            return null;
        }
        return new BlockPos(p[0], p[1], p[2]);
    }

    public int[] findCore(IBlockAccess world, int x, int y, int z) {
        this.positions.clear();
        return this.findCoreRec(world, x, y, z);
    }

    public int[] findCoreRec(IBlockAccess world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().getClass() != this.getClass()) {
            return null;
        }
        int metadata = (Integer)state.func_177229_b((IProperty)META);
        if (metadata >= 6) {
            metadata -= 6;
        }
        if (ForgeDirection.getOrientation(metadata) == ForgeDirection.UNKNOWN) {
            return new int[]{x, y, z};
        }
        if (this.positions.contains(pos)) {
            return null;
        }
        ForgeDirection dir = ForgeDirection.getOrientation(metadata).getOpposite();
        this.positions.add(pos);
        return this.findCoreRec(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemStack) {
        int z;
        int y;
        if (!(player instanceof EntityPlayer)) {
            return;
        }
        world.func_175698_g(pos);
        EntityPlayer pl = (EntityPlayer)player;
        EnumHand hand = pl.func_184614_ca() == itemStack ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int o = -this.getOffset();
        pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + this.getHeightOffset(), pos.func_177952_p());
        ForgeDirection dir = ForgeDirection.NORTH;
        if (i == 0) {
            dir = ForgeDirection.getOrientation(2);
        }
        if (i == 1) {
            dir = ForgeDirection.getOrientation(5);
        }
        if (i == 2) {
            dir = ForgeDirection.getOrientation(3);
        }
        if (i == 3) {
            dir = ForgeDirection.getOrientation(4);
        }
        dir = this.getDirModified(dir);
        int x = pos.func_177958_n();
        if (!this.checkRequirement(world, x, y = pos.func_177956_o(), z = pos.func_177952_p(), dir, o)) {
            if (!pl.field_71075_bZ.field_75098_d) {
                ItemStack stack = (ItemStack)pl.field_71071_by.field_70462_a.get(pl.field_71071_by.field_70461_c);
                Item item = Item.func_150898_a((Block)this);
                if (stack.func_190926_b()) {
                    pl.field_71071_by.field_70462_a.set(pl.field_71071_by.field_70461_c, (Object)new ItemStack((Block)this));
                } else if (stack.func_77973_b() != item || stack.func_190916_E() == stack.func_77976_d()) {
                    pl.field_71071_by.func_70441_a(new ItemStack((Block)this));
                } else {
                    pl.func_184586_b(hand).func_190917_f(1);
                }
            }
            return;
        }
        if (!world.field_72995_K) {
            world.func_180501_a(new BlockPos(x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o), this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(dir.ordinal() + 10)), 3);
            this.fillSpace(world, x, y, z, dir, o);
        }
        pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - this.getHeightOffset(), pos.func_177952_p());
        world.func_175684_a(pos, (Block)this, 1);
        world.func_175684_a(pos, (Block)this, 2);
        super.func_180633_a(world, pos, state, player, itemStack);
    }

    protected boolean standardOpenBehavior(World world, int x, int y, int z, EntityPlayer player, int id) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int[] pos = this.findCore((IBlockAccess)world, x, y, z);
            if (pos == null) {
                return false;
            }
            player.openGui((Object)MainRegistry.instance, id, world, pos[0], pos[1], pos[2]);
            return true;
        }
        return true;
    }

    protected ForgeDirection getDirModified(ForgeDirection dir) {
        return dir;
    }

    protected boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        return MultiblockHandlerXR.checkSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, this.getDimensions(), x, y, z, dir);
    }

    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        MultiblockHandlerXR.fillSpace(world, x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o, this.getDimensions(), (Block)this, dir);
    }

    public void makeExtra(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return;
        }
        int meta = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)META);
        if (meta > 5) {
            return;
        }
        safeRem = true;
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta + 6)), 3);
        safeRem = false;
    }

    public void removeExtra(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_180495_p(pos).func_177230_c() != this) {
            return;
        }
        int meta = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)META);
        if (meta <= 5 || meta >= 12) {
            return;
        }
        safeRem = true;
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta - 6)), 3);
        safeRem = false;
    }

    public boolean hasExtra(int meta) {
        return meta > 5 && meta < 12;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)META);
        if (i < 12 && !safeRem) {
            if (i >= 6) {
                i -= 6;
            }
            ForgeDirection dir = ForgeDirection.getOrientation(i).getOpposite();
            int[] pos1 = this.findCore((IBlockAccess)world, pos.func_177958_n() + dir.offsetX, pos.func_177956_o() + dir.offsetY, pos.func_177952_p() + dir.offsetZ);
            if (pos1 != null) {
                world.func_175698_g(new BlockPos(pos1[0], pos1[1], pos1[2]));
            }
        }
        InventoryHelper.dropInventoryItems(world, pos, (ICapabilityProvider)world.func_175625_s(pos));
        super.func_180663_b(world, pos, state);
    }

    public boolean useDetailedHitbox() {
        return !this.bounding.isEmpty();
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!this.useDetailedHitbox()) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
            return;
        }
        int[] corePos = this.findCore((IBlockAccess)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (corePos == null) {
            return;
        }
        BlockPos coreBlockPos = new BlockPos(corePos[0], corePos[1], corePos[2]);
        for (AxisAlignedBB aabb : this.bounding) {
            AxisAlignedBB rotatedBox = BlockDummyable.getAABBRotationOffset(aabb, (double)coreBlockPos.func_177958_n() + 0.5, coreBlockPos.func_177956_o(), (double)coreBlockPos.func_177952_p() + 0.5, this.getRotationFromState(worldIn.func_180495_p(coreBlockPos)));
            if (!entityBox.func_72326_a(rotatedBox)) continue;
            collidingBoxes.add(rotatedBox);
        }
    }

    private ForgeDirection getRotationFromState(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)META);
        return ForgeDirection.getOrientation(meta - 10).getRotation(ForgeDirection.UP);
    }

    public static AxisAlignedBB getAABBRotationOffset(AxisAlignedBB aabb, double x, double y, double z, ForgeDirection dir) {
        AxisAlignedBB newBox = null;
        if (dir == ForgeDirection.NORTH) {
            newBox = new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        } else if (dir == ForgeDirection.EAST) {
            newBox = new AxisAlignedBB(-aabb.field_72334_f, aabb.field_72338_b, aabb.field_72340_a, -aabb.field_72339_c, aabb.field_72337_e, aabb.field_72336_d);
        } else if (dir == ForgeDirection.SOUTH) {
            newBox = new AxisAlignedBB(-aabb.field_72336_d, aabb.field_72338_b, -aabb.field_72334_f, -aabb.field_72340_a, aabb.field_72337_e, -aabb.field_72339_c);
        } else if (dir == ForgeDirection.WEST) {
            newBox = new AxisAlignedBB(aabb.field_72339_c, aabb.field_72338_b, -aabb.field_72336_d, aabb.field_72334_f, aabb.field_72337_e, -aabb.field_72340_a);
        }
        if (newBox != null) {
            return newBox.func_72317_d(x, y, z);
        }
        return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f).func_72317_d(x + 0.5, y + 0.5, z + 0.5);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }

    public abstract int[] getDimensions();

    public abstract int getOffset();

    public int getHeightOffset() {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (!this.useDetailedHitbox()) {
            return field_185505_j;
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.999f, 1.0);
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        TileEntity tile = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (tile instanceof ICopiable) {
            return ((ICopiable)tile).getSettings(world, pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        TileEntity tile = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (tile instanceof ICopiable) {
            ((ICopiable)tile).pasteSettings(nbt, index, world, player, pos[0], pos[1], pos[2]);
        }
    }

    @Override
    public String[] infoForDisplay(World world, int x, int y, int z) {
        int[] pos = this.findCore((IBlockAccess)world, x, y, z);
        TileEntity tile = world.func_175625_s(new BlockPos(pos[0], pos[1], pos[2]));
        if (tile instanceof ICopiable) {
            return ((ICopiable)tile).infoForDisplay(world, x, y, z);
        }
        return null;
    }
}

