/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.animloader;

import com.hbm.animloader.AnimationController;
import com.hbm.animloader.AnimationWrapper;
import com.hbm.animloader.Transform;
import com.hbm.util.BobMathUtil;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class AnimatedModel {
    public static FloatBuffer auxGLMatrix = GLAllocation.func_74529_h((int)16);
    public AnimationController controller;
    public String name = "";
    public float[] transform;
    boolean hasGeometry = true;
    boolean hasTransform = false;
    public String geo_name = "";
    public AnimatedModel parent;
    public List<AnimatedModel> children = new ArrayList<AnimatedModel>();
    int callList;

    public void renderAnimated(long sysTime) {
        this.renderAnimated(sysTime, null);
    }

    public void renderAnimated(long sysTime, IAnimatedModelCallback c) {
        if (this.controller.activeAnim == AnimationWrapper.EMPTY) {
            this.render(c);
            return;
        }
        AnimationWrapper activeAnim = this.controller.activeAnim;
        int numKeyFrames = activeAnim.anim.numKeyFrames;
        int diff = (int)(sysTime - activeAnim.startTime);
        if ((diff = (int)((float)diff * activeAnim.speedScale)) > activeAnim.anim.length) {
            int diff2 = diff % activeAnim.anim.length;
            switch (activeAnim.endResult.type) {
                case END: {
                    this.controller.activeAnim = AnimationWrapper.EMPTY;
                    this.render(c);
                    return;
                }
                case REPEAT: {
                    activeAnim.startTime = sysTime - (long)diff2;
                    break;
                }
                case REPEAT_REVERSE: {
                    activeAnim.startTime = sysTime - (long)diff2;
                    activeAnim.reverse = !activeAnim.reverse;
                    break;
                }
                case START_NEW: {
                    activeAnim.cloneStats(activeAnim.endResult.next);
                    activeAnim.startTime = sysTime - (long)diff2;
                    break;
                }
                case STAY: {
                    activeAnim.startTime = sysTime - (long)activeAnim.anim.length;
                }
            }
        }
        diff = (int)(sysTime - activeAnim.startTime);
        if (activeAnim.reverse) {
            diff = activeAnim.anim.length - diff;
        }
        diff = (int)((float)diff * activeAnim.speedScale);
        float remappedTime = MathHelper.func_76131_a((float)BobMathUtil.remap(diff, 0.0f, activeAnim.anim.length, 0.0f, numKeyFrames - 1), (float)0.0f, (float)(numKeyFrames - 1));
        float diffN = BobMathUtil.remap01_clamp(diff, 0.0f, activeAnim.anim.length);
        int index = (int)remappedTime;
        int next = index < numKeyFrames - 1 ? index + 1 : index;
        this.renderWithIndex(AnimatedModel.fract(remappedTime), index, next, diffN, c);
        this.controller.activeAnim.prevFrame = index;
    }

    protected void renderWithIndex(float inter, int firstIndex, int nextIndex, float diffN, IAnimatedModelCallback c) {
        GL11.glPushMatrix();
        boolean hidden = false;
        if (this.hasTransform) {
            Transform[] transforms = this.controller.activeAnim.anim.objectTransforms.get(this.name);
            if (transforms != null) {
                hidden = transforms[firstIndex].hidden;
                transforms[firstIndex].interpolateAndApply(transforms[nextIndex], inter);
            } else {
                auxGLMatrix.put(this.transform);
                auxGLMatrix.rewind();
                GL11.glMultMatrix((FloatBuffer)auxGLMatrix);
            }
        }
        if (c != null) {
            hidden |= c.onRender(this.controller.activeAnim.prevFrame, firstIndex, this.callList, diffN, this.name);
        }
        if (this.hasGeometry && !hidden) {
            GL11.glCallList((int)this.callList);
        }
        if (c != null) {
            c.postRender(this.controller.activeAnim.prevFrame, firstIndex, this.callList, diffN, this.name);
        }
        for (AnimatedModel m : this.children) {
            m.renderWithIndex(inter, firstIndex, nextIndex, diffN, c);
        }
        GL11.glPopMatrix();
    }

    public void render() {
        this.render(null);
    }

    public void render(IAnimatedModelCallback c) {
        GL11.glPushMatrix();
        if (this.hasTransform) {
            auxGLMatrix.put(this.transform);
            auxGLMatrix.rewind();
            GL11.glMultMatrix((FloatBuffer)auxGLMatrix);
        }
        boolean hidden = false;
        if (c != null) {
            hidden = c.onRender(-1, -1, this.callList, -1.0f, this.name);
        }
        if (this.hasGeometry && !hidden) {
            GL11.glCallList((int)this.callList);
        }
        if (c != null) {
            c.postRender(-1, -1, this.callList, -1.0f, this.name);
        }
        for (AnimatedModel m : this.children) {
            m.render(c);
        }
        GL11.glPopMatrix();
    }

    private static float fract(float number) {
        return (float)((double)number - Math.floor(number));
    }

    public static interface IAnimatedModelCallback {
        public boolean onRender(int var1, int var2, int var3, float var4, String var5);

        default public void postRender(int prevFrame, int currentFrame, int model, float diffN, String modelName) {
        }
    }
}

