/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.block;

import com.hbm.inventory.RecipesCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IToolable {
    public boolean onScrew(World var1, EntityPlayer var2, int var3, int var4, int var5, EnumFacing var6, float var7, float var8, float var9, EnumHand var10, ToolType var11);

    default public boolean onScrew(World world, EntityPlayer player, BlockPos pos, EnumFacing side, float fX, float fY, float fZ, EnumHand hand, ToolType tool) {
        return this.onScrew(world, player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), side, fX, fY, fZ, hand, tool);
    }

    public static enum ToolType {
        SCREWDRIVER,
        HAND_DRILL,
        DEFUSER,
        WRENCH,
        TORCH,
        BOLT;

        public final List<ItemStack> stacksForDisplay = new ArrayList<ItemStack>();
        private static final HashMap<RecipesCommon.ComparableStack, ToolType> map;

        public void register(ItemStack stack) {
            this.stacksForDisplay.add(stack);
        }

        public static ToolType getType(ItemStack stack) {
            if (!map.isEmpty()) {
                return map.get(new RecipesCommon.ComparableStack(stack));
            }
            for (ToolType type : ToolType.values()) {
                for (ItemStack tool : type.stacksForDisplay) {
                    map.put(new RecipesCommon.ComparableStack(tool), type);
                }
            }
            return map.get(new RecipesCommon.ComparableStack(stack));
        }

        static {
            map = new HashMap();
        }
    }
}

