/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator.room;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockNTMLadder;
import com.hbm.blocks.machine.VaultDoor;
import com.hbm.lib.Library;
import com.hbm.world.generator.CellularDungeon;
import com.hbm.world.generator.DungeonToolbox;
import com.hbm.world.generator.TimedGenerator;
import com.hbm.world.generator.VaultDungeon;
import com.hbm.world.generator.room.VaultDungeonRoom;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VaultDungeonRoomElevator
extends VaultDungeonRoom {
    public static int doorRoomX = 19;
    public static int doorRoomY = 9;
    public static int doorRoomZ = 17;
    public static List<IBlockState> bricks = new ArrayList<IBlockState>();
    public static IBlockState haz = ModBlocks.concrete_hazard.func_176223_P();
    public static IBlockState decoSteel = ModBlocks.deco_steel.func_176223_P();
    public static IBlockState ducRef = ModBlocks.ducrete_reinforced.func_176223_P();
    public static IBlockState plating = ModBlocks.deco_tungsten.func_176223_P();
    public static IBlockState dark = ModBlocks.concrete_gray.func_176223_P();
    public static IBlockState pillar = ModBlocks.concrete_pillar.func_176223_P();
    public static IBlockState grate = ModBlocks.steel_grate.func_176203_a(7);
    public static IBlockState ladderE = ModBlocks.ladder_steel.func_176223_P().func_177226_a((IProperty)BlockNTMLadder.field_176382_a, (Comparable)EnumFacing.WEST);
    public static IBlockState ladderW = ModBlocks.ladder_steel.func_176223_P().func_177226_a((IProperty)BlockNTMLadder.field_176382_a, (Comparable)EnumFacing.EAST);
    public static IBlockState railing = ModBlocks.railing_normal.func_176203_a(5);

    public VaultDungeonRoomElevator(CellularDungeon parent, int lineColor) {
        super(parent, lineColor);
        bricks.add(ModBlocks.brick_concrete.func_176223_P());
        bricks.add(ModBlocks.brick_concrete_broken.func_176223_P());
        bricks.add(ModBlocks.brick_concrete_cracked.func_176223_P());
        bricks.add(ModBlocks.brick_concrete_mossy.func_176223_P());
    }

    @Override
    public IBlockState getLine(int x, int z) {
        CellularDungeon cellularDungeon = this.parent;
        if (cellularDungeon instanceof VaultDungeon) {
            VaultDungeon vault = (VaultDungeon)cellularDungeon;
            if (vault.hasElevator && vault.elevatorRoom == this && (vault.eX != x + this.parent.width / 2 || vault.eZ != z + this.parent.width / 2)) {
                this.resetLine();
            }
        }
        return this.line;
    }

    public boolean spawnGlow() {
        return true;
    }

    @Override
    public void generateMain(World world, int x, int y, int z) {
        super.generateMain(world, x, y, z);
        TimedGenerator.ITimedJob job = () -> {
            CellularDungeon patt2860$temp = this.parent;
            if (patt2860$temp instanceof VaultDungeon) {
                VaultDungeon vault = (VaultDungeon)patt2860$temp;
                if (!vault.hasElevator) {
                    vault.eX = x + this.parent.width / 2;
                    vault.eZ = z + this.parent.width / 2;
                    vault.hasElevator = true;
                    this.line = Blocks.field_192443_dR.func_176203_a(4);
                    vault.elevatorRoom = this;
                    int h = Math.max(Library.getGroundHeight(world, vault.eX, vault.eZ) - 25, y + this.parent.height + 10);
                    this.generateVaultDoorRoom(world, vault.eX, h, vault.eZ);
                    this.generateElevator(world, vault.eX, y, vault.eZ, h, doorRoomY - 2);
                    return;
                }
            }
            this.generateRoom(world, x, y, z);
            if (!this.spawnGlow()) return;
            world.func_175656_a(new BlockPos(x + this.parent.width / 2, y + 2, z + this.parent.width / 2), ModBlocks.glow_spawner.func_176223_P());
        };
        TimedGenerator.addOp(world, job);
    }

    public void generateRoom(World world, int x, int y, int z) {
    }

    public void generateVaultDoorRoom(World world, int x, int y, int z) {
        DungeonToolbox.generateHollowBox(world, x - 5, y - 1, z - doorRoomZ / 2 - 1, doorRoomX + 2, doorRoomY + 2, doorRoomZ + 2, this.parent.wall);
        DungeonToolbox.generateHollowBox(world, x - 4, y, z - doorRoomZ / 2, doorRoomX, doorRoomY, doorRoomZ, shielding);
        DungeonToolbox.generateBox(world, x - 3, y + 1, z - doorRoomZ / 2 + 1, doorRoomX - 2, 1, doorRoomZ - 2, this.parent.floor);
        DungeonToolbox.generateWalls(world, x - 3, y + 2, z - doorRoomZ / 2 + 1, doorRoomX - 2, doorRoomY - 4, doorRoomZ - 2, dark);
        DungeonToolbox.generateBox(world, x - 3, y + doorRoomY - 2, z - doorRoomZ / 2 + 1, doorRoomX - 2, 1, doorRoomZ - 2, this.parent.ceiling);
        DungeonToolbox.generateBox(world, x - 2, y + 2, z - doorRoomZ / 2 + 2, doorRoomX - 4, doorRoomY - 4, doorRoomZ - 4, air);
        DungeonToolbox.generateBox(world, x + doorRoomX - 5, y + 1, z - 5, 1, 7, 7, ducRef);
        DungeonToolbox.generateBox(world, x + doorRoomX - 6, y + 2, z - 4, 3, 5, 5, air);
        VaultDoor.placeVaultDoor(world, new BlockPos(x + doorRoomX - 6, y + 2, z - 2), EnumFacing.EAST);
        world.func_180501_a(new BlockPos(x + doorRoomX - 7, y + 4, z - 5), Blocks.field_150442_at.func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(x + doorRoomX - 5, y + 4, z - 4), Blocks.field_150430_aB.func_176203_a(3), 3);
        DungeonToolbox.generateBox(world, x + doorRoomX - 8, y + 1, z - doorRoomZ / 2 + 2, 1, 1, doorRoomZ - 4, haz);
        DungeonToolbox.generateBox(world, x + doorRoomX - 8, y + 2, z - doorRoomZ / 2 + 2, 1, 1, doorRoomZ - 4, railing);
        DungeonToolbox.generateBox(world, x + doorRoomX - 6, y + 4, z + 1, 1, 1, 6, decoSteel);
        DungeonToolbox.generateBox(world, x + doorRoomX - 11, y + 2, z - 3, 4, 1, 3, grate);
        world.func_180501_a(new BlockPos(x + doorRoomX - 8, y + 3, z - 3), ModBlocks.railing_end_flipped_self.func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(x + doorRoomX - 9, y + 3, z - 3), ModBlocks.railing_normal.func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(x + doorRoomX - 10, y + 3, z - 3), ModBlocks.railing_normal.func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(x + doorRoomX - 11, y + 3, z - 3), ModBlocks.railing_end_self.func_176203_a(3), 3);
        world.func_180501_a(new BlockPos(x + doorRoomX - 8, y + 3, z - 1), ModBlocks.railing_end_self.func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(x + doorRoomX - 9, y + 3, z - 1), ModBlocks.railing_normal.func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(x + doorRoomX - 10, y + 3, z - 1), ModBlocks.railing_normal.func_176203_a(2), 3);
        world.func_180501_a(new BlockPos(x + doorRoomX - 11, y + 3, z - 1), ModBlocks.railing_end_flipped_self.func_176203_a(2), 3);
        DungeonToolbox.generateBox(world, x + doorRoomX - 11, y + 2, z - 4, 3, 1, 1, ModBlocks.concrete_stairs.func_176203_a(2));
        DungeonToolbox.generateBox(world, x + doorRoomX - 11, y + 2, z, 3, 1, 1, ModBlocks.concrete_stairs.func_176203_a(3));
        DungeonToolbox.generateBox(world, x + doorRoomX - 12, y + 2, z - 4, 1, 1, 5, ModBlocks.concrete_stairs.func_176203_a(0));
        int h = Library.getGroundHeight(world, x + doorRoomX + 8, z - 2) + 1;
        DungeonToolbox.generateHollowBox(world, x + doorRoomX - 3, y, z - 6, 10, 9, 9, bricks);
        DungeonToolbox.generateHollowBox(world, x + doorRoomX + 6, y, z - 4, 5, h - y, 5, bricks);
        DungeonToolbox.generateBox(world, x + doorRoomX + 7, y + 1, z - 3, 3, h - y, 3, air);
        DungeonToolbox.generateBox(world, x + doorRoomX - 4, y + 1, z - 5, 10, 7, 7, air);
        DungeonToolbox.generateBox(world, x + doorRoomX + 6, y + 1, z - 3, 1, 3, 3, air);
        for (int dx = -6; dx < 6; dx += 2) {
            for (int dz = -4; dz < 5; dz += 2) {
                world.func_175656_a(new BlockPos(x + 6 + dx, y + doorRoomY - 2, z - doorRoomZ / 2 + 8 + dz), light);
            }
        }
    }

    public void generateElevator(World world, int x, int y, int z, int h, int ladderOffset) {
        int baseY = y + 2;
        int baseH = h - y - 2 + ladderOffset;
        DungeonToolbox.generateWalls(world, x - 3, y + this.getH(), z - 3, 7, h - this.getH() - y, 7, shielding);
        DungeonToolbox.generateWalls(world, x - 2, baseY, z - 2, 5, baseH, 5, plating);
        DungeonToolbox.generateBox(world, x - 2, baseY, z, 1, baseH, 1, pillar);
        DungeonToolbox.generateBox(world, x + 2, baseY, z, 1, baseH, 1, pillar);
        DungeonToolbox.generateBox(world, x, baseY, z - 2, 1, baseH, 1, pillar);
        DungeonToolbox.generateBox(world, x, baseY, z + 2, 1, baseH, 1, pillar);
        DungeonToolbox.generateBox(world, x - 1, baseY, z - 2, 3, 3, 5, air);
        DungeonToolbox.generateBox(world, x - 1, baseY, z - 1, 1, baseH, 3, ladderW);
        DungeonToolbox.generateBox(world, x, baseY, z - 1, 1, baseH, 3, air);
        DungeonToolbox.generateBox(world, x + 1, baseY, z - 1, 1, baseH, 3, ladderE);
        DungeonToolbox.generateBox(world, x - 1, h + 2, z - 2, 3, 5, 1, air);
        DungeonToolbox.generateBox(world, x - 1, h + 2, z + 2, 3, 5, 1, air);
        world.func_180501_a(new BlockPos(x, h + 1, z + 2), plating, 3);
        world.func_180501_a(new BlockPos(x, h + 1, z - 2), plating, 3);
        world.func_180501_a(new BlockPos(x, y + 5, z + 2), plating, 3);
        world.func_180501_a(new BlockPos(x, y + 5, z - 2), plating, 3);
    }
}

