/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.item.IGasMask;
import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.ArmorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ArmorRegistry {
    public static HashMap<Item, ArrayList<HazardClass>> hazardClasses = new HashMap();

    public static void registerHazard(Item item, HazardClass ... hazards) {
        hazardClasses.put(item, new ArrayList<HazardClass>(Arrays.asList(hazards)));
    }

    public static boolean hasAllProtection(EntityLivingBase entity, EntityEquipmentSlot slot, HazardClass ... clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.func_184582_a(slot));
        return new HashSet<HazardClass>(list).containsAll(Arrays.asList(clazz));
    }

    public static boolean hasAnyProtection(EntityLivingBase entity, EntityEquipmentSlot slot, HazardClass ... clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.func_184582_a(slot));
        if (list == null) {
            return false;
        }
        for (HazardClass haz : clazz) {
            if (!list.contains((Object)haz)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasProtection(EntityLivingBase entity, EntityEquipmentSlot slot, HazardClass clazz) {
        if (ArmorUtil.checkArmorNull(entity, slot)) {
            return false;
        }
        List<HazardClass> list = ArmorRegistry.getProtectionFromItem(entity.func_184582_a(slot));
        if (list == null) {
            return false;
        }
        return list.contains((Object)clazz);
    }

    public static List<HazardClass> getProtectionFromItem(ItemStack stack) {
        IGasMask mask;
        ItemStack filter;
        ArrayList<HazardClass> prot = new ArrayList<HazardClass>();
        Item item = stack.func_77973_b();
        if (hazardClasses.containsKey(item)) {
            prot.addAll((Collection)hazardClasses.get(item));
        }
        if (item instanceof IGasMask && (filter = (mask = (IGasMask)item).getFilter(stack)) != null && !filter.func_190926_b()) {
            List filProt = hazardClasses.get(filter.func_77973_b());
            for (HazardClass c : mask.getBlacklist(stack)) {
                filProt.remove((Object)c);
            }
            prot.addAll(filProt);
        }
        if (ArmorModHandler.hasMods(stack)) {
            ItemStack[] mods;
            for (ItemStack mod : mods = ArmorModHandler.pryMods(stack)) {
                if (mod == null) continue;
                prot.addAll(ArmorRegistry.getProtectionFromItem(mod));
            }
        }
        return prot;
    }

    public static enum HazardClass {
        GAS_CHLORINE("hazard.gasChlorine"),
        GAS_MONOXIDE("hazard.gasMonoxide"),
        GAS_INERT("hazard.gasInert"),
        PARTICLE_COARSE("hazard.particleCoarse"),
        PARTICLE_FINE("hazard.particleFine"),
        BACTERIA("hazard.bacteria"),
        NERVE_AGENT("hazard.nerveAgent"),
        GAS_CORROSIVE("hazard.corrosive"),
        SAND("hazard.sand"),
        LIGHT("hazard.light"),
        RAD_GAS("hazard.radGas");

        public final String lang;

        private HazardClass(String lang) {
            this.lang = lang;
        }
    }
}

