/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.block.IConveyorBelt;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.inventory.container.ContainerCraneUnboxer;
import com.hbm.inventory.gui.GUICraneUnboxer;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.TileEntityCraneBase;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCraneUnboxer
extends TileEntityCraneBase
implements IGUIProvider {
    private int tickCounter = 0;
    public static int[] allowed_slots = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};

    public TileEntityCraneUnboxer() {
        super(23);
    }

    @Override
    public String getName() {
        return "container.craneUnboxer";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return allowed_slots;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickCounter;
            int xCoord = this.field_174879_c.func_177958_n();
            int yCoord = this.field_174879_c.func_177956_o();
            int zCoord = this.field_174879_c.func_177952_p();
            int delay = 20;
            if (this.inventory.getStackInSlot(22) != null && this.inventory.getStackInSlot(22) != ItemStack.field_190927_a) {
                if (this.inventory.getStackInSlot(22).func_77973_b() == ModItems.upgrade_ejector_1) {
                    delay = 10;
                } else if (this.inventory.getStackInSlot(22).func_77973_b() == ModItems.upgrade_ejector_2) {
                    delay = 5;
                } else if (this.inventory.getStackInSlot(22).func_77973_b() == ModItems.upgrade_ejector_3) {
                    delay = 2;
                }
            }
            if (this.tickCounter >= delay && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
                EnumFacing inputSide;
                Block b;
                this.tickCounter = 0;
                int amount = 1;
                if (this.inventory.getStackInSlot(21) != null && this.inventory.getStackInSlot(21) != ItemStack.field_190927_a) {
                    if (this.inventory.getStackInSlot(21).func_77973_b() == ModItems.upgrade_stack_1) {
                        amount = 4;
                    } else if (this.inventory.getStackInSlot(21).func_77973_b() == ModItems.upgrade_stack_2) {
                        amount = 16;
                    } else if (this.inventory.getStackInSlot(21).func_77973_b() == ModItems.upgrade_stack_3) {
                        amount = 64;
                    }
                }
                if ((b = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(inputSide = this.getOutputSide())).func_177230_c()) instanceof IConveyorBelt) {
                    IConveyorBelt belt = (IConveyorBelt)b;
                    for (int index : allowed_slots) {
                        ItemStack stack = this.inventory.getStackInSlot(index);
                        if (stack == ItemStack.field_190927_a) continue;
                        int toSend = Math.min(amount, stack.func_190916_E());
                        ItemStack cStack = stack.func_77946_l();
                        stack.func_190918_g(toSend);
                        if (stack.func_190916_E() == 0) {
                            this.inventory.setStackInSlot(index, ItemStack.field_190927_a);
                        }
                        cStack.func_190920_e(toSend);
                        EntityMovingItem moving = new EntityMovingItem(this.field_145850_b);
                        Vec3d pos = new Vec3d((double)xCoord + 0.5 + (double)inputSide.func_176730_m().func_177958_n() * 0.55, (double)yCoord + 0.5 + (double)inputSide.func_176730_m().func_177956_o() * 0.55, (double)zCoord + 0.5 + (double)inputSide.func_176730_m().func_177952_p() * 0.55);
                        Vec3d snap = belt.getClosestSnappingPosition(this.field_145850_b, new BlockPos(xCoord + inputSide.func_176730_m().func_177958_n(), yCoord + inputSide.func_176730_m().func_177956_o(), zCoord + inputSide.func_176730_m().func_177952_p()), pos);
                        moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
                        moving.setItemStack(cStack);
                        this.field_145850_b.func_72838_d((Entity)moving);
                        break;
                    }
                }
            }
        }
    }

    public boolean tryFillTeDirect(ItemStack stack) {
        return this.tryInsertItemCap((IItemHandler)this.inventory, stack);
    }

    public boolean tryInsertItemCap(IItemHandler chest, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i : allowed_slots) {
            ItemStack outputStack = stack.func_77946_l();
            if (outputStack.func_190926_b() || outputStack.func_190916_E() == 0) {
                return true;
            }
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            int fillAmount = Math.min(chestItem.func_77976_d() - chestItem.func_190916_E(), outputStack.func_190916_E());
            outputStack.func_190920_e(fillAmount);
            ItemStack rest = chest.insertItem(i, outputStack, true);
            if (rest.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a)) continue;
            stack.func_190918_g(outputStack.func_190916_E());
            chest.insertItem(i, outputStack, false);
        }
        return false;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneUnboxer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneUnboxer(player.field_71071_by, this);
    }
}

