/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.inventory.container.ContainerCraneInserter;
import com.hbm.inventory.gui.GUICraneInserter;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.TileEntityCraneBase;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCraneInserter
extends TileEntityCraneBase
implements IGUIProvider {
    public TileEntityCraneInserter() {
        super(21);
    }

    @Override
    public String getName() {
        return "container.craneInserter";
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.tryFillTe();
        }
    }

    public void tryFillTe() {
        EnumFacing outputSide = this.getOutputSide();
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(outputSide));
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputSide)) {
            IItemHandler cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputSide);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                this.tryFillContainerCap(cap, i);
            }
        }
    }

    public boolean tryFillTeDirect(ItemStack stack) {
        return this.tryInsertItemCap((IItemHandler)this.inventory, stack);
    }

    public boolean tryFillContainerCap(IItemHandler chest, int slot) {
        if (this.inventory.getStackInSlot(slot).func_190926_b()) {
            return false;
        }
        return this.tryInsertItemCap(chest, this.inventory.getStackInSlot(slot));
    }

    public boolean tryInsertItemCap(IItemHandler chest, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack outputStack = stack.func_77946_l();
            if (outputStack.func_190926_b() || outputStack.func_190916_E() == 0) {
                return true;
            }
            ItemStack chestItem = chest.getStackInSlot(i).func_77946_l();
            if (!chestItem.func_190926_b() && (!Library.areItemStacksCompatible(outputStack, chestItem, false) || chestItem.func_190916_E() >= chestItem.func_77976_d())) continue;
            int fillAmount = Math.min(chestItem.func_77976_d() - chestItem.func_190916_E(), outputStack.func_190916_E());
            outputStack.func_190920_e(fillAmount);
            ItemStack rest = chest.insertItem(i, outputStack, true);
            if (rest.func_190916_E() >= outputStack.func_190916_E()) continue;
            stack.func_190918_g(outputStack.func_190916_E() - rest.func_190916_E());
            chest.insertItem(i, outputStack, false);
        }
        return false;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneInserter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneInserter(player.field_71071_by, this);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    }
}

