/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityShrapnel;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.HeatRecipes;
import com.hbm.inventory.container.ContainerWatz;
import com.hbm.inventory.gui.GUIWatz;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemWatzPellet;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.main.AdvancementManager;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Compat;
import com.hbm.util.EnumUtil;
import com.hbm.util.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class TileEntityWatz
extends TileEntityMachineBase
implements ITickable,
IFluidHandler,
ITankPacketAcceptor,
IControlReceiver,
IGUIProvider {
    public FluidTank[] tanks;
    public int heat;
    public double fluxLastBase;
    public double fluxLastReaction;
    public double fluxDisplay;
    public boolean isOn;
    public boolean isLocked = false;
    public ItemStack[] locks = new ItemStack[this.inventory.getSlots()];
    AxisAlignedBB bb = null;

    public TileEntityWatz() {
        super(24, 1);
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(64000);
        this.tanks[1] = new FluidTank(64000);
        this.tanks[2] = new FluidTank(64000);
    }

    @Override
    public String getName() {
        return "container.watz";
    }

    /*
     * WARNING - void declaration
     */
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.updateLock()) {
            void var6_14;
            int i;
            TileEntity tile;
            boolean turnedOn = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 3, 0)).func_177230_c() == ModBlocks.watz_pump && this.field_145850_b.func_175651_c(this.field_174879_c.func_177982_a(0, 5, 0), EnumFacing.DOWN) > 0;
            ArrayList<TileEntityWatz> segments = new ArrayList<TileEntityWatz>();
            segments.add(this);
            for (int y = this.field_174879_c.func_177956_o() - 3; y >= 0 && (tile = Compat.getTileStandard(this.field_145850_b, this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p())) instanceof TileEntityWatz; y -= 3) {
                TileEntityWatz w = (TileEntityWatz)tile;
                segments.add(w);
            }
            int size = segments.size();
            FluidTank[] sharedTanks = new FluidTank[]{new FluidTank(64000 * size), new FluidTank(64000 * size), new FluidTank(64000 * size)};
            for (TileEntityWatz tileEntityWatz : segments) {
                tileEntityWatz.setupCoolant(ModForgeFluids.COOLANT);
                for (int i2 = 0; i2 < 3; ++i2) {
                    sharedTanks[i2].fill(tileEntityWatz.tanks[i2].drain(64000, true), true);
                }
            }
            for (i = size - 1; i >= 0; --i) {
                TileEntityWatz tileEntityWatz = (TileEntityWatz)segments.get(i);
                tileEntityWatz.updateCoolant(sharedTanks);
            }
            this.updateReaction(null, sharedTanks, turnedOn);
            for (i = 1; i < size; ++i) {
                TileEntityWatz tileEntityWatz = (TileEntityWatz)segments.get(i);
                TileEntityWatz above = (TileEntityWatz)segments.get(i - 1);
                tileEntityWatz.updateReaction(above, sharedTanks, turnedOn);
            }
            boolean isTooFull = sharedTanks[2].getFluidAmount() == sharedTanks[2].getCapacity();
            for (TileEntityWatz segment3 : segments) {
                segment3.isOn = turnedOn;
                segment3.sendPacket(sharedTanks);
                segment3.heat = (int)((double)segment3.heat * 0.99);
            }
            int n = size - 1;
            while (var6_14 >= 0) {
                TileEntityWatz segment4 = (TileEntityWatz)segments.get((int)var6_14);
                for (int j = 0; j < 3; ++j) {
                    if (sharedTanks[j].getFluidAmount() <= 0) continue;
                    segment4.tanks[j].fill(sharedTanks[j].drain(segment4.tanks[j].getCapacity() - segment4.tanks[j].getFluidAmount(), true), true);
                }
                --var6_14;
            }
            ((TileEntityWatz)segments.get(size - 1)).sendOutBottom();
            if (isTooFull) {
                void var6_16;
                int n2 = -3;
                while (var6_16 <= 3) {
                    for (int y = 3; y < 6; ++y) {
                        for (int z = -3; z <= 3; ++z) {
                            this.field_145850_b.func_175698_g(this.field_174879_c.func_177982_a((int)var6_16, y, z));
                        }
                    }
                    ++var6_16;
                }
                for (TileEntityWatz segment5 : segments) {
                    segment5.disassemble();
                }
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c.func_177982_a(0, 1, 0), 1000.0f, 2.1474836E9f);
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p() + 0.5, HBMSoundHandler.rbmk_explosion, SoundCategory.BLOCKS, 50.0f, 1.0f);
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74778_a("type", "rbmkmush");
                nBTTagCompound.func_74776_a("scale", 5.0f);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nBTTagCompound, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 2, (double)this.field_174879_c.func_177952_p() + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 250.0));
                MainRegistry.proxy.effectNT(nBTTagCompound);
                List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).func_72314_b(50.0, 10.0, 50.0));
                for (EntityPlayer player : players) {
                    AdvancementManager.grantAchievement(player, AdvancementManager.progress_watz_boom);
                }
            }
        }
    }

    public void setupCoolant(Fluid coolant) {
        if (this.tanks[0].getFluid() == null || this.tanks[0].getFluid().getFluid() != coolant) {
            this.tanks[0].setFluid(new FluidStack(coolant, 0));
        }
        if (this.tanks[1].getFluid() == null || this.tanks[1].getFluid().getFluid() != HeatRecipes.getBoilFluid(coolant)) {
            this.tanks[1].setFluid(new FluidStack(HeatRecipes.getBoilFluid(coolant), 0));
        }
    }

    public void updateCoolant(FluidTank[] tanks) {
        double coolingFactor = 0.2;
        double heatToUse = (double)this.heat * coolingFactor;
        int heatReq = HeatRecipes.getRequiredHeat(ModForgeFluids.COOLANT);
        int amountReq = HeatRecipes.getInputAmountHot(ModForgeFluids.COOLANT);
        int amountProduced = HeatRecipes.getOutputAmountHot(ModForgeFluids.COOLANT);
        int heatCycles = (int)(heatToUse / (double)heatReq);
        int coolCycles = tanks[0].getFluidAmount() / amountReq;
        int hotCycles = (tanks[1].getCapacity() - tanks[1].getFluidAmount()) / amountProduced;
        int cycles = Math.min(heatCycles, Math.min(hotCycles, coolCycles));
        if (cycles == 0) {
            return;
        }
        this.heat -= cycles * heatReq;
        tanks[0].drain(cycles * amountReq, true);
        tanks[1].fill(new FluidStack(HeatRecipes.getBoilFluid(ModForgeFluids.COOLANT), cycles * amountProduced), true);
    }

    public void updateReaction(TileEntityWatz above, FluidTank[] tanks, boolean turnedOn) {
        int i;
        if (turnedOn) {
            ArrayList<ItemStack> pellets = new ArrayList<ItemStack>();
            for (int i2 = 0; i2 < 24; ++i2) {
                ItemStack stack = this.inventory.getStackInSlot(i2);
                if (stack.func_190926_b() || stack.func_77973_b() != ModItems.watz_pellet) continue;
                pellets.add(stack);
            }
            double baseFlux = 0.0;
            for (ItemStack stack : pellets) {
                ItemWatzPellet.EnumWatzType type = (ItemWatzPellet.EnumWatzType)((Object)EnumUtil.grabEnumSafely(ItemWatzPellet.EnumWatzType.class, stack.func_77952_i()));
                baseFlux += type.passive;
            }
            double inputFlux = baseFlux + this.fluxLastReaction;
            double addedFlux = 0.0;
            double addedHeat = 0.0;
            for (ItemStack stack : pellets) {
                ItemWatzPellet.EnumWatzType type = (ItemWatzPellet.EnumWatzType)((Object)EnumUtil.grabEnumSafely(ItemWatzPellet.EnumWatzType.class, stack.func_77952_i()));
                Function burnFunc = type.burnFunc;
                Function heatDiv = type.heatDiv;
                Function absorbFunc = type.absorbFunc;
                if (burnFunc != null) {
                    double div = heatDiv != null ? heatDiv.effonix(this.heat) : 1.0;
                    double burn = burnFunc.effonix(inputFlux) / div;
                    addedFlux += burn;
                    addedHeat += type.heatEmission * burn;
                    ItemWatzPellet.setYield(stack, ItemWatzPellet.getYield(stack) - burn);
                    tanks[2].fill(new FluidStack(ModForgeFluids.MUD_FLUID, (int)Math.round(type.mudContent * burn)), true);
                }
                if (absorbFunc == null) continue;
                double absorb = absorbFunc.effonix(inputFlux);
                addedHeat += absorb;
                ItemWatzPellet.setYield(stack, ItemWatzPellet.getYield(stack) - absorb);
                tanks[2].fill(new FluidStack(ModForgeFluids.MUD_FLUID, (int)Math.round(type.mudContent * absorb)), true);
            }
            this.heat += (int)addedHeat;
            this.fluxLastBase = baseFlux;
            this.fluxLastReaction = addedFlux;
        } else {
            this.fluxLastBase = 0.0;
            this.fluxLastReaction = 0.0;
        }
        for (i = 0; i < 24; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.watz_pellet || !(ItemWatzPellet.getEnrichment(stack) <= 0.0)) continue;
            this.inventory.setStackInSlot(i, new ItemStack(ModItems.watz_pellet_depleted, 1, stack.func_77952_i()));
        }
        if (above != null) {
            for (i = 0; i < 24; ++i) {
                ItemStack stackBottom = this.inventory.getStackInSlot(i);
                ItemStack stackTop = above.inventory.getStackInSlot(i);
                if (stackBottom.func_190926_b() && !stackTop.func_190926_b()) {
                    this.inventory.setStackInSlot(i, stackTop.func_77946_l());
                    above.inventory.getStackInSlot(i).func_190918_g(stackTop.func_190916_E());
                }
                if (stackBottom.func_190926_b() || stackBottom.func_77973_b() != ModItems.watz_pellet || stackTop.func_190926_b() || stackTop.func_77973_b() != ModItems.watz_pellet_depleted) continue;
                ItemStack buf = stackTop.func_77946_l();
                above.inventory.setStackInSlot(i, stackBottom.func_77946_l());
                this.inventory.setStackInSlot(i, buf);
            }
        }
    }

    public void sendPacket(FluidTank[] sharedTanks) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("heat", this.heat);
        data.func_74757_a("isOn", this.isOn);
        data.func_74757_a("lock", this.isLocked);
        data.func_74780_a("flux", this.fluxLastReaction + this.fluxLastBase);
        data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(sharedTanks));
        this.networkPack(data, 25);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.heat = nbt.func_74762_e("heat");
        this.isOn = nbt.func_74767_n("isOn");
        this.isLocked = nbt.func_74767_n("lock");
        this.fluxDisplay = nbt.func_74769_h("flux");
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
    }

    public boolean updateLock() {
        return Compat.getTileStandard(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 3, this.field_174879_c.func_177952_p()) instanceof TileEntityWatz;
    }

    protected void sendOutBottom() {
        for (DirPos pos : this.getSendingPos()) {
            if (this.tanks[1].getFluidAmount() > 0) {
                FFUtils.fillFluid(this, this.tanks[1], this.field_145850_b, pos.getPos(), this.tanks[1].getCapacity() >> 1);
            }
            if (this.tanks[2].getFluidAmount() <= 0) continue;
            FFUtils.fillFluid(this, this.tanks[2], this.field_145850_b, pos.getPos(), this.tanks[2].getCapacity() >> 1);
        }
    }

    protected DirPos[] getSendingPos() {
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), ForgeDirection.DOWN), new DirPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), ForgeDirection.DOWN), new DirPos(this.field_174879_c.func_177958_n() - 2, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), ForgeDirection.DOWN), new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + 2, ForgeDirection.DOWN), new DirPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() - 2, ForgeDirection.DOWN)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("locks", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.inventory.getSlots()) continue;
            this.locks[b0] = new ItemStack(nbt1);
        }
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        this.heat = nbt.func_74762_e("heat");
        this.fluxLastBase = nbt.func_74769_h("lastFluxB");
        this.fluxLastReaction = nbt.func_74769_h("lastFluxR");
        this.isLocked = nbt.func_74767_n("isLocked");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.locks.length; ++i) {
            if (this.locks[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.locks[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("locks", (NBTBase)list);
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74780_a("lastFluxB", this.fluxLastBase);
        nbt.func_74780_a("lastFluxR", this.fluxLastReaction);
        nbt.func_74757_a("isLocked", this.isLocked);
        return super.func_189515_b(nbt);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.isUseableByPlayer(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("lock")) {
            if (this.isLocked) {
                this.locks = new ItemStack[this.inventory.getSlots()];
            } else {
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    this.locks[i] = this.inventory.getStackInSlot(i);
                }
            }
            this.isLocked = !this.isLocked;
            this.func_70296_d();
        }
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (stack.func_77973_b() != ModItems.watz_pellet) {
            return false;
        }
        if (!this.isLocked) {
            return true;
        }
        return this.locks[i] != null && this.locks[i].func_77973_b() == stack.func_77973_b() && this.locks[i].func_77952_i() == stack.func_77952_i();
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    }

    @Override
    public boolean canExtractItem(int i, ItemStack stack, int j) {
        return stack.func_77973_b() != ModItems.watz_pellet;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 3), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 3), (double)(this.field_174879_c.func_177958_n() + 4), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    private void disassemble() {
        int count = 20;
        Random rand = this.field_145850_b.field_73012_v;
        for (int i = 0; i < count * 5; ++i) {
            EntityShrapnel shrapnel = new EntityShrapnel(this.field_145850_b);
            shrapnel.field_70165_t = (double)this.field_174879_c.func_177958_n() + 0.5;
            shrapnel.field_70163_u = this.field_174879_c.func_177956_o() + 3;
            shrapnel.field_70161_v = (double)this.field_174879_c.func_177952_p() + 0.5;
            shrapnel.field_70181_x = ((double)rand.nextFloat() * 0.5 + 0.5) * (double)(1.0f + (float)count / (15.0f + (float)rand.nextInt(21))) + (double)(rand.nextFloat() / 50.0f * (float)count);
            shrapnel.field_70159_w = rand.nextGaussian() * 1.0 * (double)(1.0f + (float)count / 100.0f);
            shrapnel.field_70179_y = rand.nextGaussian() * 1.0 * (double)(1.0f + (float)count / 100.0f);
            shrapnel.setWatz(true);
            this.field_145850_b.func_72838_d((Entity)shrapnel);
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.mud_block.func_176223_P());
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177984_a(), ModBlocks.mud_block.func_176223_P());
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177981_b(2), ModBlocks.mud_block.func_176223_P());
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 1, 0);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 2, 0);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 0, 1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 0, 2);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, -1, 0);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, -2, 0);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 0, -1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 0, -2);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 1, 1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, 1, -1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, -1, 1);
        this.setBrokenColumn(0, ModBlocks.watz_element, 0, -1, -1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, 2, 1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, 2, -1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, 1, 2);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, -1, 2);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, -2, 1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, -2, -1);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, 1, -2);
        this.setBrokenColumn(0, ModBlocks.watz_cooler, 0, -1, -2);
        for (int j = -1; j < 2; ++j) {
            this.setBrokenColumn(1, ModBlocks.watz_casing, 1, 3, j);
            this.setBrokenColumn(1, ModBlocks.watz_casing, 1, j, 3);
            this.setBrokenColumn(1, ModBlocks.watz_casing, 1, -3, j);
            this.setBrokenColumn(1, ModBlocks.watz_casing, 1, j, -3);
        }
        this.setBrokenColumn(1, ModBlocks.watz_casing, 1, 2, 2);
        this.setBrokenColumn(1, ModBlocks.watz_casing, 1, 2, -2);
        this.setBrokenColumn(1, ModBlocks.watz_casing, 1, -2, 2);
        this.setBrokenColumn(1, ModBlocks.watz_casing, 1, -2, -2);
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).func_72321_a(50.0, 50.0, 50.0));
    }

    private void setBrokenColumn(int minHeight, Block b, int meta, int x, int z) {
        int height = minHeight + this.field_145850_b.field_73012_v.nextInt(3 - minHeight);
        for (int i = 0; i < 3; ++i) {
            if (i <= height) {
                this.field_145850_b.func_180501_a(this.field_174879_c.func_177982_a(x, i, z), b.func_176223_P(), 3);
                continue;
            }
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(x, i, z), ModBlocks.mud_block.func_176223_P());
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerWatz(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIWatz(player.field_71071_by, this);
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 3) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
        this.tanks[2].readFromNBT(tags[2]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.tanks[0].getFluid() == null || resource.isFluidEqual(this.tanks[0].getFluid())) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (resource.getFluid() == ModForgeFluids.HOTCOOLANT) {
            return this.tanks[1].drain(resource.amount, doDrain);
        }
        if (resource.getFluid() == ModForgeFluids.MUD_FLUID) {
            return this.tanks[2].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks[1].getFluidAmount() > 0) {
            return this.tanks[1].drain(maxDrain, doDrain);
        }
        if (this.tanks[2].getFluidAmount() > 0) {
            return this.tanks[2].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

