/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.SolderingRecipes;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMachineSolderingStation;
import com.hbm.inventory.gui.GUIMachineSolderingStation;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineSolderingStation
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IFluidHandler,
IEnergyUser,
ITankPacketAcceptor,
IControlReceiver {
    public boolean wasOn;
    public long power;
    public long maxPower = 2000L;
    public long consumption;
    public boolean collisionPrevention = false;
    public int progress;
    public int processTime = 1;
    public FluidTank tank;
    public ItemStack display;
    public UpgradeManager upgradeManager = new UpgradeManager();
    private SolderingRecipes.SolderingRecipe recipe;
    AxisAlignedBB bb = null;

    public TileEntityMachineSolderingStation() {
        super(10);
        this.tank = new FluidTank(8000);
    }

    @Override
    public String getName() {
        return "container.machineSolderingStation";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            long intendedMaxPower;
            this.wasOn = false;
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 7, this.getPower(), this.getMaxPower());
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, pos.getPos(), pos.getDir());
                    if (this.tank.getFluidAmount() <= 0) continue;
                    FFUtils.fillFluid(this, this.tank, this.field_145850_b, pos.getPos(), this.tank.getCapacity() >> 1);
                }
            }
            this.recipe = SolderingRecipes.getRecipe(new ItemStack[]{this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.inventory.getStackInSlot(2), this.inventory.getStackInSlot(3), this.inventory.getStackInSlot(4), this.inventory.getStackInSlot(5)});
            this.upgradeManager.eval((IItemHandler)this.inventory, 8, 9);
            int redLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int blueLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            if (this.recipe != null) {
                this.display = this.recipe.output.func_77946_l();
                this.processTime = this.recipe.duration - this.recipe.duration * redLevel / 6 + this.recipe.duration * blueLevel / 3;
                this.consumption = this.recipe.consumption + this.recipe.consumption * (long)redLevel - this.recipe.consumption * (long)blueLevel / 6L;
                intendedMaxPower = this.recipe.consumption * 20L;
                if (this.canProcess(this.recipe)) {
                    this.wasOn = true;
                    ++this.progress;
                    this.power -= this.consumption;
                    if (this.progress >= this.processTime) {
                        this.progress = 0;
                        this.consumeItems(this.recipe);
                        if (this.inventory.getStackInSlot(6).func_190926_b()) {
                            this.inventory.setStackInSlot(6, this.recipe.output.func_77946_l());
                        } else {
                            this.inventory.getStackInSlot(6).func_190917_f(this.recipe.output.func_190916_E());
                        }
                        this.func_70296_d();
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.display = null;
                this.progress = 0;
                this.consumption = 100L;
                intendedMaxPower = 2000L;
            }
            this.maxPower = Math.max(intendedMaxPower, this.power);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("maxPower", this.maxPower);
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("processTime", this.processTime);
            data.func_74757_a("colPrev", this.collisionPrevention);
            if (this.display != null) {
                data.func_74768_a("itemId", Item.func_150891_b((Item)this.display.func_77973_b()));
                data.func_74768_a("itemMeta", this.display.func_77952_i());
            } else {
                data.func_74768_a("itemId", -1);
            }
            data.func_74757_a("wasOn", this.wasOn);
            this.tank.writeToNBT(data);
            this.networkPack(data, 25);
        } else if (this.wasOn && this.field_145850_b.func_82737_E() % 20L == 0L) {
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "tau");
            data.func_74774_a("count", (byte)3);
            data.func_74780_a("posX", (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * 0.5 + (double)rot.offsetX * 0.5);
            data.func_74780_a("posY", (double)this.field_174879_c.func_177956_o() + 1.125);
            data.func_74780_a("posZ", (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * 0.5 + (double)rot.offsetZ * 0.5);
            MainRegistry.proxy.effectNT(data);
        }
    }

    public boolean canProcess(SolderingRecipes.SolderingRecipe recipe) {
        if (this.power < this.consumption) {
            return false;
        }
        if (recipe.fluid != null) {
            if (this.tank.getFluid() == null) {
                return false;
            }
            if (this.tank.getFluid().getFluid() != recipe.fluid.getFluid()) {
                return false;
            }
            if (this.tank.getFluidAmount() < recipe.fluid.amount) {
                return false;
            }
        }
        if (this.collisionPrevention && recipe.fluid == null && this.tank.getFluidAmount() > 0) {
            return false;
        }
        if (!this.inventory.getStackInSlot(6).func_190926_b()) {
            ItemStack slot6 = this.inventory.getStackInSlot(6);
            if (slot6.func_77973_b() != recipe.output.func_77973_b()) {
                return false;
            }
            if (slot6.func_77952_i() != recipe.output.func_77952_i()) {
                return false;
            }
            return slot6.func_190916_E() + recipe.output.func_190916_E() <= slot6.func_77976_d();
        }
        return true;
    }

    public void consumeItems(SolderingRecipes.SolderingRecipe recipe) {
        ItemStack stack;
        int i;
        block0: for (RecipesCommon.AStack aStack : recipe.toppings) {
            for (i = 0; i < 3; ++i) {
                stack = this.inventory.getStackInSlot(i);
                if (!aStack.matchesRecipe(stack, true) || stack.func_190916_E() < aStack.count()) continue;
                stack.func_190918_g(aStack.count());
                if (stack.func_190916_E() != 0) continue block0;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                continue block0;
            }
        }
        block2: for (RecipesCommon.AStack aStack : recipe.pcb) {
            for (i = 3; i < 5; ++i) {
                stack = this.inventory.getStackInSlot(i);
                if (!aStack.matchesRecipe(stack, true) || stack.func_190916_E() < aStack.count()) continue;
                stack.func_190918_g(aStack.count());
                if (stack.func_190916_E() != 0) continue block2;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                continue block2;
            }
        }
        block4: for (RecipesCommon.AStack aStack : recipe.solder) {
            for (i = 5; i < 6; ++i) {
                stack = this.inventory.getStackInSlot(i);
                if (!aStack.matchesRecipe(stack, true) || stack.func_190916_E() < aStack.count()) continue;
                stack.func_190918_g(aStack.count());
                if (stack.func_190916_E() != 0) continue block4;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                continue block4;
            }
        }
        if (recipe.fluid != null) {
            this.tank.drain(recipe.fluid.amount, true);
        }
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        block6: {
            block7: {
                block5: {
                    if (slot >= 3) break block5;
                    for (int i = 0; i < 3; ++i) {
                        if (i == slot || !this.inventory.getStackInSlot(i).func_77969_a(stack)) continue;
                        return false;
                    }
                    for (RecipesCommon.AStack t : SolderingRecipes.toppings) {
                        if (!t.matchesRecipe(stack, true)) continue;
                        return true;
                    }
                    break block6;
                }
                if (slot >= 5) break block7;
                for (int i = 3; i < 5; ++i) {
                    if (i == slot || !this.inventory.getStackInSlot(i).func_77969_a(stack)) continue;
                    return false;
                }
                for (RecipesCommon.AStack t : SolderingRecipes.pcb) {
                    if (!t.matchesRecipe(stack, true)) continue;
                    return true;
                }
                break block6;
            }
            if (slot >= 6) break block6;
            for (RecipesCommon.AStack t : SolderingRecipes.solder) {
                if (!t.matchesRecipe(stack, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return i == 6;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5, 6};
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_174879_c.func_177982_a(dir.offsetX, 0, dir.offsetZ), dir), new DirPos(this.field_174879_c.func_177982_a(dir.offsetX + rot.offsetX, 0, dir.offsetZ + rot.offsetZ), dir), new DirPos(this.field_174879_c.func_177982_a(-dir.offsetX * 2, 0, -dir.offsetZ * 2), dir.getOpposite()), new DirPos(this.field_174879_c.func_177982_a(-dir.offsetX * 2 + rot.offsetX, 0, -dir.offsetZ * 2 + rot.offsetZ), dir.getOpposite()), new DirPos(this.field_174879_c.func_177982_a(-rot.offsetX, 0, -rot.offsetZ), rot.getOpposite()), new DirPos(this.field_174879_c.func_177982_a(-dir.offsetX - rot.offsetX, 0, -dir.offsetZ - rot.offsetZ), rot.getOpposite()), new DirPos(this.field_174879_c.func_177982_a(rot.offsetX * 2, 0, rot.offsetZ * 2), rot), new DirPos(this.field_174879_c.func_177982_a(-dir.offsetX + rot.offsetX * 2, 0, -dir.offsetZ + rot.offsetZ * 2), rot)};
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.wasOn = nbt.func_74767_n("wasOn");
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.progress = nbt.func_74762_e("progress");
        this.processTime = nbt.func_74762_e("processTime");
        this.collisionPrevention = nbt.func_74767_n("colPrev");
        this.display = nbt.func_74762_e("itemId") > 0 ? new ItemStack(Item.func_150899_d((int)nbt.func_74762_e("itemId")), 1, nbt.func_74762_e("itemMeta")) : null;
        this.tank.readFromNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.progress = nbt.func_74762_e("progress");
        this.processTime = nbt.func_74762_e("processTime");
        this.collisionPrevention = nbt.func_74767_n("colPrev");
        this.tank.readFromNBT(nbt);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("processTime", this.processTime);
        nbt.func_74757_a("colPrev", this.collisionPrevention);
        this.tank.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    @Override
    public long getPower() {
        return Math.max(Math.min(this.power, this.maxPower), 0L);
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineSolderingStation(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineSolderingStation(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.amount > 0 && (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == resource.getFluid()) && SolderingRecipes.fluids.contains(resource.getFluid())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.isUseableByPlayer(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        this.collisionPrevention = !this.collisionPrevention;
        this.func_70296_d();
    }
}

