/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.interfaces.Untested;
import com.hbm.inventory.ShredderRecipes;
import com.hbm.items.machine.ItemBlades;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineShredder
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public long power;
    public int progress;
    public int soundCycle = 0;
    public static final long maxPower = 10000L;
    public static final int processingSpeed = 60;
    private static final int[] slots_top = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] slots_bottom = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    private static final int[] slots_side = new int[]{27, 28, 29};

    public TileEntityMachineShredder() {
        super(30);
    }

    @Override
    public String getName() {
        return "container.machineShredder";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int i = e.ordinal();
        return i == 0 ? slots_bottom : (i == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack itemStack, int amount) {
        return this.isItemValidForSlot(slot, itemStack);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        if (i < 9) {
            return true;
        }
        if (i == 29 && stack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        return (i == 27 || i == 28) && stack.func_77973_b() instanceof ItemBlades;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        if (slot >= 9 && slot <= 26) {
            return true;
        }
        if (slot >= 27 && slot <= 29) {
            return itemStack.func_77952_i() == itemStack.func_77958_k() && itemStack.func_77958_k() > 0;
        }
        return false;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.progress * i / 60;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            boolean trigger;
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            if (this.hasPower() && this.canProcess()) {
                ++this.progress;
                this.power -= 5L;
                if (this.progress == 60) {
                    for (int i = 27; i <= 28; ++i) {
                        if (this.inventory.getStackInSlot(i).func_77958_k() <= 0) continue;
                        this.inventory.getStackInSlot(i).func_77964_b(this.inventory.getStackInSlot(i).func_77952_i() + 1);
                    }
                    this.progress = 0;
                    this.processItem();
                    flag1 = true;
                }
                if (this.soundCycle == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0f, 0.75f);
                }
                ++this.soundCycle;
                if (this.soundCycle >= 50) {
                    this.soundCycle = 0;
                }
            } else {
                this.progress = 0;
            }
            boolean bl = trigger = !this.hasPower() || !this.canProcess() || this.progress != 0;
            if (trigger) {
                flag1 = true;
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 29, this.power, 10000L);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 15.0));
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public void processItem() {
        for (int inpSlot = 0; inpSlot < 9; ++inpSlot) {
            int outSlot;
            if (this.inventory.getStackInSlot(inpSlot).func_190926_b() || !this.hasSpace(this.inventory.getStackInSlot(inpSlot))) continue;
            ItemStack inp = this.inventory.getStackInSlot(inpSlot);
            ItemStack outp = ShredderRecipes.getShredderResult(inp);
            boolean flag = false;
            for (outSlot = 9; outSlot < 27; ++outSlot) {
                if (this.inventory.getStackInSlot(outSlot).func_77973_b() != outp.func_77973_b() || this.inventory.getStackInSlot(outSlot).func_77952_i() != outp.func_77952_i() || this.inventory.getStackInSlot(outSlot).func_190916_E() + outp.func_190916_E() > outp.func_77976_d()) continue;
                this.inventory.getStackInSlot(outSlot).func_190917_f(outp.func_190916_E());
                this.inventory.getStackInSlot(inpSlot).func_190918_g(1);
                flag = true;
                break;
            }
            if (!flag) {
                for (outSlot = 9; outSlot < 27; ++outSlot) {
                    if (!this.inventory.getStackInSlot(outSlot).func_190926_b()) continue;
                    this.inventory.setStackInSlot(outSlot, outp.func_77946_l());
                    this.inventory.getStackInSlot(inpSlot).func_190918_g(1);
                    break;
                }
            }
            if (!this.inventory.getStackInSlot(inpSlot).func_190926_b()) continue;
            this.inventory.setStackInSlot(inpSlot, ItemStack.field_190927_a);
        }
    }

    @Untested
    public boolean canProcess() {
        if (this.getGearLeft() > 0 && this.getGearLeft() < 3 && this.getGearRight() > 0 && this.getGearRight() < 3) {
            for (int i = 0; i < 9; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b() || this.inventory.getStackInSlot(i).func_190916_E() <= 0 || !this.hasSpace(this.inventory.getStackInSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSpace(ItemStack stack) {
        ItemStack result = ShredderRecipes.getShredderResult(stack);
        if (result != null) {
            for (int i = 9; i < 27; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) {
                    return true;
                }
                if (!this.inventory.getStackInSlot(i).func_77973_b().equals(result.func_77973_b()) || this.inventory.getStackInSlot(i).func_190916_E() + result.func_190916_E() > result.func_77976_d()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 10000L;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    public int getGearLeft() {
        if (!this.inventory.getStackInSlot(27).func_190926_b() && this.inventory.getStackInSlot(27).func_77973_b() instanceof ItemBlades) {
            if (this.inventory.getStackInSlot(27).func_77958_k() == 0) {
                return 1;
            }
            if (this.inventory.getStackInSlot(27).func_77952_i() < this.inventory.getStackInSlot(27).func_77958_k() / 2) {
                return 1;
            }
            if (this.inventory.getStackInSlot(27).func_77952_i() != this.inventory.getStackInSlot(27).func_77958_k()) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public int getGearRight() {
        if (!this.inventory.getStackInSlot(28).func_190926_b() && this.inventory.getStackInSlot(28).func_77973_b() instanceof ItemBlades) {
            if (this.inventory.getStackInSlot(28).func_77958_k() == 0) {
                return 1;
            }
            if (this.inventory.getStackInSlot(28).func_77952_i() < this.inventory.getStackInSlot(28).func_77958_k() / 2) {
                return 1;
            }
            if (this.inventory.getStackInSlot(28).func_77952_i() != this.inventory.getStackInSlot(28).func_77958_k()) {
                return 2;
            }
            return 3;
        }
        return 0;
    }
}

