/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineReactor;
import com.hbm.config.MobConfig;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.handler.RadiationSystemNT;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFuelRod;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.lib.ItemStackHandlerWrapper;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.tileentity.machine.TileEntityMachineReactor;
import com.hbm.tileentity.machine.TileEntityNukeFurnace;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineReactorSmall
extends TileEntity
implements ITickable,
IFluidHandler,
ITankPacketAcceptor {
    private static final AxisAlignedBB SMALL_REACTOR_BB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 5.0, 1.0);
    public ItemStackHandler inventory;
    public int hullHeat;
    public static final int maxHullHeat = 100000;
    public int coreHeat;
    public static final int maxCoreHeat = 50000;
    public int rods;
    public static final int rodsMax = 100;
    public boolean retracting = true;
    public int age = 0;
    public FluidTank[] tanks;
    public Fluid[] tankTypes;
    public boolean needsUpdate;
    public int compression = 0;
    private double decayMod = 1.0;
    private double coreHeatMod = 1.0;
    private double hullHeatMod = 1.0;
    private double conversionMod = 1.0;
    public static HashMap<Item, Item> conversions = new HashMap();
    private String customName;
    private int detectHeat;
    private int detectHullHeat;
    private int detectRods;
    private boolean detectRetracting;
    private int detectCompression;
    private FluidTank[] detectTanks = new FluidTank[]{null, null, null};

    public TileEntityMachineReactorSmall() {
        this.inventory = new ItemStackHandler(16);
        this.tanks = new FluidTank[3];
        this.tankTypes = new Fluid[3];
        this.tanks[0] = new FluidTank(32000);
        this.tankTypes[0] = FluidRegistry.WATER;
        this.tanks[1] = new FluidTank(16000);
        this.tankTypes[1] = ModForgeFluids.COOLANT;
        this.tanks[2] = new FluidTank(8000);
        this.tankTypes[2] = ModForgeFluids.STEAM;
        this.needsUpdate = true;
    }

    public static void setupConversions() {
        if (!conversions.isEmpty()) {
            return;
        }
        conversions.put(ModItems.rod_uranium_fuel, ModItems.rod_uranium_fuel_depleted);
        conversions.put(ModItems.rod_thorium_fuel, ModItems.rod_thorium_fuel_depleted);
        conversions.put(ModItems.rod_plutonium_fuel, ModItems.rod_plutonium_fuel_depleted);
        conversions.put(ModItems.rod_mox_fuel, ModItems.rod_mox_fuel_depleted);
        conversions.put(ModItems.rod_schrabidium, ModItems.rod_schrabidium_fuel_depleted);
        conversions.put(ModItems.rod_dual_uranium_fuel, ModItems.rod_dual_uranium_fuel_depleted);
        conversions.put(ModItems.rod_dual_thorium_fuel, ModItems.rod_dual_thorium_fuel_depleted);
        conversions.put(ModItems.rod_dual_plutonium_fuel, ModItems.rod_dual_plutonium_fuel_depleted);
        conversions.put(ModItems.rod_dual_mox_fuel, ModItems.rod_dual_mox_fuel_depleted);
        conversions.put(ModItems.rod_dual_schrabidium_fuel, ModItems.rod_dual_schrabidium_fuel_depleted);
        conversions.put(ModItems.rod_quad_uranium_fuel, ModItems.rod_quad_uranium_fuel_depleted);
        conversions.put(ModItems.rod_quad_thorium_fuel, ModItems.rod_quad_thorium_fuel_depleted);
        conversions.put(ModItems.rod_quad_plutonium_fuel, ModItems.rod_quad_plutonium_fuel_depleted);
        conversions.put(ModItems.rod_quad_mox_fuel, ModItems.rod_quad_mox_fuel_depleted);
        conversions.put(ModItems.rod_quad_schrabidium_fuel, ModItems.rod_quad_schrabidium_fuel_depleted);
    }

    public boolean canExtractItem(int slot, ItemStack stack) {
        if (slot == 13 || slot == 15) {
            return true;
        }
        if (slot == 12 || slot == 14) {
            return false;
        }
        if (!stack.func_190926_b()) {
            return !conversions.containsKey(stack.func_77973_b());
        }
        return true;
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.reactorSmall";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void compress(int level) {
        if (level == this.compression) {
            return;
        }
        if (level >= 0 && level < 3) {
            int newAmount;
            if (this.compression == 0) {
                if (level == 1) {
                    this.tankTypes[2] = ModForgeFluids.HOTSTEAM;
                    newAmount = (int)((double)this.tanks[2].getFluidAmount() / 10.0);
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
                if (level == 2) {
                    this.tankTypes[2] = ModForgeFluids.SUPERHOTSTEAM;
                    newAmount = (int)((double)this.tanks[2].getFluidAmount() / 100.0);
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
            }
            if (this.compression == 1) {
                if (level == 0) {
                    this.tankTypes[2] = ModForgeFluids.STEAM;
                    newAmount = this.tanks[2].getFluidAmount() * 10;
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
                if (level == 2) {
                    this.tankTypes[2] = ModForgeFluids.SUPERHOTSTEAM;
                    newAmount = (int)((double)this.tanks[2].getFluidAmount() / 10.0);
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
            }
            if (this.compression == 2) {
                if (level == 0) {
                    this.tankTypes[2] = ModForgeFluids.STEAM;
                    newAmount = this.tanks[2].getFluidAmount() * 100;
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
                if (level == 1) {
                    this.tankTypes[2] = ModForgeFluids.HOTSTEAM;
                    newAmount = (int)((double)this.tanks[2].getFluidAmount() * 10.0);
                    this.tanks[2].drain(this.tanks[2].getCapacity(), true);
                    this.tanks[2].fill(new FluidStack(this.tankTypes[2], newAmount), true);
                }
            }
            this.compression = level;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), new FluidTank[]{this.tanks[0], this.tanks[1], this.tanks[2]}), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[2]);
            }
            if (this.inputValidForTank(0, 12)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[0], 12, 13);
            }
            if (this.inputValidForTank(1, 14)) {
                FFUtils.fillFromFluidContainer((IItemHandlerModifiable)this.inventory, this.tanks[1], 14, 15);
            }
            if (this.retracting && this.rods > 0) {
                if (this.rods == 100) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.reactorStart, SoundCategory.BLOCKS, 1.0f, 0.75f);
                }
                --this.rods;
                if (this.rods == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.reactorStop, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (!this.retracting && this.rods < 100) {
                if (this.rods == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.reactorStart, SoundCategory.BLOCKS, 1.0f, 0.75f);
                }
                ++this.rods;
                if (this.rods == 100) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.reactorStop, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            if (this.rods >= 100) {
                for (int i = 0; i < 12; ++i) {
                    if (!(this.inventory.getStackInSlot(i).func_77973_b() instanceof ItemFuelRod)) continue;
                    this.decay(i);
                }
            }
            this.coreHeatMod = 1.0;
            this.hullHeatMod = 1.0;
            this.conversionMod = 1.0;
            this.decayMod = 1.0;
            this.getInteractions();
            if (this.coreHeat > 0 && this.tanks[1].getFluidAmount() > 0 && this.hullHeat < 100000) {
                this.hullHeat = (int)((double)this.hullHeat + (double)this.coreHeat * 0.175 * this.hullHeatMod);
                this.coreHeat = (int)((double)this.coreHeat - (double)this.coreHeat * 0.1);
                this.tanks[1].drain(10, true);
            }
            if (this.hullHeat > 100000) {
                this.hullHeat = 100000;
            }
            if (this.hullHeat > 0 && this.tanks[0].getFluidAmount() > 0) {
                this.generateSteam();
                this.hullHeat = (int)((double)this.hullHeat - (double)this.hullHeat * 0.085);
            }
            if (this.coreHeat > 50000) {
                this.explode();
            }
            if (this.rods > 0 && this.coreHeat > 0 && !this.isContained()) {
                float rad = (float)this.coreHeat / 50000.0f * 50.0f;
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, rad, rad * 4.0f);
            }
            this.detectAndSendChanges();
        }
    }

    private void explode() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
        this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 18.0f, true);
        ExplosionNukeGeneric.waste(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 35);
        this.field_145850_b.func_175656_a(this.field_174879_c, ModBlocks.block_corium_cobble.func_176223_P());
        RadiationSavedData.incrementRad(this.field_145850_b, this.field_174879_c, 1000.0f, 2000.0f);
        if (MobConfig.enableElementals) {
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5).func_72314_b(100.0, 100.0, 100.0));
            for (EntityPlayer player : players) {
                player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("radMark", true);
            }
        }
    }

    private boolean isContained() {
        boolean side1 = this.blocksRad(this.field_174879_c.func_177982_a(1, 1, 0));
        if (!side1) {
            return false;
        }
        boolean side2 = this.blocksRad(this.field_174879_c.func_177982_a(-1, 1, 0));
        if (!side2) {
            return false;
        }
        boolean side3 = this.blocksRad(this.field_174879_c.func_177982_a(0, 1, 1));
        if (!side3) {
            return false;
        }
        return this.blocksRad(this.field_174879_c.func_177982_a(0, 1, -1));
    }

    private boolean blocksRad(BlockPos pos) {
        Block b = this.field_145850_b.func_180495_p(pos).func_177230_c();
        if (RadiationSystemNT.isRadResistant(this.field_145850_b, b, pos)) {
            return true;
        }
        return b == Blocks.field_150358_i || b == Blocks.field_150355_j;
    }

    private void generateSteam() {
        double steam;
        double water = steam = (double)this.hullHeat / 100000.0 * ((double)this.tanks[2].getCapacity() / 50.0) * this.conversionMod;
        if (this.tankTypes[2] == ModForgeFluids.STEAM) {
            water /= 100.0;
        } else if (this.tankTypes[2] == ModForgeFluids.HOTSTEAM) {
            water /= 10.0;
        }
        this.tanks[0].drain((int)Math.ceil(water), true);
        this.tanks[2].fill(new FluidStack(this.tankTypes[2], (int)Math.floor(steam)), true);
    }

    private void getInteractions() {
        this.getInteractionForBlock(this.field_174879_c.func_177982_a(1, 1, 0));
        this.getInteractionForBlock(this.field_174879_c.func_177982_a(-1, 1, 0));
        this.getInteractionForBlock(this.field_174879_c.func_177982_a(0, 1, 1));
        this.getInteractionForBlock(this.field_174879_c.func_177982_a(0, 1, -1));
        TileEntity te1 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(2, 0, 0));
        TileEntity te2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(-2, 0, 0));
        TileEntity te3 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, 2));
        TileEntity te4 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 0, -2));
        boolean b1 = this.blocksRad(this.field_174879_c.func_177982_a(1, 1, 0));
        boolean b2 = this.blocksRad(this.field_174879_c.func_177982_a(-1, 1, 0));
        boolean b3 = this.blocksRad(this.field_174879_c.func_177982_a(0, 1, 1));
        boolean b4 = this.blocksRad(this.field_174879_c.func_177982_a(0, 1, -1));
        TileEntityMachineReactorSmall[] reactors = new TileEntityMachineReactorSmall[]{te1 instanceof TileEntityMachineReactorSmall && !b1 ? (TileEntityMachineReactorSmall)te1 : null, te2 instanceof TileEntityMachineReactorSmall && !b2 ? (TileEntityMachineReactorSmall)te2 : null, te3 instanceof TileEntityMachineReactorSmall && !b3 ? (TileEntityMachineReactorSmall)te3 : null, te4 instanceof TileEntityMachineReactorSmall && !b4 ? (TileEntityMachineReactorSmall)te4 : null};
        for (int i = 0; i < 4; ++i) {
            if (reactors[i] == null || reactors[i].rods < 100 || reactors[i].getRodCount() <= 0) continue;
            this.decayMod += (double)reactors[i].getRodCount() / 2.0;
        }
    }

    private void getInteractionForBlock(BlockPos pos) {
        Block b = this.field_145850_b.func_180495_p(pos).func_177230_c();
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (b == Blocks.field_150353_l || b == Blocks.field_150356_k) {
            this.hullHeatMod *= 3.0;
            this.conversionMod *= 0.5;
        } else if (b == Blocks.field_150451_bX) {
            this.conversionMod *= 1.15;
        } else if (b == ModBlocks.block_lead) {
            this.decayMod += 1.0;
        } else if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            this.tanks[0].fill(new FluidStack(this.tankTypes[0], 25), true);
        } else if (b == ModBlocks.block_niter || b == ModBlocks.block_niter_reinforced) {
            if (this.tanks[0].getFluidAmount() >= 50 && this.tanks[1].getFluidAmount() + 5 <= this.tanks[1].getCapacity()) {
                this.tanks[0].drain(50, true);
                this.tanks[1].fill(new FluidStack(this.tankTypes[1], 5), true);
            }
        } else if (b == ModBlocks.machine_reactor) {
            TileEntity tile;
            int[] pos1 = ((MachineReactor)ModBlocks.machine_reactor).findCore((IBlockAccess)this.field_145850_b, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (pos1 != null && (tile = this.field_145850_b.func_175625_s(new BlockPos(pos1[0], pos1[1], pos1[2]))) instanceof TileEntityMachineReactor) {
                TileEntityMachineReactor reactor = (TileEntityMachineReactor)tile;
                if (reactor.charge <= 1 && this.hullHeat > 0) {
                    reactor.charge = 1;
                    reactor.heat = (int)Math.floor(this.hullHeat * 4 / 100000) + 1;
                }
            }
        } else if (te instanceof TileEntityNukeFurnace) {
            TileEntityNukeFurnace reactor = (TileEntityNukeFurnace)te;
            if (reactor.dualPower < 1 && this.coreHeat > 0) {
                reactor.dualPower = 1;
            }
        } else if (b == ModBlocks.block_uranium) {
            this.coreHeatMod *= 1.05;
        } else if (b == Blocks.field_150402_ci) {
            this.hullHeatMod *= 1.1;
        } else if (b == ModBlocks.block_beryllium) {
            this.hullHeatMod *= 0.95;
            this.conversionMod *= 1.05;
        } else if (b == ModBlocks.block_schrabidium) {
            this.decayMod += 1.0;
            this.conversionMod *= 1.25;
            this.hullHeatMod *= 1.1;
        } else if (b == ModBlocks.block_waste) {
            this.decayMod += 3.0;
        }
    }

    private void decay(int id) {
        if (id > 11) {
            return;
        }
        int decay = this.getNeightbourCount(id) + 1;
        decay = (int)((double)decay * this.decayMod);
        for (int i = 0; i < decay; ++i) {
            ItemFuelRod rod = (ItemFuelRod)this.inventory.getStackInSlot(id).func_77973_b();
            this.coreHeat += (int)((double)rod.getHeatPerTick() * this.coreHeatMod);
            ItemFuelRod.setLifetime(this.inventory.getStackInSlot(id), ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(id)) + 1);
            if (ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(id)) <= ((ItemFuelRod)this.inventory.getStackInSlot(id).func_77973_b()).getMaxLifeTime()) continue;
            this.onRunOut(id);
            return;
        }
    }

    private void onRunOut(int id) {
        Item item = this.inventory.getStackInSlot(id).func_77973_b();
        Item out = conversions.get(item);
        if (out == null) {
            return;
        }
        this.inventory.setStackInSlot(id, new ItemStack(out));
    }

    private int getNeightbourCount(int id) {
        int[] neighbours = this.getNeighbouringSlots(id);
        if (neighbours == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < neighbours.length; ++i) {
            if (!this.hasFuelRod(neighbours[i])) continue;
            ++count;
        }
        return count;
    }

    private boolean hasFuelRod(int id) {
        if (id > 11) {
            return false;
        }
        if (this.inventory.getStackInSlot(id) != ItemStack.field_190927_a) {
            return this.inventory.getStackInSlot(id).func_77973_b() instanceof ItemFuelRod;
        }
        return false;
    }

    protected boolean inputValidForTank(int tank, int slot) {
        if (this.inventory.getStackInSlot(slot) != ItemStack.field_190927_a && this.tanks[tank] != null) {
            return this.isValidFluidForTank(tank, FluidUtil.getFluidContained((ItemStack)this.inventory.getStackInSlot(slot)));
        }
        return false;
    }

    private boolean isValidFluidForTank(int tank, FluidStack stack) {
        if (stack == null || this.tanks[tank] == null) {
            return false;
        }
        return stack.getFluid() == this.tankTypes[tank];
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.coreHeat = nbt.func_74762_e("heat");
        this.detectHeat = this.coreHeat + 1;
        this.hullHeat = nbt.func_74762_e("hullHeat");
        this.detectHullHeat = this.hullHeat + 1;
        this.rods = nbt.func_74762_e("rods");
        this.detectRods = this.rods + 1;
        this.retracting = nbt.func_74767_n("ret");
        boolean bl = this.detectRetracting = !this.retracting;
        if (nbt.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        }
        if (nbt.func_74764_b("tanks")) {
            FFUtils.deserializeTankArray(nbt.func_150295_c("tanks", 10), this.tanks);
        }
        this.tankTypes[0] = FluidRegistry.WATER;
        this.tankTypes[1] = ModForgeFluids.COOLANT;
        this.compression = nbt.func_74762_e("compression");
        this.detectCompression = this.compression + 1;
        if (this.compression == 0) {
            this.tankTypes[2] = ModForgeFluids.STEAM;
        } else if (this.compression == 1) {
            this.tankTypes[2] = ModForgeFluids.HOTSTEAM;
        } else if (this.compression == 2) {
            this.tankTypes[2] = ModForgeFluids.SUPERHOTSTEAM;
        }
        super.func_145839_a(nbt);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("heat", this.coreHeat);
        nbt.func_74768_a("hullHeat", this.hullHeat);
        nbt.func_74768_a("rods", this.rods);
        nbt.func_74757_a("ret", this.retracting);
        nbt.func_74768_a("compression", this.compression);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        return super.func_189515_b(nbt);
    }

    public int getCoreHeatScaled(int i) {
        return this.coreHeat * i / 50000;
    }

    public int getHullHeatScaled(int i) {
        return this.hullHeat * i / 100000;
    }

    public int getSteamScaled(int i) {
        return this.tanks[2].getFluidAmount() * i / this.tanks[2].getCapacity();
    }

    public boolean hasCoreHeat() {
        return this.coreHeat > 0;
    }

    public boolean hasHullHeat() {
        return this.hullHeat > 0;
    }

    private int[] getNeighbouringSlots(int id) {
        switch (id) {
            case 0: {
                return new int[]{1, 5};
            }
            case 1: {
                return new int[]{0, 6};
            }
            case 2: {
                return new int[]{3, 7};
            }
            case 3: {
                return new int[]{2, 4, 8};
            }
            case 4: {
                return new int[]{3, 9};
            }
            case 5: {
                return new int[]{0, 6, 10};
            }
            case 6: {
                return new int[]{1, 5, 11};
            }
            case 7: {
                return new int[]{2, 8};
            }
            case 8: {
                return new int[]{3, 7, 9};
            }
            case 9: {
                return new int[]{4, 8};
            }
            case 10: {
                return new int[]{5, 11};
            }
            case 11: {
                return new int[]{6, 10};
            }
        }
        return null;
    }

    public int getFuelPercent() {
        if (this.getRodCount() == 0) {
            return 0;
        }
        int rodMax = 0;
        int rod = 0;
        for (int i = 0; i < 12; ++i) {
            if (this.inventory.getStackInSlot(i) == ItemStack.field_190927_a || !(this.inventory.getStackInSlot(i).func_77973_b() instanceof ItemFuelRod)) continue;
            rodMax += ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime();
            rod += ((ItemFuelRod)this.inventory.getStackInSlot(i).func_77973_b()).getMaxLifeTime() - ItemFuelRod.getLifeTime(this.inventory.getStackInSlot(i));
        }
        if (rodMax == 0) {
            return 0;
        }
        return rod * 100 / rodMax;
    }

    public int getRodCount() {
        int count = 0;
        for (int i = 0; i < 12; ++i) {
            if (this.inventory.getStackInSlot(i) == ItemStack.field_190927_a || !(this.inventory.getStackInSlot(i).func_77973_b() instanceof ItemFuelRod)) continue;
            ++count;
        }
        return count;
    }

    public void fillFluidInit(FluidTank tank) {
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177976_e(), 4000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177974_f(), 4000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177978_c(), 4000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177968_d(), 4000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(-1, 2, 0), 4000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(1, 2, 0), 4000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 2, -1), 4000) || this.needsUpdate;
        this.needsUpdate = FFUtils.fillFluid(this, tank, this.field_145850_b, this.field_174879_c.func_177982_a(0, 2, 1), 4000) || this.needsUpdate;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0], this.tanks[2].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == this.tankTypes[0]) {
            return this.tanks[0].fill(resource, doFill);
        }
        if (resource.getFluid() == this.tankTypes[1]) {
            return this.tanks[1].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.tankTypes[2]) {
            return this.tanks[2].drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.tanks[2].getFluidAmount() > 0) {
            return this.tanks[2].drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 3) {
            return;
        }
        this.tanks[0].readFromNBT(tags[0]);
        this.tanks[1].readFromNBT(tags[1]);
        this.tanks[2].readFromNBT(tags[2]);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return SMALL_REACTOR_BB.func_186670_a(this.field_174879_c);
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public boolean isItemValid(int i, ItemStack itemStack) {
        if ((i == 0 || i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8 || i == 9 || i == 10 || i == 11) && itemStack.func_77973_b() instanceof ItemFuelRod) {
            return true;
        }
        if (i == 12 && FFUtils.containsFluid(itemStack, FluidRegistry.WATER)) {
            return true;
        }
        if (i == 14) {
            return FFUtils.containsFluid(itemStack, ModForgeFluids.COOLANT);
        }
        return false;
    }

    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new ItemStackHandlerWrapper(this.inventory){

                @Override
                @NotNull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (TileEntityMachineReactorSmall.this.canExtractItem(slot, TileEntityMachineReactorSmall.this.inventory.getStackInSlot(slot))) {
                        return super.extractItem(slot, amount, simulate);
                    }
                    return ItemStack.field_190927_a;
                }

                @Override
                @NotNull
                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    if (this.isItemValid(slot, stack)) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }
            });
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (this.detectHeat != this.coreHeat) {
            mark = true;
            this.detectHeat = this.coreHeat;
        }
        if (this.detectHullHeat != this.hullHeat) {
            mark = true;
            this.detectHullHeat = this.hullHeat;
        }
        if (this.detectRods != this.rods) {
            mark = true;
            this.detectRods = this.rods;
        }
        if (this.detectRetracting != this.retracting) {
            mark = true;
            this.detectRetracting = this.retracting;
        }
        if (this.detectCompression != this.compression) {
            mark = true;
            this.detectCompression = this.compression;
        }
        if (!FFUtils.areTanksEqual(this.tanks[0], this.detectTanks[0])) {
            mark = true;
            this.needsUpdate = true;
            this.detectTanks[0] = FFUtils.copyTank(this.tanks[0]);
        }
        if (!FFUtils.areTanksEqual(this.tanks[1], this.detectTanks[1])) {
            mark = true;
            this.needsUpdate = true;
            this.detectTanks[1] = FFUtils.copyTank(this.tanks[1]);
        }
        if (!FFUtils.areTanksEqual(this.tanks[2], this.detectTanks[2])) {
            mark = true;
            this.needsUpdate = true;
            this.detectTanks[2] = FFUtils.copyTank(this.tanks[2]);
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.coreHeat, 2), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.hullHeat, 3), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.rods, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.retracting ? 1 : 0, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    public boolean[] getSubmergedDirection() {
        boolean[] sides = new boolean[]{this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, -1)).func_185904_a() == Material.field_151586_h, this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, 1)).func_185904_a() == Material.field_151586_h, this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 1, 0)).func_185904_a() == Material.field_151586_h, this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 1, 0)).func_185904_a() == Material.field_151586_h};
        return sides;
    }

    public boolean isSubmerged() {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, -1)).func_185904_a() == Material.field_151586_h || this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, 1)).func_185904_a() == Material.field_151586_h || this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 1, 0)).func_185904_a() == Material.field_151586_h || this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 1, 0)).func_185904_a() == Material.field_151586_h;
    }
}

