/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.forgefluid.FFUtils;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.ArcWelderRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMachineArcWelder;
import com.hbm.inventory.gui.GUIMachineArcWelder;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineArcWelder
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IFluidHandler,
IEnergyUser,
ITankPacketAcceptor {
    public boolean wasOn;
    public long power;
    public long maxPower = 2000L;
    public long consumption;
    public int progress;
    public int processTime = 1;
    public FluidTank tank;
    public ItemStack display;
    public UpgradeManager upgradeManager = new UpgradeManager();
    private static final int[][] rotSlots = new int[][]{{3, 0, 1, 2}, {1, 2, 3, 0}, {0, 1, 2, 3}, {2, 3, 0, 1}};
    AxisAlignedBB bb = null;

    public TileEntityMachineArcWelder() {
        super(7);
        this.tank = new FluidTank(24000);
    }

    @Override
    public String getName() {
        return "container.machineArcWelder";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            long intendedMaxPower;
            this.wasOn = false;
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 4, this.getPower(), this.getMaxPower());
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, pos.getPos(), pos.getDir());
                    if (this.tank.getFluidAmount() <= 0) continue;
                    FFUtils.fillFluid(this, this.tank, this.field_145850_b, pos.getPos(), this.tank.getCapacity() >> 1);
                }
            }
            ArcWelderRecipes.ArcWelderRecipe recipe = ArcWelderRecipes.getRecipe(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1), this.inventory.getStackInSlot(2));
            this.upgradeManager.eval((IItemHandler)this.inventory, 5, 6);
            int redLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int blueLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            if (recipe != null) {
                this.display = recipe.output.func_77946_l();
                this.processTime = recipe.duration - recipe.duration * redLevel / 6 + recipe.duration * blueLevel / 3;
                this.consumption = recipe.consumption + recipe.consumption * (long)redLevel - recipe.consumption * (long)blueLevel / 6L;
                intendedMaxPower = recipe.consumption * 20L;
                if (this.canProcess(recipe)) {
                    this.wasOn = true;
                    ++this.progress;
                    this.power -= this.consumption;
                    if (this.progress >= this.processTime) {
                        this.progress = 0;
                        this.consumeItems(recipe);
                        if (this.inventory.getStackInSlot(3).func_190926_b()) {
                            this.inventory.setStackInSlot(3, recipe.output.func_77946_l());
                        } else {
                            this.inventory.getStackInSlot(3).func_190917_f(recipe.output.func_190916_E());
                        }
                        this.func_70296_d();
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.display = null;
                this.progress = 0;
                this.consumption = 100L;
                intendedMaxPower = 2000L;
            }
            this.maxPower = Math.max(intendedMaxPower, this.power);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("maxPower", this.maxPower);
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("processTime", this.processTime);
            data.func_74757_a("wasOn", this.wasOn);
            if (this.display != null) {
                data.func_74768_a("itemId", Item.func_150891_b((Item)this.display.func_77973_b()));
                data.func_74768_a("itemMeta", this.display.func_77952_i());
            } else {
                data.func_74768_a("itemId", -1);
            }
            this.tank.writeToNBT(data);
            this.networkPack(data, 25);
        } else if (this.wasOn && this.field_145850_b.func_82737_E() % 2L == 0L) {
            ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", this.field_145850_b.func_82737_E() % 20L == 0L ? "tau" : "hadron");
            data.func_74774_a("count", (byte)5);
            data.func_74780_a("posX", (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * 0.5);
            data.func_74780_a("posY", (double)this.field_174879_c.func_177956_o() + 1.25);
            data.func_74780_a("posZ", (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * 0.5);
            MainRegistry.proxy.effectNT(data);
        }
    }

    public boolean canProcess(ArcWelderRecipes.ArcWelderRecipe recipe) {
        if (this.power < this.consumption) {
            return false;
        }
        if (recipe.fluid != null && this.tank.getFluid() != null) {
            if (this.tank.getFluid().getFluid() != recipe.fluid.getFluid()) {
                return false;
            }
            if (this.tank.getFluidAmount() < recipe.fluid.amount) {
                return false;
            }
        }
        if (!this.inventory.getStackInSlot(3).func_190926_b()) {
            ItemStack slot3 = this.inventory.getStackInSlot(3);
            if (slot3.func_77973_b() != recipe.output.func_77973_b()) {
                return false;
            }
            if (slot3.func_77952_i() != recipe.output.func_77952_i()) {
                return false;
            }
            return slot3.func_190916_E() + recipe.output.func_190916_E() <= slot3.func_77976_d();
        }
        return true;
    }

    public void consumeItems(ArcWelderRecipes.ArcWelderRecipe recipe) {
        block0: for (RecipesCommon.AStack aStack : recipe.ingredients) {
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (!aStack.matchesRecipe(stack, true) || stack.func_190916_E() < aStack.count()) continue;
                stack.func_190918_g(aStack.count());
                if (stack.func_190916_E() != 0) continue block0;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                continue block0;
            }
        }
        if (recipe.fluid != null) {
            this.tank.drain(recipe.fluid.amount, true);
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n() + dir.offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ, dir), new DirPos(this.field_174879_c.func_177958_n() + dir.offsetX + rot.offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ + rot.offsetZ, dir), new DirPos(this.field_174879_c.func_177958_n() + dir.offsetX - rot.offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + dir.offsetZ - rot.offsetZ, dir), new DirPos(this.field_174879_c.func_177958_n() - dir.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_174879_c.func_177958_n() - dir.offsetX * 2 + rot.offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_174879_c.func_177958_n() - dir.offsetX * 2 - rot.offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite()), new DirPos(this.field_174879_c.func_177958_n() + rot.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + rot.offsetZ * 2, rot), new DirPos(this.field_174879_c.func_177958_n() - dir.offsetX + rot.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ + rot.offsetZ * 2, rot), new DirPos(this.field_174879_c.func_177958_n() - rot.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_174879_c.func_177958_n() - dir.offsetX - rot.offsetX * 2, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - dir.offsetZ - rot.offsetZ * 2, rot.getOpposite())};
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.wasOn = nbt.func_74767_n("wasOn");
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.progress = nbt.func_74762_e("progress");
        this.processTime = nbt.func_74762_e("processTime");
        this.display = nbt.func_74762_e("itemId") > 0 ? new ItemStack(Item.func_150899_d((int)nbt.func_74762_e("itemId")), 1, nbt.func_74762_e("itemMeta")) : null;
        this.tank.readFromNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.progress = nbt.func_74762_e("progress");
        this.processTime = nbt.func_74762_e("processTime");
        this.tank.readFromNBT(nbt);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("maxPower", this.maxPower);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("processTime", this.processTime);
        this.tank.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    @Override
    public long getPower() {
        return Math.max(Math.min(this.power, this.maxPower), 0L);
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return this.maxPower;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return slot < 3;
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 3;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        if (e.func_176745_a() == 0) {
            return new int[]{3};
        }
        if (e.func_176745_a() == 1) {
            return new int[]{0, 1, 2};
        }
        return new int[]{rotSlots[this.func_145832_p() - 10 - 2][e.func_176736_b()]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineArcWelder(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineArcWelder(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length != 1) {
            return;
        }
        this.tank.readFromNBT(tags[0]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tank.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.amount > 0 && (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == resource.getFluid()) && ArcWelderRecipes.fluids.contains(resource.getFluid())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

