/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyUser;
import com.hbm.blocks.machine.MachineArcFurnace;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineArcFurnace
extends TileEntityMachineBase
implements ITickable,
IEnergyUser {
    public int dualCookTime;
    public long power;
    public static final long maxPower = 50000L;
    public static final int processingSpeed = 20;
    private String customName;

    public TileEntityMachineArcFurnace() {
        super(6);
    }

    @Override
    public String getName() {
        return "container.arcFurnace";
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("powerTime");
        this.dualCookTime = compound.func_74762_e("cookTime");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("powerTime", this.power);
        compound.func_74768_a("cookTime", this.dualCookTime);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.dualCookTime * i / 20;
    }

    public long getPowerRemainingScaled(long i) {
        return this.power * i / 50000L;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    private boolean hasElectrodes() {
        if (!(this.inventory.getStackInSlot(2).func_190926_b() || this.inventory.getStackInSlot(3).func_190926_b() || this.inventory.getStackInSlot(4).func_190926_b())) {
            return !(this.inventory.getStackInSlot(2).func_77973_b() != ModItems.arc_electrode && this.inventory.getStackInSlot(2).func_77973_b() != ModItems.arc_electrode_desh || this.inventory.getStackInSlot(3).func_77973_b() != ModItems.arc_electrode && this.inventory.getStackInSlot(3).func_77973_b() != ModItems.arc_electrode_desh || this.inventory.getStackInSlot(4).func_77973_b() != ModItems.arc_electrode && this.inventory.getStackInSlot(4).func_77973_b() != ModItems.arc_electrode_desh);
        }
        return false;
    }

    public boolean canProcess() {
        if (!this.hasElectrodes()) {
            return false;
        }
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0));
        if (itemStack == null || itemStack.func_190926_b()) {
            return false;
        }
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            return true;
        }
        if (!this.inventory.getStackInSlot(1).func_77969_a(itemStack)) {
            return false;
        }
        if (this.inventory.getStackInSlot(1).func_190916_E() < this.inventory.getSlotLimit(1) && this.inventory.getStackInSlot(1).func_190916_E() < this.inventory.getStackInSlot(1).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(1).func_190916_E() < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            int i;
            ItemStack itemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.inventory.getStackInSlot(0));
            if (this.inventory.getStackInSlot(1).func_190926_b()) {
                this.inventory.setStackInSlot(1, itemStack.func_77946_l());
            } else if (this.inventory.getStackInSlot(1).func_77969_a(itemStack)) {
                this.inventory.getStackInSlot(1).func_190917_f(itemStack.func_190916_E());
            }
            for (i = 0; i < 1; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) {
                    this.inventory.setStackInSlot(i, new ItemStack(this.inventory.getStackInSlot(i).func_77973_b()));
                } else {
                    this.inventory.getStackInSlot(i).func_190918_g(1);
                }
                if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
            for (i = 2; i < 5; ++i) {
                if (this.inventory.getStackInSlot(i).func_77973_b() != ModItems.arc_electrode) continue;
                if (this.inventory.getStackInSlot(i).func_77952_i() < this.inventory.getStackInSlot(i).func_77958_k()) {
                    this.inventory.getStackInSlot(i).func_77964_b(this.inventory.getStackInSlot(i).func_77952_i() + 1);
                    continue;
                }
                this.inventory.setStackInSlot(i, new ItemStack(ModItems.arc_electrode_burnt));
            }
        }
    }

    public void func_73660_a() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            boolean trigger;
            this.updateStandardConnections(this.field_145850_b, this.field_174879_c);
            long prevPower = this.power;
            if (this.hasPower() && this.canProcess()) {
                ++this.dualCookTime;
                this.power -= 250L;
                if (this.power < 0L) {
                    this.power = 0L;
                }
                if (this.dualCookTime == 20) {
                    this.dualCookTime = 0;
                    this.processItem();
                    flag1 = true;
                }
            } else {
                this.dualCookTime = 0;
            }
            boolean bl = trigger = !this.hasPower() || !this.canProcess() || this.dualCookTime != 0;
            if (trigger) {
                flag1 = true;
                MachineArcFurnace.updateBlockState(this.dualCookTime > 0, this.field_145850_b, this.field_174879_c);
            }
            if (MachineArcFurnace.updateBlockRods(this.hasElectrodes(), this.field_145850_b, this.field_174879_c)) {
                flag1 = true;
            }
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 5, this.power, 50000L);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.dualCookTime, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
            if (flag1 || prevPower != this.power) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }

    @Override
    public boolean canInsertItem(int i, ItemStack itemStack, int j) {
        return this.isItemValidForSlot(i, itemStack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        if (slot == 1) {
            return true;
        }
        if (slot == 2 || slot == 3 || slot == 4) {
            return itemStack.func_77973_b() == ModItems.arc_electrode_burnt;
        }
        if (slot == 5) {
            return itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == 0L;
        }
        return false;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 2 || slot == 3 || slot == 4) {
            return stack.func_77973_b() == ModItems.arc_electrode || stack.func_77973_b() == ModItems.arc_electrode_desh;
        }
        if (slot == 5) {
            return stack.func_77973_b() instanceof IBatteryItem;
        }
        if (slot == 0) {
            return !(stack.func_77973_b() instanceof IBatteryItem) && stack.func_77973_b() != ModItems.arc_electrode && stack.func_77973_b() != ModItems.arc_electrode_desh;
        }
        return false;
    }
}

