/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.machine.BlockHadronDiode;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityTickingBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityHadronDiode
extends TileEntityTickingBase {
    int age = 0;
    boolean fatherIAskOfYouToUpdateMe = false;
    public DiodeConfig[] sides = new DiodeConfig[6];

    public TileEntityHadronDiode() {
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = DiodeConfig.NONE;
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
                this.sendSides();
            }
            if (this.fatherIAskOfYouToUpdateMe) {
                this.fatherIAskOfYouToUpdateMe = false;
                BlockHadronDiode.resetBlockState(this.field_145850_b, this.field_174879_c);
            }
        }
    }

    @Override
    public String getInventoryName() {
        return "";
    }

    public void sendSides() {
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            if (this.sides[i] == null) continue;
            data.func_74768_a("" + i, this.sides[i].ordinal());
        }
        BlockHadronDiode.resetBlockState(this.field_145850_b, this.field_174879_c);
        this.networkPack(data, 250);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = DiodeConfig.values()[nbt.func_74762_e("" + i)];
        }
    }

    public DiodeConfig getConfig(int side) {
        if (ForgeDirection.getOrientation(side) == ForgeDirection.UNKNOWN) {
            return DiodeConfig.NONE;
        }
        DiodeConfig conf = this.sides[side];
        if (conf == null) {
            return DiodeConfig.NONE;
        }
        return conf;
    }

    public void setConfig(int side, int config) {
        this.sides[side] = DiodeConfig.values()[config];
        this.func_70296_d();
        this.sendSides();
    }

    public void func_145839_a(NBTTagCompound compound) {
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = DiodeConfig.values()[compound.func_74762_e("side_" + i)];
        }
        this.fatherIAskOfYouToUpdateMe = true;
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        for (int i = 0; i < 6; ++i) {
            if (this.sides[i] == null) continue;
            compound.func_74768_a("side_" + i, this.sides[i].ordinal());
        }
        return super.func_189515_b(compound);
    }

    public static enum DiodeConfig {
        NONE,
        IN,
        OUT;

    }
}

