/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import com.hbm.lib.DirPos;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.machine.TileEntityCondenser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class TileEntityCondenserPowered
extends TileEntityCondenser
implements IEnergyUser {
    public boolean isLoaded = true;
    public long power;
    public float spin;
    public float lastSpin;
    public static long maxPower = 10000000L;
    public static int inputTankSizeP = 1000000;
    public static int outputTankSizeP = 1000000;
    public static int powerConsumption = 10;
    AxisAlignedBB bb = null;

    public TileEntityCondenserPowered() {
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(inputTankSizeP);
        this.tanks[1] = new FluidTank(outputTankSizeP);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
        }
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.lastSpin = this.spin;
            if (this.waterTimer > 0) {
                this.spin += 30.0f;
                if (this.spin >= 360.0f) {
                    this.spin -= 360.0f;
                    this.lastSpin -= 360.0f;
                }
                if (this.field_145850_b.func_82737_E() % 4L == 0L) {
                    ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.CLOUD, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX * 1.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ * 1.5, (double)dir.offsetX * 0.1, 0.0, (double)dir.offsetZ * 0.1, new int[0]);
                    this.field_145850_b.func_175688_a(EnumParticleTypes.CLOUD, (double)this.field_174879_c.func_177958_n() + 0.5 - (double)dir.offsetX * 1.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5 - (double)dir.offsetZ * 1.5, (double)dir.offsetX * -0.1, 0.0, (double)dir.offsetZ * -0.1, new int[0]);
                }
            }
        }
    }

    @Override
    public void packExtra(NBTTagCompound data) {
        data.func_74772_a("power", this.power);
    }

    @Override
    public boolean extraCondition(int convert) {
        return this.power >= (long)convert * 10L;
    }

    @Override
    public void postConvert(int convert) {
        this.power -= (long)convert * (long)powerConsumption;
        if (this.power < 0L) {
            this.power = 0L;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        super.networkUnpack(data);
        this.power = data.func_74763_f("power");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("power", this.power);
        return nbt;
    }

    @Override
    public void fillFluidInit(FluidTank tank) {
        for (DirPos pos : this.getConPos()) {
            this.fillFluid(pos.getPos().func_177958_n(), pos.getPos().func_177956_o(), pos.getPos().func_177952_p(), tank);
        }
    }

    protected void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getPos(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_174879_c.func_177958_n() + rot.offsetX * 4, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + rot.offsetZ * 4, rot), new DirPos(this.field_174879_c.func_177958_n() - rot.offsetX * 4, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_174879_c.func_177958_n() + dir.offsetX * 2 - rot.offsetX, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + dir.offsetZ * 2 - rot.offsetZ, dir), new DirPos(this.field_174879_c.func_177958_n() + dir.offsetX * 2 + rot.offsetX, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + dir.offsetZ * 2 + rot.offsetZ, dir), new DirPos(this.field_174879_c.func_177958_n() - dir.offsetX * 2 - rot.offsetX, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite()), new DirPos(this.field_174879_c.func_177958_n() - dir.offsetX * 2 + rot.offsetX, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite())};
    }

    @NotNull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 3), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 3), (double)(this.field_174879_c.func_177958_n() + 4), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void onChunkUnload() {
        this.isLoaded = false;
        super.onChunkUnload();
    }
}

