/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemCell;
import com.hbm.items.tool.ItemFluidCanister;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityNukeCustom
extends TileEntity
implements ITickable {
    public ItemStackHandler inventory = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileEntityNukeCustom.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    private String customName;
    public static HashMap<RecipesCommon.ComparableStack, CustomNukeEntry> entries = new HashMap();
    public float tnt;
    public float nuke;
    public float hydro;
    public float bale;
    public float dirty;
    public float schrab;
    public float sol;
    public float euph;

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.nukeCustom";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public static void registerBombItems() {
        entries.put(new RecipesCommon.ComparableStack(Items.field_151016_H), new CustomNukeEntry(EnumBombType.TNT, 0.8f));
        entries.put(new RecipesCommon.ComparableStack(Blocks.field_150335_W), new CustomNukeEntry(EnumBombType.TNT, 4.0f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.det_cord), new CustomNukeEntry(EnumBombType.TNT, 1.5f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_semtex), new CustomNukeEntry(EnumBombType.TNT, 8.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_c4), new CustomNukeEntry(EnumBombType.TNT, 10.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ball_dynamite), new CustomNukeEntry(EnumBombType.TNT, 4.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ball_tnt), new CustomNukeEntry(EnumBombType.TNT, 6.0f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.det_charge), new CustomNukeEntry(EnumBombType.TNT, 15.0f));
        entries.put(new RecipesCommon.NbtComparableStack(ItemFluidCanister.getFullCanister(ModForgeFluids.DIESEL)), new CustomNukeEntry(EnumBombType.TNT, 0.5f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.canister_napalm), new CustomNukeEntry(EnumBombType.TNT, 2.5f));
        entries.put(new RecipesCommon.NbtComparableStack(ItemFluidCanister.getFullCanister(ModForgeFluids.KEROSENE)), new CustomNukeEntry(EnumBombType.TNT, 0.8f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.red_barrel), new CustomNukeEntry(EnumBombType.TNT, 2.5f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.pink_barrel), new CustomNukeEntry(EnumBombType.TNT, 4.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.custom_tnt), new CustomNukeEntry(EnumBombType.TNT, 10.0f));
        entries.put(new RecipesCommon.ComparableStack(Items.field_151137_ax), new CustomNukeEntry(EnumBombType.TNT, 1.005f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(Blocks.field_150451_bX), new CustomNukeEntry(EnumBombType.TNT, 1.05f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.n2_charge), new CustomNukeEntry(EnumBombType.TNT, 1.25f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_u235), new CustomNukeEntry(EnumBombType.NUKE, 1.5f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_u235), new CustomNukeEntry(EnumBombType.NUKE, 10.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_u235), new CustomNukeEntry(EnumBombType.NUKE, 15.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_pu239), new CustomNukeEntry(EnumBombType.NUKE, 2.5f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_pu239), new CustomNukeEntry(EnumBombType.NUKE, 17.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_pu239), new CustomNukeEntry(EnumBombType.NUKE, 25.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_neptunium), new CustomNukeEntry(EnumBombType.NUKE, 3.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_neptunium), new CustomNukeEntry(EnumBombType.NUKE, 20.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_neptunium), new CustomNukeEntry(EnumBombType.NUKE, 30.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_neptunium), new CustomNukeEntry(EnumBombType.NUKE, 30.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.custom_nuke), new CustomNukeEntry(EnumBombType.NUKE, 30.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.neutron_reflector), new CustomNukeEntry(EnumBombType.NUKE, 1.1f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_uranium), new CustomNukeEntry(EnumBombType.NUKE, 1.005f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_uranium), new CustomNukeEntry(EnumBombType.NUKE, 1.05f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_uranium), new CustomNukeEntry(EnumBombType.NUKE, 1.05f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_plutonium), new CustomNukeEntry(EnumBombType.NUKE, 1.15f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_plutonium), new CustomNukeEntry(EnumBombType.NUKE, 1.15f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_plutonium), new CustomNukeEntry(EnumBombType.NUKE, 1.15f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_u238), new CustomNukeEntry(EnumBombType.NUKE, 1.01f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_u238), new CustomNukeEntry(EnumBombType.NUKE, 1.1f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_pu238), new CustomNukeEntry(EnumBombType.NUKE, 1.015f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_pu238), new CustomNukeEntry(EnumBombType.NUKE, 1.15f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.DEUTERIUM)), new CustomNukeEntry(EnumBombType.HYDRO, 20.0f));
        entries.put(new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.TRITIUM)), new CustomNukeEntry(EnumBombType.HYDRO, 30.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_lithium_tiny), new CustomNukeEntry(EnumBombType.HYDRO, 2.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_lithium), new CustomNukeEntry(EnumBombType.HYDRO, 20.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.lithium), new CustomNukeEntry(EnumBombType.HYDRO, 20.0f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_lithium), new CustomNukeEntry(EnumBombType.HYDRO, 200.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.tritium_deuterium_cake), new CustomNukeEntry(EnumBombType.HYDRO, 300.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.custom_hydro), new CustomNukeEntry(EnumBombType.HYDRO, 30.0f));
        entries.put(new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.AMAT)), new CustomNukeEntry(EnumBombType.BALE, 1.05f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.particle_amat), new CustomNukeEntry(EnumBombType.BALE, 1.05f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.pellet_antimatter), new CustomNukeEntry(EnumBombType.BALE, 1.5f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.egg_balefire_shard), new CustomNukeEntry(EnumBombType.BALE, 15.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.egg_balefire), new CustomNukeEntry(EnumBombType.BALE, 150.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.custom_amat), new CustomNukeEntry(EnumBombType.BALE, 15.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_tungsten), new CustomNukeEntry(EnumBombType.DIRTY, 0.1f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_tungsten), new CustomNukeEntry(EnumBombType.DIRTY, 0.1f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_tungsten), new CustomNukeEntry(EnumBombType.DIRTY, 1.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.fragment_cobalt), new CustomNukeEntry(EnumBombType.DIRTY, 0.1f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_cobalt), new CustomNukeEntry(EnumBombType.DIRTY, 0.1f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_cobalt), new CustomNukeEntry(EnumBombType.DIRTY, 1.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_cobalt_tiny), new CustomNukeEntry(EnumBombType.DIRTY, 0.1f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_cobalt), new CustomNukeEntry(EnumBombType.DIRTY, 1.0f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_cobalt), new CustomNukeEntry(EnumBombType.DIRTY, 10.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_co60), new CustomNukeEntry(EnumBombType.DIRTY, 0.4f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_co60), new CustomNukeEntry(EnumBombType.DIRTY, 4.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_co60_tiny), new CustomNukeEntry(EnumBombType.DIRTY, 0.4f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_co60), new CustomNukeEntry(EnumBombType.DIRTY, 4.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_co60), new CustomNukeEntry(EnumBombType.DIRTY, 3.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_strontium), new CustomNukeEntry(EnumBombType.DIRTY, 0.2f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_strontium), new CustomNukeEntry(EnumBombType.DIRTY, 2.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_strontium), new CustomNukeEntry(EnumBombType.DIRTY, 2.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_sr90), new CustomNukeEntry(EnumBombType.DIRTY, 0.6f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_sr90), new CustomNukeEntry(EnumBombType.DIRTY, 6.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_sr90_tiny), new CustomNukeEntry(EnumBombType.DIRTY, 0.6f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_sr90), new CustomNukeEntry(EnumBombType.DIRTY, 6.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_sr90), new CustomNukeEntry(EnumBombType.DIRTY, 4.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_iodine), new CustomNukeEntry(EnumBombType.DIRTY, 12.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_iodine_tiny), new CustomNukeEntry(EnumBombType.DIRTY, 1.2f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_iodine), new CustomNukeEntry(EnumBombType.DIRTY, 12.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_i131), new CustomNukeEntry(EnumBombType.DIRTY, 24.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_i131_tiny), new CustomNukeEntry(EnumBombType.DIRTY, 2.4f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_i131), new CustomNukeEntry(EnumBombType.DIRTY, 24.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.custom_dirty), new CustomNukeEntry(EnumBombType.DIRTY, 10.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_pu240), new CustomNukeEntry(EnumBombType.DIRTY, 1.05f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_pu240), new CustomNukeEntry(EnumBombType.DIRTY, 1.005f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_pu240), new CustomNukeEntry(EnumBombType.DIRTY, 1.03f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_pu240), new CustomNukeEntry(EnumBombType.DIRTY, 1.5f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_nuclear_waste), new CustomNukeEntry(EnumBombType.DIRTY, 1.02f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nuclear_waste), new CustomNukeEntry(EnumBombType.DIRTY, 1.025f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nuclear_waste_tiny), new CustomNukeEntry(EnumBombType.DIRTY, 1.0025f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_waste), new CustomNukeEntry(EnumBombType.DIRTY, 1.25f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_waste_painted), new CustomNukeEntry(EnumBombType.DIRTY, 1.25f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.yellow_barrel), new CustomNukeEntry(EnumBombType.DIRTY, 1.2f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_schrabidium), new CustomNukeEntry(EnumBombType.SCHRAB, 5.0f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_schrabidium), new CustomNukeEntry(EnumBombType.SCHRAB, 50.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_schrabidium), new CustomNukeEntry(EnumBombType.SCHRAB, 3.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_schrabidium), new CustomNukeEntry(EnumBombType.SCHRAB, 0.5f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_schrabidium), new CustomNukeEntry(EnumBombType.SCHRAB, 5.0f));
        entries.put(new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.SAS3)), new CustomNukeEntry(EnumBombType.SCHRAB, 7.5f));
        entries.put(new RecipesCommon.NbtComparableStack(ItemCell.getFullCell(ModForgeFluids.ASCHRAB)), new CustomNukeEntry(EnumBombType.SCHRAB, 15.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.custom_schrab), new CustomNukeEntry(EnumBombType.SCHRAB, 15.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.solinium_core), new CustomNukeEntry(EnumBombType.SOL, 20.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_solinium), new CustomNukeEntry(EnumBombType.SOL, 0.5f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_solinium), new CustomNukeEntry(EnumBombType.SOL, 5.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.billet_solinium), new CustomNukeEntry(EnumBombType.SOL, 3.0f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_solinium), new CustomNukeEntry(EnumBombType.SOL, 50.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_unobtainium), new CustomNukeEntry(EnumBombType.SOL, 1.01f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_unobtainium), new CustomNukeEntry(EnumBombType.SOL, 1.1f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_unobtainium), new CustomNukeEntry(EnumBombType.SOL, 1.1f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_unobtainium), new CustomNukeEntry(EnumBombType.SOL, 1.5f, EnumEntryType.MULT));
        entries.put(new RecipesCommon.ComparableStack(ModItems.custom_sol), new CustomNukeEntry(EnumBombType.SOL, 15.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.nugget_euphemium), new CustomNukeEntry(EnumBombType.EUPH, 0.1f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.ingot_euphemium), new CustomNukeEntry(EnumBombType.EUPH, 1.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.custom_euph), new CustomNukeEntry(EnumBombType.EUPH, 2.0f));
        entries.put(new RecipesCommon.ComparableStack(ModItems.powder_euphemium), new CustomNukeEntry(EnumBombType.EUPH, 1.0f));
        entries.put(new RecipesCommon.ComparableStack(ModBlocks.block_euphemium), new CustomNukeEntry(EnumBombType.EUPH, 10.0f));
    }

    public void func_73660_a() {
        float tnt = 0.0f;
        float tntMod = 1.0f;
        float nuke = 0.0f;
        float nukeMod = 1.0f;
        float hydro = 0.0f;
        float hydroMod = 1.0f;
        float bale = 0.0f;
        float baleMod = 1.0f;
        float dirty = 0.0f;
        float dirtyMod = 1.0f;
        float schrab = 0.0f;
        float schrabMod = 1.0f;
        float sol = 0.0f;
        float solMod = 1.0f;
        float euph = 0.0f;
        block19: for (int i = 0; i < this.inventory.getSlots(); ++i) {
            RecipesCommon.ComparableStack comp;
            CustomNukeEntry ent;
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b() || (ent = entries.get(comp = new RecipesCommon.NbtComparableStack(stack).makeSingular())) == null) continue;
            if (ent.entry == EnumEntryType.ADD) {
                switch (ent.type) {
                    case TNT: {
                        tnt += ent.value;
                        break;
                    }
                    case NUKE: {
                        nuke += ent.value;
                        break;
                    }
                    case HYDRO: {
                        hydro += ent.value;
                        break;
                    }
                    case BALE: {
                        bale += ent.value;
                        break;
                    }
                    case DIRTY: {
                        dirty += ent.value;
                        break;
                    }
                    case SCHRAB: {
                        schrab += ent.value;
                        break;
                    }
                    case SOL: {
                        sol += ent.value;
                        break;
                    }
                    case EUPH: {
                        euph += ent.value;
                    }
                }
                continue;
            }
            if (ent.entry != EnumEntryType.MULT) continue;
            switch (ent.type) {
                case TNT: {
                    tntMod *= ent.value;
                    continue block19;
                }
                case NUKE: {
                    nukeMod *= ent.value;
                    continue block19;
                }
                case HYDRO: {
                    hydroMod *= ent.value;
                    continue block19;
                }
                case BALE: {
                    baleMod *= ent.value;
                    continue block19;
                }
                case DIRTY: {
                    dirtyMod *= ent.value;
                    continue block19;
                }
                case SOL: {
                    solMod *= ent.value;
                    continue block19;
                }
                case SCHRAB: {
                    schrabMod *= ent.value;
                }
            }
        }
        tnt *= tntMod;
        nuke *= nukeMod;
        hydro *= hydroMod;
        bale *= baleMod;
        dirty *= dirtyMod;
        sol *= solMod;
        schrab *= schrabMod;
        if (tnt < 16.0f) {
            nuke = 0.0f;
        }
        if (nuke < 100.0f) {
            hydro = 0.0f;
        }
        if (nuke < 50.0f) {
            bale = 0.0f;
        }
        if (nuke < 50.0f) {
            schrab = 0.0f;
        }
        if (nuke < 25.0f) {
            sol = 0.0f;
        }
        if (schrab < 1.0f || sol < 1.0f) {
            euph = 0.0f;
        }
        this.tnt = Math.min(tnt, (float)BombConfig.maxCustomTNTRadius);
        this.nuke = Math.min(nuke, (float)BombConfig.maxCustomNukeRadius);
        this.hydro = Math.min(hydro, (float)BombConfig.maxCustomHydroRadius);
        this.bale = Math.min(bale, (float)BombConfig.maxCustomBaleRadius);
        this.dirty = Math.min(dirty, (float)BombConfig.maxCustomDirtyRadius);
        this.schrab = Math.min(schrab, (float)BombConfig.maxCustomSchrabRadius);
        this.sol = Math.min(sol, (float)BombConfig.maxCustomSolRadius);
        this.euph = Math.min(euph, (float)BombConfig.maxCustomEuphLvl);
    }

    public float getNukeAdj() {
        if (this.nuke == 0.0f) {
            return 0.0f;
        }
        return Math.min(this.nuke + this.tnt / 2.0f, (float)BombConfig.maxCustomNukeRadius);
    }

    public float getHydroAdj() {
        if (this.hydro == 0.0f) {
            return 0.0f;
        }
        return Math.min(this.hydro + this.nuke / 2.0f + this.tnt / 4.0f, (float)BombConfig.maxCustomHydroRadius);
    }

    public float getBaleAdj() {
        if (this.bale == 0.0f) {
            return 0.0f;
        }
        return Math.min(this.bale + this.hydro / 2.0f + this.nuke / 4.0f + this.tnt / 8.0f, (float)BombConfig.maxCustomBaleRadius);
    }

    public float getSchrabAdj() {
        if (this.schrab == 0.0f) {
            return 0.0f;
        }
        return Math.min(this.schrab + this.bale / 2.0f + this.hydro / 4.0f + this.nuke / 8.0f + this.tnt / 16.0f, (float)BombConfig.maxCustomSchrabRadius);
    }

    public float getSolAdj() {
        if (this.sol == 0.0f) {
            return 0.0f;
        }
        return Math.min(this.sol + this.schrab / 2.0f + this.bale / 4.0f + this.hydro / 8.0f + this.nuke / 16.0f + this.tnt / 32.0f, (float)BombConfig.maxCustomSolRadius);
    }

    public boolean isFalling() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack == null || stack.func_77973_b() != ModItems.custom_fall) continue;
            return true;
        }
        return false;
    }

    public void destruct() {
        this.clearSlots();
        this.field_145850_b.func_175655_b(this.field_174879_c, false);
    }

    public void clearSlots() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public static class CustomNukeEntry {
        public EnumBombType type;
        public EnumEntryType entry;
        public float value;

        public CustomNukeEntry(EnumBombType type, float value) {
            this.type = type;
            this.entry = EnumEntryType.ADD;
            this.value = value;
        }

        public CustomNukeEntry(EnumBombType type, float value, EnumEntryType entry) {
            this(type, value);
            this.entry = entry;
        }
    }

    public static enum EnumBombType {
        TNT("TNT"),
        NUKE("Nuclear"),
        HYDRO("Hydrogen"),
        BALE("Balefire"),
        DIRTY("Salted"),
        SCHRAB("Schrabidium"),
        SOL("Solinium"),
        EUPH("Anti Mass");

        final String name;

        private EnumBombType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum EnumEntryType {
        ADD,
        MULT;

    }
}

