/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import com.hbm.handler.HbmShaderManager2;
import com.hbm.main.ClientProxy;
import com.hbm.main.ResourceManager;
import com.hbm.render.GLCompat;
import com.hbm.util.BobMathUtil;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BakedModelUtil {
    private static BufferBuilder buffer = new BufferBuilder(16384);
    private static final int BYTES_PER_VERTEX = 32;

    public static int[] generateDecalMesh(World world, Vec3d normal, float scale, float offsetX, float offsetY, float offsetZ, DecalType type) {
        return BakedModelUtil.generateDecalMesh(world, normal, scale, offsetX, offsetY, offsetZ, type, null, new int[0]);
    }

    public static int[] generateDecalMesh(World world, Vec3d normal, float scale, float offsetX, float offsetY, float offsetZ, DecalType type, @Nullable ResourceLocation texture, int ... data) {
        Vec3d euler = BobMathUtil.getEulerAngles(normal);
        float roll = world.field_73012_v.nextFloat() * 2.0f * (float)Math.PI;
        Matrix3f rot = BakedModelUtil.eulerToMat((float)Math.toRadians(euler.field_72450_a), (float)Math.toRadians(euler.field_72448_b + 90.0), roll);
        Vec3d c1 = new Vec3d((double)rot.m00, (double)rot.m01, (double)rot.m02);
        Vec3d c2 = new Vec3d((double)rot.m10, (double)rot.m11, (double)rot.m12);
        Vec3d c3 = new Vec3d((double)rot.m20, (double)rot.m21, (double)rot.m22);
        float[][] planes = new float[6][4];
        planes[0] = new float[]{(float)c1.field_72450_a, (float)c1.field_72448_b, (float)c1.field_72449_c, scale};
        planes[1] = new float[]{(float)(-c1.field_72450_a), (float)(-c1.field_72448_b), (float)(-c1.field_72449_c), scale};
        planes[2] = new float[]{(float)c2.field_72450_a, (float)c2.field_72448_b, (float)c2.field_72449_c, scale};
        planes[3] = new float[]{(float)(-c2.field_72450_a), (float)(-c2.field_72448_b), (float)(-c2.field_72449_c), scale};
        planes[4] = new float[]{(float)c3.field_72450_a, (float)c3.field_72448_b, (float)c3.field_72449_c, scale * 3.0f};
        planes[5] = new float[]{(float)(-c3.field_72450_a), (float)(-c3.field_72448_b), (float)(-c3.field_72449_c), scale * 3.0f};
        AxisAlignedBB box = BakedModelUtil.getBox(c1.func_186678_a((double)scale), c2.func_186678_a((double)scale), c3.func_186678_a((double)(scale * 3.0f))).func_72317_d((double)offsetX, (double)offsetY, (double)offsetZ);
        ArrayList<Triangle> tris = new ArrayList<Triangle>();
        int i = (int)Math.floor(box.field_72340_a);
        while ((double)i <= Math.ceil(box.field_72336_d)) {
            int j = (int)Math.floor(box.field_72338_b);
            while ((double)j <= Math.ceil(box.field_72337_e)) {
                int k = (int)Math.floor(box.field_72339_c);
                while ((double)k <= Math.ceil(box.field_72334_f)) {
                    BlockPos blockPos = new BlockPos(i, j, k);
                    Vertex[] state = world.func_180495_p(blockPos);
                    if ((state = state.func_185899_b((IBlockAccess)world, blockPos)).func_185901_i() == EnumBlockRenderType.MODEL) {
                        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a((IBlockState)state);
                        List<Triangle> block_tris = BakedModelUtil.triangulateBlockModel(world, blockPos, model, (IBlockState)state, MathHelper.func_180186_a((Vec3i)blockPos), -offsetX, -offsetY, -offsetZ, true);
                        Iterator<Triangle> itr = block_tris.iterator();
                        while (itr.hasNext()) {
                            Triangle t = itr.next();
                            Vec3d tnorm = t.v2.pos.func_178788_d(t.v1.pos).func_72431_c(t.v3.pos.func_178788_d(t.v1.pos)).func_72432_b();
                            if (!(tnorm.func_72430_b(normal) > -0.2)) continue;
                            itr.remove();
                        }
                        for (int p = 0; p < planes.length; ++p) {
                            ArrayList<Triangle> newTris = new ArrayList<Triangle>();
                            float[] plane = planes[p];
                            for (Triangle t : block_tris) {
                                Triangle[][] clipped = BakedModelUtil.planeClipTriangle(t, plane);
                                if (clipped[0][0] != null) {
                                    newTris.add(clipped[0][0]);
                                }
                                if (clipped[0][1] == null) continue;
                                newTris.add(clipped[0][1]);
                            }
                            block_tris = newTris;
                        }
                        tris.addAll(block_tris);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int[] geo = new int[]{-1, -1};
        if (type == DecalType.VBO) {
            geo[0] = GLCompat.genBuffers();
            geo[1] = tris.size() * 3;
            GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, geo[0]);
            ByteBuffer buf = buffer.func_178966_f();
            buf.clear();
            for (Triangle triangle : tris) {
                if (96 > buf.remaining()) continue;
                for (Vertex v : triangle.vertices()) {
                    buf.putFloat((float)v.pos.field_72450_a);
                    buf.putFloat((float)v.pos.field_72448_b);
                    buf.putFloat((float)v.pos.field_72449_c);
                    buf.put((byte)(v.r * 255.0f));
                    buf.put((byte)(v.g * 255.0f));
                    buf.put((byte)(v.b * 255.0f));
                    buf.put((byte)(v.a * 255.0f));
                    buf.putFloat(v.u);
                    buf.putFloat(v.v);
                    buf.putShort((short)(v.lmapU * 65535.0f));
                    buf.putShort((short)(v.lmapV * 65535.0f));
                    Vector3f projTex = new Vector3f((float)v.pos.field_72450_a, (float)v.pos.field_72448_b, (float)v.pos.field_72449_c);
                    rot.transform((Tuple3f)projTex);
                    projTex.x = projTex.x * 0.5f / scale + 0.5f;
                    projTex.y = projTex.y * 0.5f / scale + 0.5f;
                    buf.putShort((short)(projTex.x * 65535.0f));
                    buf.putShort((short)(projTex.y * 65535.0f));
                }
            }
            buf.flip();
            GLCompat.bufferData(GLCompat.GL_ARRAY_BUFFER, buf, GLCompat.GL_STATIC_DRAW);
            buf.clear();
            GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, 0);
        } else {
            if (type == DecalType.FLOW) {
                geo = new int[7];
                if (texture == null) {
                    throw new RuntimeException("Null texture");
                }
            }
            geo[0] = GL11.glGenLists((int)1);
            GL11.glNewList((int)geo[0], (int)4864);
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder buf = tes.func_178180_c();
            buf.func_181668_a(4, DefaultVertexFormats.field_181710_j);
            for (Triangle t : tris) {
                Vec3d norm = t.v2.pos.func_178788_d(t.v1.pos).func_72431_c(t.v3.pos.func_178788_d(t.v1.pos)).func_72432_b();
                Vector3f tex1 = new Vector3f((float)t.v1.pos.field_72450_a, (float)t.v1.pos.field_72448_b, (float)t.v1.pos.field_72449_c);
                rot.transform((Tuple3f)tex1);
                Vector3f tex2 = new Vector3f((float)t.v2.pos.field_72450_a, (float)t.v2.pos.field_72448_b, (float)t.v2.pos.field_72449_c);
                rot.transform((Tuple3f)tex2);
                Vector3f tex3 = new Vector3f((float)t.v3.pos.field_72450_a, (float)t.v3.pos.field_72448_b, (float)t.v3.pos.field_72449_c);
                rot.transform((Tuple3f)tex3);
                float invScale = 1.0f / scale;
                buf.func_181662_b(t.v1.pos.field_72450_a, t.v1.pos.field_72448_b, t.v1.pos.field_72449_c).func_187315_a((double)tex1.x * 0.5 * (double)invScale + 0.5, (double)tex1.y * 0.5 * (double)invScale + 0.5).func_181663_c((float)norm.field_72450_a, (float)norm.field_72448_b, (float)norm.field_72449_c).func_181675_d();
                buf.func_181662_b(t.v2.pos.field_72450_a, t.v2.pos.field_72448_b, t.v2.pos.field_72449_c).func_187315_a((double)tex2.x * 0.5 * (double)invScale + 0.5, (double)tex2.y * 0.5 * (double)invScale + 0.5).func_181663_c((float)norm.field_72450_a, (float)norm.field_72448_b, (float)norm.field_72449_c).func_181675_d();
                buf.func_181662_b(t.v3.pos.field_72450_a, t.v3.pos.field_72448_b, t.v3.pos.field_72449_c).func_187315_a((double)tex3.x * 0.5 * (double)invScale + 0.5, (double)tex3.y * 0.5 * (double)invScale + 0.5).func_181663_c((float)norm.field_72450_a, (float)norm.field_72448_b, (float)norm.field_72449_c).func_181675_d();
            }
            tes.func_78381_a();
            GL11.glEndList();
            if (type == DecalType.FLOW) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                int n = Minecraft.func_71410_x().func_110434_K().func_110581_b(texture).func_110552_b();
                int width = geo[5] = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                int height = geo[6] = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                int fbo = geo[1] = GLCompat.genFramebuffers();
                int fbo2 = geo[3] = GLCompat.genFramebuffers();
                int gravmap = geo[2] = GL11.glGenTextures();
                int gravmap2 = geo[4] = GL11.glGenTextures();
                int depth = GLCompat.genRenderbuffers();
                GLCompat.bindRenderbuffer(GLCompat.GL_RENDERBUFFER, depth);
                GLCompat.renderbufferStorage(GLCompat.GL_RENDERBUFFER, GLCompat.GL_DEPTH_COMPONENT24, width, height);
                GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, fbo);
                GlStateManager.func_179144_i((int)gravmap);
                GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (IntBuffer)null);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                GLCompat.framebufferTexture2D(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_COLOR_ATTACHMENT0, 3553, gravmap, 0);
                GLCompat.framebufferRenderbuffer(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_DEPTH_ATTACHMENT, GLCompat.GL_RENDERBUFFER, depth);
                GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, fbo2);
                GlStateManager.func_179144_i((int)gravmap2);
                GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (IntBuffer)null);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                GLCompat.framebufferTexture2D(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_COLOR_ATTACHMENT0, 3553, gravmap2, 0);
                GLCompat.framebufferRenderbuffer(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_DEPTH_ATTACHMENT, GLCompat.GL_RENDERBUFFER, depth);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179140_f();
                GlStateManager.func_179118_c();
                GlStateManager.func_179129_p();
                GlStateManager.func_179142_g();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (data.length > 0) {
                    int texIdx = data[0];
                    int rows = data[1];
                    GlStateManager.func_179128_n((int)5890);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    float size = 1.0f / (float)rows;
                    float u = (float)(texIdx % rows) * size;
                    float v = (float)(texIdx / 4) * size;
                    GL11.glTranslated((double)u, (double)v, (double)0.0);
                    GL11.glScaled((double)size, (double)size, (double)1.0);
                    GlStateManager.func_179128_n((int)5888);
                }
                GlStateManager.func_179083_b((int)0, (int)0, (int)width, (int)height);
                GlStateManager.func_179144_i((int)n);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                GlStateManager.func_179128_n((int)5889);
                GL11.glPushMatrix();
                GL11.glLoadIdentity();
                ResourceManager.gravitymap_render.use();
                Matrix3f rot2 = BakedModelUtil.eulerToMat((float)Math.toRadians(euler.field_72450_a), (float)Math.toRadians(euler.field_72448_b + 90.0), 0.0f);
                Matrix3f mR = new Matrix3f();
                mR.rotZ(-roll);
                mR.mul(rot2);
                Vec3d tanDir = new Vec3d((double)mR.m10, (double)mR.m11, (double)mR.m12);
                ResourceManager.gravitymap_render.uniform3f("tanDirection", (float)tanDir.field_72450_a, (float)tanDir.field_72448_b, (float)tanDir.field_72449_c);
                Vector3f gravity = new Vector3f(0.0f, 0.5f, 0.0f);
                ResourceManager.gravitymap_render.uniform3f("gravity", gravity.x, gravity.y, gravity.z);
                for (int i2 = 0; i2 < 3; ++i2) {
                    for (int j = 0; j < 3; ++j) {
                        ClientProxy.AUX_GL_BUFFER.put(rot.getElement(i2, j));
                    }
                }
                ClientProxy.AUX_GL_BUFFER.flip();
                ResourceManager.gravitymap_render.uniformMatrix3("matrix", false, ClientProxy.AUX_GL_BUFFER);
                ClientProxy.AUX_GL_BUFFER.clear();
                GlStateManager.func_179151_a((double)1.0);
                GlStateManager.func_179082_a((float)0.5f, (float)0.5f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179086_m((int)16640);
                GL11.glCallList((int)geo[0]);
                GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, fbo);
                GlStateManager.func_179151_a((double)1.0);
                GlStateManager.func_179082_a((float)0.5f, (float)0.5f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179086_m((int)16640);
                GL11.glCallList((int)geo[0]);
                HbmShaderManager2.releaseShader();
                GL11.glPopMatrix();
                GlStateManager.func_179128_n((int)5888);
                GL11.glPopMatrix();
                GLCompat.framebufferRenderbuffer(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_DEPTH_ATTACHMENT, GLCompat.GL_RENDERBUFFER, 0);
                GLCompat.bindFramebuffer(GLCompat.GL_FRAMEBUFFER, fbo2);
                GLCompat.framebufferRenderbuffer(GLCompat.GL_FRAMEBUFFER, GLCompat.GL_DEPTH_ATTACHMENT, GLCompat.GL_RENDERBUFFER, 0);
                GLCompat.deleteRenderbuffers(depth);
                if (data.length > 0) {
                    GlStateManager.func_179128_n((int)5890);
                    GL11.glPopMatrix();
                    GlStateManager.func_179128_n((int)5888);
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179141_d();
                GlStateManager.func_179089_o();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            }
        }
        return geo;
    }

    public static void enableBlockShaderVBOs() {
        GLCompat.vertexAttribPointer(0, 3, 5126, false, 32, 0L);
        GLCompat.enableVertexAttribArray(0);
        GLCompat.vertexAttribPointer(1, 4, 5121, true, 32, 12L);
        GLCompat.enableVertexAttribArray(1);
        GLCompat.vertexAttribPointer(3, 2, 5126, false, 32, 16L);
        GLCompat.enableVertexAttribArray(3);
        GLCompat.vertexAttribPointer(4, 2, 5123, true, 32, 24L);
        GLCompat.enableVertexAttribArray(4);
        GLCompat.vertexAttribPointer(5, 2, 5123, true, 32, 28L);
        GLCompat.enableVertexAttribArray(5);
    }

    public static void disableBlockShaderVBOs() {
        GLCompat.disableVertexAttribArray(0);
        GLCompat.disableVertexAttribArray(1);
        GLCompat.disableVertexAttribArray(3);
        GLCompat.disableVertexAttribArray(4);
        GLCompat.disableVertexAttribArray(5);
    }

    public static AxisAlignedBB getBox(Vec3d a, Vec3d b, Vec3d c) {
        double x = Math.max(Math.max(Math.abs(a.field_72450_a), Math.abs(b.field_72450_a)), Math.abs(c.field_72450_a));
        double y = Math.max(Math.max(Math.abs(a.field_72448_b), Math.abs(b.field_72448_b)), Math.abs(c.field_72448_b));
        double z = Math.max(Math.max(Math.abs(a.field_72449_c), Math.abs(b.field_72449_c)), Math.abs(c.field_72449_c));
        return new AxisAlignedBB(-x, -y, -z, x, y, z);
    }

    public static Matrix3f normalToMat(Vec3d normal, float roll) {
        Vec3d euler = BobMathUtil.getEulerAngles(normal);
        return BakedModelUtil.eulerToMat((float)Math.toRadians(euler.field_72450_a), (float)Math.toRadians(euler.field_72448_b + 90.0), roll);
    }

    public static Matrix3f eulerToMat(float yaw, float pitch, float roll) {
        Matrix3f mY = new Matrix3f();
        mY.rotY(-yaw);
        Matrix3f mP = new Matrix3f();
        mP.rotX(pitch);
        Matrix3f mR = new Matrix3f();
        mR.rotZ(roll);
        mR.mul(mP);
        mR.mul(mY);
        return mR;
    }

    public static List<Triangle> triangulateBlockModel(IBakedModel b, IBlockState state, long rand, float offsetX, float offsetY, float offsetZ) {
        return BakedModelUtil.triangulateBlockModel(null, null, b, state, rand, offsetX, offsetY, offsetZ, false);
    }

    public static List<Triangle> triangulateBlockModel(World world, BlockPos pos, IBakedModel b, IBlockState state, long rand, float offsetX, float offsetY, float offsetZ, boolean checkSides) {
        ArrayList<Triangle> tris = new ArrayList<Triangle>();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, b, state, pos, buffer, true);
        buffer.func_178977_d();
        IntBuffer buf = buffer.func_178966_f().asIntBuffer();
        int[] vertexData = new int[DefaultVertexFormats.field_176600_a.func_181719_f() * 4];
        for (int i = 0; i < buf.limit(); i += DefaultVertexFormats.field_176600_a.func_181719_f() * 4) {
            buf.get(vertexData);
            Vertex v0 = new Vertex(vertexData, 0, offsetX, offsetY, offsetZ);
            Vertex v1 = new Vertex(vertexData, 1, offsetX, offsetY, offsetZ);
            Vertex v2 = new Vertex(vertexData, 2, offsetX, offsetY, offsetZ);
            Vertex v3 = new Vertex(vertexData, 3, offsetX, offsetY, offsetZ);
            tris.add(new Triangle(v0, v1, v2));
            tris.add(new Triangle(v2, v3, v0));
        }
        return tris;
    }

    public static Triangle[][] planeClipTriangle(Triangle t, float[] plane) {
        boolean p3;
        Triangle[][] clipped = new Triangle[2][2];
        clipped[0] = new Triangle[]{null, null};
        clipped[1] = new Triangle[]{null, null};
        boolean p1 = t.v1.pos.field_72450_a * (double)plane[0] + t.v1.pos.field_72448_b * (double)plane[1] + t.v1.pos.field_72449_c * (double)plane[2] + (double)plane[3] > 0.0;
        boolean p2 = t.v2.pos.field_72450_a * (double)plane[0] + t.v2.pos.field_72448_b * (double)plane[1] + t.v2.pos.field_72449_c * (double)plane[2] + (double)plane[3] > 0.0;
        boolean bl = p3 = t.v3.pos.field_72450_a * (double)plane[0] + t.v3.pos.field_72448_b * (double)plane[1] + t.v3.pos.field_72449_c * (double)plane[2] + (double)plane[3] > 0.0;
        if (p1 && p2 && p3) {
            clipped[0][0] = t;
        } else if (!(p1 || p2 || p3)) {
            clipped[1][0] = t;
        } else if (p1 ^ p2 ^ p3) {
            Vertex c;
            Vertex b;
            Vertex a;
            if (p1) {
                a = t.v1;
                b = t.v2;
                c = t.v3;
            } else if (p2) {
                a = t.v2;
                b = t.v3;
                c = t.v1;
            } else {
                a = t.v3;
                b = t.v1;
                c = t.v2;
            }
            Vec3d rAB = b.pos.func_178788_d(a.pos);
            Vec3d rAC = c.pos.func_178788_d(a.pos);
            float interceptAB = (float)BakedModelUtil.rayPlaneIntercept(a.pos, rAB, plane);
            float interceptAC = (float)BakedModelUtil.rayPlaneIntercept(a.pos, rAC, plane);
            Vertex d = a.lerp(b, interceptAB);
            Vertex e = a.lerp(c, interceptAC);
            clipped[1][0] = new Triangle(d, b, e);
            clipped[1][1] = new Triangle(b, c, e);
            clipped[0][0] = new Triangle(a, d, e);
        } else {
            Vertex c;
            Vertex b;
            Vertex a;
            if (!p1) {
                a = t.v1;
                b = t.v2;
                c = t.v3;
            } else if (!p2) {
                a = t.v2;
                b = t.v3;
                c = t.v1;
            } else {
                a = t.v3;
                b = t.v1;
                c = t.v2;
            }
            Vec3d rAB = b.pos.func_178788_d(a.pos);
            Vec3d rAC = c.pos.func_178788_d(a.pos);
            float interceptAB = (float)BakedModelUtil.rayPlaneIntercept(a.pos, rAB, plane);
            float interceptAC = (float)BakedModelUtil.rayPlaneIntercept(a.pos, rAC, plane);
            Vertex d = a.lerp(b, interceptAB);
            Vertex e = a.lerp(c, interceptAC);
            clipped[0][0] = new Triangle(d, b, e);
            clipped[0][1] = new Triangle(b, c, e);
            clipped[1][0] = new Triangle(a, d, e);
        }
        return clipped;
    }

    public static double rayPlaneIntercept(Vec3d start, Vec3d ray, float[] plane) {
        double num = -((double)plane[0] * start.field_72450_a + (double)plane[1] * start.field_72448_b + (double)plane[2] * start.field_72449_c + (double)plane[3]);
        double denom = (double)plane[0] * ray.field_72450_a + (double)plane[1] * ray.field_72448_b + (double)plane[2] * ray.field_72449_c;
        return num / denom;
    }

    public static enum DecalType {
        REGULAR,
        VBO,
        FLOW;

    }

    public static class Triangle {
        public Vertex v1;
        public Vertex v2;
        public Vertex v3;

        public Triangle(Vertex v1, Vertex v2, Vertex v3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }

        public Vertex[] vertices() {
            return new Vertex[]{this.v1, this.v2, this.v3};
        }
    }

    public static class Vertex {
        public Vec3d pos;
        public float a;
        public float r;
        public float g;
        public float b;
        public float u;
        public float v;
        public float lmapU;
        public float lmapV;

        public Vertex(int[] vertexData, int offset2, float oX, float oY, float oZ) {
            float x = Float.intBitsToFloat(vertexData[0 + (offset2 *= 7)]) + oX;
            float y = Float.intBitsToFloat(vertexData[1 + offset2]) + oY;
            float z = Float.intBitsToFloat(vertexData[2 + offset2]) + oZ;
            this.pos = new Vec3d((double)x, (double)y, (double)z);
            int color = vertexData[3 + offset2];
            this.a = (float)(color >> 24 & 0xFF) / 255.0f;
            this.b = (float)(color >> 16 & 0xFF) / 255.0f;
            this.g = (float)(color >> 8 & 0xFF) / 255.0f;
            this.r = (float)(color & 0xFF) / 255.0f;
            this.u = Float.intBitsToFloat(vertexData[4 + offset2]);
            this.v = Float.intBitsToFloat(vertexData[5 + offset2]);
            int i = vertexData[6 + offset2];
            int j = i >>> 16 & 0xFFFF;
            int k = i & 0xFFFF;
            this.lmapU = (float)j / 255.0f;
            this.lmapV = (float)k / 255.0f;
        }

        public Vertex() {
        }

        public Vertex lerp(Vertex other, float amount) {
            Vertex l = new Vertex();
            l.pos = this.pos.func_178787_e(other.pos.func_178788_d(this.pos).func_186678_a((double)amount));
            l.a = this.a + (other.a - this.a) * amount;
            l.r = this.r + (other.r - this.r) * amount;
            l.g = this.g + (other.g - this.g) * amount;
            l.b = this.b + (other.b - this.b) * amount;
            l.u = this.u + (other.u - this.u) * amount;
            l.v = this.v + (other.v - this.v) * amount;
            l.lmapU = this.lmapU + (other.lmapU - this.lmapU) * amount;
            l.lmapV = this.lmapV + (other.lmapV - this.lmapV) * amount;
            return l;
        }
    }
}

