/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.physics;

import com.hbm.main.ClientProxy;
import com.hbm.physics.AABBCollider;
import com.hbm.physics.Collider;
import com.hbm.physics.Contact;
import com.hbm.physics.ContactManifold;
import com.hbm.physics.GJK;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.BobMathUtil;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class RigidBody {
    public static final Vec3[] cardinals = new Vec3[]{new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), new Vec3(0.0, 0.0, 1.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, -1.0, 0.0), new Vec3(0.0, 0.0, -1.0)};
    public static final RigidBody DUMMY = new RigidBody(null){

        @Override
        public void solveContacts(float dt) {
        }

        @Override
        public void impulse(Vec3 force, Vec3 position) {
        }

        @Override
        public void updateOrientation() {
        }

        @Override
        public void updateGlobalCentroidFromPosition() {
        }

        @Override
        public void updatePositionFromGlobalCentroid() {
        }

        @Override
        public void doTimeStep(float dt) {
        }

        @Override
        public void addColliders(Collider ... collide) {
        }

        @Override
        public Vec3 globalToLocalPos(Vec3 pos) {
            return pos;
        }

        @Override
        public Vec3 localToGlobalPos(Vec3 pos) {
            return pos;
        }

        @Override
        public Vec3 globalToLocalVec(Vec3 vec) {
            return vec;
        }

        @Override
        public Vec3 localToGlobalVec(Vec3 vec) {
            return vec;
        }

        @Override
        public void addLinearVelocity(Vec3 v) {
        }

        @Override
        public void addAngularVelocity(Vec3 v) {
        }

        @Override
        public void addContact(Contact c) {
        }
    };
    public World world;
    public AxisAlignedBB boundingBox;
    public List<Collider> colliders = new ArrayList<Collider>();
    public List<AxisAlignedBB> colliderBoundingBoxes = new ArrayList<AxisAlignedBB>();
    public Vec3 position = new Vec3(0.0, 0.0, 0.0);
    public Vec3 globalCentroid;
    public Matrix3f rotation = new Matrix3f();
    public Matrix3f inv_rotation;
    public Vec3 prevPosition = new Vec3(0.0, 0.0, 0.0);
    public Quat4f prevRotation = new Quat4f();
    public Vec3 linearVelocity = new Vec3(0.0, 0.0, 0.0);
    public Vec3 angularVelocity = new Vec3(0.0, 0.0, 0.0);
    public Vec3 force = new Vec3(0.0, 0.0, 0.0);
    public Vec3 torque = new Vec3(0.0, 0.0, 0.0);
    public float mass;
    public float inv_mass;
    public Matrix3f localInertiaTensor;
    public Matrix3f inv_localInertiaTensor;
    public Matrix3f inv_globalInertiaTensor;
    public float friction = 0.5f;
    public float restitution = 0.0f;
    public Vec3 localCentroid;
    public ContactManifold contacts = new ContactManifold();

    public RigidBody(World w) {
        this.world = w;
        this.rotation.setIdentity();
    }

    public RigidBody(World w, double x, double y, double z) {
        this(w);
        this.position = new Vec3(x, y, z);
    }

    public void minecraftTimestep() {
        this.setPrevData();
        int timeStepSubDiv = 8;
        float step = 0.05f / (float)timeStepSubDiv;
        for (int i = 0; i < timeStepSubDiv; ++i) {
            this.doTimeStep(step);
        }
    }

    public void doTimeStep(float dt) {
        this.contacts.update();
        Object bestInfo = null;
        Object a = null;
        AABBCollider b = null;
        List l = this.world.func_184144_a(null, this.boundingBox);
        for (AxisAlignedBB box : l) {
            for (int i = 0; i < this.colliders.size(); ++i) {
                Collider c = this.colliders.get(i);
                if (!this.colliderBoundingBoxes.get(i).func_72326_a(box)) continue;
                b = new AABBCollider(box);
                GJK.GJKInfo info = GJK.colliding(this, null, c, b);
                if (info.result != GJK.Result.COLLIDING) continue;
                this.contacts.addContact(new Contact(this, null, c, b, info));
            }
        }
        this.solveContacts(dt);
        this.integrateVelocityAndPosition(dt);
    }

    public void integrateVelocityAndPosition(float dt) {
        this.linearVelocity = this.linearVelocity.add(this.force.mult(this.inv_mass * dt));
        this.angularVelocity = this.angularVelocity.add(this.torque.mult(dt).matTransform(this.inv_globalInertiaTensor));
        this.force.setComponents(0.0, 0.0, 0.0);
        this.torque.setComponents(0.0, 0.0, 0.0);
        this.globalCentroid = this.globalCentroid.add(this.linearVelocity.mult(dt));
        if (this.angularVelocity.lengthSquared() > 0.0) {
            Vec3 axis = this.angularVelocity.normalize();
            double angle = this.angularVelocity.length() * (double)dt;
            Matrix3f turn = new Matrix3f();
            turn.set(new AxisAngle4f((float)axis.xCoord, (float)axis.yCoord, (float)axis.zCoord, (float)angle));
            turn.mul(this.rotation);
            this.rotation = turn;
            this.updateOrientation();
        }
        this.updatePositionFromGlobalCentroid();
        this.updateAABBs();
        this.addLinearVelocity(new Vec3(0.0, -9.81 * (double)dt, 0.0));
    }

    public void setPrevData() {
        this.prevPosition.set(this.position);
        RigidBody.setFromMat(this.prevRotation, this.rotation);
    }

    public void addContact(Contact c) {
        this.contacts.addContact(c);
    }

    public void solveContacts(float dt) {
        for (int j = 0; j < this.contacts.contactCount; ++j) {
            this.contacts.contacts[j].init(dt);
        }
        int velocityIterations = 4;
        for (int i = 0; i < velocityIterations; ++i) {
            for (int j = 0; j < this.contacts.contactCount; ++j) {
                this.contacts.contacts[j].solve(dt);
            }
        }
    }

    public Vec3 localToGlobalPos(Vec3 pos) {
        return pos.matTransform(this.rotation).add(this.position);
    }

    public Vec3 globalToLocalPos(Vec3 pos) {
        return pos.subtract(this.position).matTransform(this.inv_rotation);
    }

    public Vec3 localToGlobalVec(Vec3 vec) {
        return vec.matTransform(this.rotation);
    }

    public Vec3 globalToLocalVec(Vec3 vec) {
        return vec.matTransform(this.inv_rotation);
    }

    public void addLinearVelocity(Vec3 v) {
        this.linearVelocity = this.linearVelocity.add(v);
    }

    public void addAngularVelocity(Vec3 v) {
        this.angularVelocity = this.angularVelocity.add(v);
    }

    public void impulse(Vec3 force, Vec3 position) {
        this.force = this.force.add(force);
        this.torque = this.torque.add(position.subtract(this.globalCentroid).crossProduct(force));
    }

    public void impulseVelocity(Vec3 force, Vec3 position) {
        this.linearVelocity = this.linearVelocity.add(force.mult(this.inv_mass));
        this.angularVelocity = this.angularVelocity.add(position.subtract(this.globalCentroid).crossProduct(force).matTransform(this.inv_globalInertiaTensor));
    }

    public void impulseVelocityDirect(Vec3 force, Vec3 position) {
        this.linearVelocity = this.linearVelocity.add(force);
        this.angularVelocity = this.angularVelocity.add(position.subtract(this.globalCentroid).crossProduct(force));
    }

    public void updateOrientation() {
        Quat4f quat = new Quat4f();
        float epsilon = 1.0E-5f;
        RigidBody.setFromMat(quat, this.rotation);
        quat.normalize();
        BobMathUtil.matrixFromQuat(this.rotation, quat);
        this.inv_rotation = (Matrix3f)this.rotation.clone();
        this.inv_rotation.transpose();
        this.inv_globalInertiaTensor.set(this.inv_rotation);
        this.inv_globalInertiaTensor.mul(this.inv_localInertiaTensor);
        this.inv_globalInertiaTensor.mul(this.rotation);
    }

    public void updatePositionFromGlobalCentroid() {
        this.position = this.globalCentroid.add(this.localCentroid.mult(-1.0f).matTransform(this.rotation));
    }

    public void updateGlobalCentroidFromPosition() {
        this.globalCentroid = this.localCentroid.matTransform(this.rotation).add(this.position);
    }

    public void updateAABBs() {
        this.colliderBoundingBoxes.clear();
        double tMaxZ = -1.7976931348623157E308;
        double tMaxY = -1.7976931348623157E308;
        double tMaxX = -1.7976931348623157E308;
        double tMinZ = Double.MAX_VALUE;
        double tMinY = Double.MAX_VALUE;
        double tMinX = Double.MAX_VALUE;
        for (Collider c : this.colliders) {
            double maxX = GJK.localSupport((RigidBody)this, (Collider)c, (Vec3)RigidBody.cardinals[0]).xCoord;
            double maxY = GJK.localSupport((RigidBody)this, (Collider)c, (Vec3)RigidBody.cardinals[1]).yCoord;
            double maxZ = GJK.localSupport((RigidBody)this, (Collider)c, (Vec3)RigidBody.cardinals[2]).zCoord;
            double minX = GJK.localSupport((RigidBody)this, (Collider)c, (Vec3)RigidBody.cardinals[3]).xCoord;
            double minY = GJK.localSupport((RigidBody)this, (Collider)c, (Vec3)RigidBody.cardinals[4]).yCoord;
            double minZ = GJK.localSupport((RigidBody)this, (Collider)c, (Vec3)RigidBody.cardinals[5]).zCoord;
            this.colliderBoundingBoxes.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
            tMaxX = Math.max(tMaxX, maxX);
            tMaxY = Math.max(tMaxY, maxY);
            tMaxZ = Math.max(tMaxZ, maxZ);
            tMinX = Math.min(tMinX, minX);
            tMinY = Math.min(tMinY, minY);
            tMinZ = Math.min(tMinZ, minZ);
        }
        this.boundingBox = new AxisAlignedBB(tMinX, tMinY, tMinZ, tMaxX, tMaxY, tMaxZ);
    }

    public void addColliders(Collider ... collide) {
        this.colliders.addAll(Arrays.asList(collide));
        this.localCentroid = new Vec3(0.0, 0.0, 0.0);
        this.mass = 0.0f;
        for (Collider c : this.colliders) {
            this.mass += c.mass;
            this.localCentroid = this.localCentroid.add(c.localCentroid.mult(c.mass));
        }
        this.inv_mass = 1.0f / this.mass;
        this.localCentroid = this.localCentroid.mult(this.inv_mass);
        this.localInertiaTensor = new Matrix3f();
        for (Collider c : this.colliders) {
            Vec3 colliderToLocal = this.localCentroid.subtract(c.localCentroid);
            double lenSquared = colliderToLocal.dotProduct(colliderToLocal);
            Matrix3f outerProduct = colliderToLocal.outerProduct(colliderToLocal);
            Matrix3f colliderToLocalMat = new Matrix3f();
            colliderToLocalMat.setIdentity();
            colliderToLocalMat.mul((float)lenSquared);
            colliderToLocalMat.sub(outerProduct);
            colliderToLocalMat.mul(c.mass);
            Matrix3f cLocalIT = (Matrix3f)c.localInertiaTensor.clone();
            cLocalIT.add(colliderToLocalMat);
            this.localInertiaTensor.add(cLocalIT);
        }
        this.inv_localInertiaTensor = new Matrix3f();
        this.inv_localInertiaTensor.set(this.localInertiaTensor);
        this.inv_localInertiaTensor.invert();
        this.inv_globalInertiaTensor = new Matrix3f();
        this.updateOrientation();
        this.updateGlobalCentroidFromPosition();
        this.prevPosition = this.position;
        this.updateAABBs();
    }

    @SideOnly(value=Side.CLIENT)
    public void doGlTransform(Vec3 playerPos, float partialTicks) {
        FloatBuffer buf = ClientProxy.AUX_GL_BUFFER;
        Quat4f quat = new Quat4f();
        RigidBody.setFromMat(quat, this.rotation);
        quat.interpolate(this.prevRotation, 1.0f - partialTicks);
        quat.normalize();
        Matrix3f rotation = new Matrix3f();
        BobMathUtil.matrixFromQuat(rotation, quat);
        buf.put(0, rotation.m00);
        buf.put(1, rotation.m10);
        buf.put(2, rotation.m20);
        buf.put(3, 0.0f);
        buf.put(4, rotation.m01);
        buf.put(5, rotation.m11);
        buf.put(6, rotation.m21);
        buf.put(7, 0.0f);
        buf.put(8, rotation.m02);
        buf.put(9, rotation.m12);
        buf.put(10, rotation.m22);
        buf.put(11, 0.0f);
        Vec3 pos = this.prevPosition.add(this.position.subtract(this.prevPosition).mult(partialTicks)).subtract(playerPos);
        buf.put(12, (float)pos.xCoord);
        buf.put(13, (float)pos.yCoord);
        buf.put(14, (float)pos.zCoord);
        buf.put(15, 1.0f);
        GL11.glMultMatrix((FloatBuffer)buf);
        buf.rewind();
    }

    public static void setFromMat(Quat4f q, Matrix3f mat) {
        RigidBody.setFromMat(q, mat.m00, mat.m01, mat.m02, mat.m10, mat.m11, mat.m12, mat.m20, mat.m21, mat.m22);
    }

    public static void setFromMat(Quat4f q, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float tr = m00 + m11 + m22;
        if ((double)tr >= 0.0) {
            float s = (float)Math.sqrt((double)tr + 1.0);
            q.w = s * 0.5f;
            s = 0.5f / s;
            q.x = (m21 - m12) * s;
            q.y = (m02 - m20) * s;
            q.z = (m10 - m01) * s;
        } else {
            float max = Math.max(Math.max(m00, m11), m22);
            if (max == m00) {
                float s = (float)Math.sqrt((double)(m00 - (m11 + m22)) + 1.0);
                q.x = s * 0.5f;
                s = 0.5f / s;
                q.y = (m01 + m10) * s;
                q.z = (m20 + m02) * s;
                q.w = (m21 - m12) * s;
            } else if (max == m11) {
                float s = (float)Math.sqrt((double)(m11 - (m22 + m00)) + 1.0);
                q.y = s * 0.5f;
                s = 0.5f / s;
                q.z = (m12 + m21) * s;
                q.x = (m01 + m10) * s;
                q.w = (m02 - m20) * s;
            } else {
                float s = (float)Math.sqrt((double)(m22 - (m00 + m11)) + 1.0);
                q.z = s * 0.5f;
                s = 0.5f / s;
                q.x = (m20 + m02) * s;
                q.y = (m12 + m21) * s;
                q.w = (m10 - m01) * s;
            }
        }
    }

    public void renderDebugInfo(Vec3 offset2, float partialTicks) {
        GL11.glPushMatrix();
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179097_i();
        for (Contact c : this.contacts.contacts) {
            if (c == null) continue;
            buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            Vec3 normal = c.normal.mult(0.5f);
            Vec3 globalA = c.globalA.subtract(offset2);
            Vec3 globalB = c.globalB.subtract(offset2);
            buf.func_181662_b(globalA.xCoord, globalA.yCoord, globalA.zCoord).func_181669_b(1, 0, 0, 1).func_181675_d();
            buf.func_181662_b(globalA.xCoord - normal.xCoord, globalA.yCoord - normal.yCoord, globalA.zCoord - normal.zCoord).func_181669_b(1, 0, 0, 1).func_181675_d();
            buf.func_181662_b(globalB.xCoord, globalB.yCoord, globalB.zCoord).func_181669_b(1, 0, 0, 1).func_181675_d();
            buf.func_181662_b(globalB.xCoord + normal.xCoord, globalB.yCoord + normal.yCoord, globalB.zCoord + normal.zCoord).func_181669_b(1, 0, 0, 1).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GL11.glPointSize((float)16.0f);
            buf.func_181668_a(0, DefaultVertexFormats.field_181706_f);
            buf.func_181662_b(globalA.xCoord, globalA.yCoord, globalA.zCoord).func_181669_b(1, 0, 0, 1).func_181675_d();
            buf.func_181662_b(globalB.xCoord, globalB.yCoord, globalB.zCoord).func_181669_b(1, 0, 0, 1).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.func_179126_j();
        this.doGlTransform(offset2, partialTicks);
        for (Collider c : this.colliders) {
            c.debugRender();
        }
        GL11.glPopMatrix();
    }

    static {
        RigidBody.DUMMY.inv_rotation = (Matrix3f)RigidBody.DUMMY.rotation.clone();
        RigidBody.DUMMY.localInertiaTensor = new Matrix3f();
        RigidBody.DUMMY.inv_localInertiaTensor = new Matrix3f();
        RigidBody.DUMMY.inv_globalInertiaTensor = new Matrix3f();
        RigidBody.DUMMY.localCentroid = new Vec3(0.0, 0.0, 0.0);
        RigidBody.DUMMY.globalCentroid = new Vec3(0.0, 0.0, 0.0);
    }
}

