/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.physics;

import com.hbm.physics.Collider;
import com.hbm.physics.RigidBody;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class GJK {
    public static final int gjkMaxIterations = 64;
    public static final int epaMaxIterations = 128;
    public static float margin = 0.0f;
    public static Simplex csoSimplex = new Simplex();
    private static List<Mkv[]> faces = new ArrayList<Mkv[]>();
    private static List<Mkv[]> edges = new ArrayList<Mkv[]>();
    private static Vec3[][] features = new Vec3[2][3];

    public static GJKInfo colliding(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b) {
        return GJK.colliding(bodyA, bodyB, a, b, true);
    }

    public static boolean collidesAny(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b) {
        return GJK.colliding(bodyA, bodyB, a, b, false) != null;
    }

    public static GJKInfo colliding(@Nullable RigidBody bodyA, @Nullable RigidBody bodyB, Collider a, Collider b, boolean epa) {
        GJKInfo returnInfo = new GJKInfo();
        csoSimplex.reset();
        Vec3 direction = new Vec3(0.0, 0.0, 1.0);
        Vec3 supportCSO = GJK.doCSOSupport((RigidBody)bodyA, (RigidBody)bodyB, (Collider)a, (Collider)b, (Vec3)direction).v;
        direction = supportCSO.negate();
        block6: for (int iter = 0; iter < 64; ++iter) {
            supportCSO = GJK.doCSOSupport((RigidBody)bodyA, (RigidBody)bodyB, (Collider)a, (Collider)b, (Vec3)direction).v;
            if (supportCSO.dotProduct(direction) < 0.0) {
                returnInfo.result = Result.SEPARATED;
                if (!epa) {
                    return null;
                }
                return returnInfo;
            }
            switch (GJK.csoSimplex.size) {
                case 0: 
                case 1: {
                    continue block6;
                }
                case 2: {
                    Vec3 ab = GJK.csoSimplex.points[1].v.subtract(GJK.csoSimplex.points[0].v);
                    Vec3 ao = GJK.csoSimplex.points[0].v.negate();
                    if (ab.dotProduct(ao) > 0.0) {
                        direction = ab.crossProduct(ao).crossProduct(ab);
                        continue block6;
                    }
                    GJK.csoSimplex.points[1] = null;
                    --GJK.csoSimplex.size;
                    direction = GJK.csoSimplex.points[0].v.mult(-1.0f);
                    continue block6;
                }
                case 3: {
                    Vec3 ab = GJK.csoSimplex.points[1].v.subtract(GJK.csoSimplex.points[0].v);
                    Vec3 ac = GJK.csoSimplex.points[2].v.subtract(GJK.csoSimplex.points[0].v);
                    Vec3 abc = ab.crossProduct(ac);
                    Vec3 ao = GJK.csoSimplex.points[0].v.negate();
                    direction = GJK.triangleCase(ab, ac, abc, ao);
                    continue block6;
                }
                case 4: {
                    Vec3 ab = GJK.csoSimplex.points[1].v.subtract(GJK.csoSimplex.points[0].v);
                    Vec3 ac = GJK.csoSimplex.points[2].v.subtract(GJK.csoSimplex.points[0].v);
                    Vec3 ad = GJK.csoSimplex.points[3].v.subtract(GJK.csoSimplex.points[0].v);
                    Vec3 ao = GJK.csoSimplex.points[0].v.negate();
                    Vec3 dir = GJK.tetraCase(ab, ac, ad, ao);
                    if (dir == null) {
                        if (epa) {
                            GJK.EPA(bodyA, bodyB, a, b, returnInfo);
                        }
                        return returnInfo;
                    }
                    direction = dir;
                }
            }
        }
        returnInfo.result = Result.GJK_FAILED;
        return returnInfo;
    }

    public static Vec3 triangleCase(Vec3 ab, Vec3 ac, Vec3 abc, Vec3 ao) {
        if (abc.crossProduct(ac).dotProduct(ao) > 0.0) {
            if (ac.dotProduct(ao) > 0.0) {
                GJK.csoSimplex.points[1] = GJK.csoSimplex.points[2];
                GJK.csoSimplex.points[2] = null;
                --GJK.csoSimplex.size;
                return ac.crossProduct(ao).crossProduct(ac);
            }
            if (ab.dotProduct(ao) > 0.0) {
                GJK.csoSimplex.points[2] = null;
                --GJK.csoSimplex.size;
                return ab.crossProduct(ao).crossProduct(ab);
            }
            GJK.csoSimplex.points[1] = null;
            GJK.csoSimplex.points[2] = null;
            GJK.csoSimplex.size -= 2;
            return ao;
        }
        if (ab.crossProduct(abc).dotProduct(ao) > 0.0) {
            if (ab.dotProduct(ao) > 0.0) {
                GJK.csoSimplex.points[2] = null;
                --GJK.csoSimplex.size;
                return ab.crossProduct(ao).crossProduct(ab);
            }
            GJK.csoSimplex.points[1] = null;
            GJK.csoSimplex.points[2] = null;
            GJK.csoSimplex.size -= 2;
            return ao;
        }
        if (abc.dotProduct(ao) > 0.0) {
            return abc;
        }
        Mkv tmp = GJK.csoSimplex.points[2];
        GJK.csoSimplex.points[2] = GJK.csoSimplex.points[1];
        GJK.csoSimplex.points[1] = tmp;
        return abc.negate();
    }

    public static Vec3 tetraCase(Vec3 ab, Vec3 ac, Vec3 ad, Vec3 ao) {
        if (ab.crossProduct(ac).dotProduct(ao) > 0.0) {
            GJK.csoSimplex.points[3] = null;
            --GJK.csoSimplex.size;
            return GJK.triangleCase(ab, ac, ab.crossProduct(ac), ao);
        }
        if (ac.crossProduct(ad).dotProduct(ao) > 0.0) {
            GJK.csoSimplex.points[1] = GJK.csoSimplex.points[2];
            GJK.csoSimplex.points[2] = GJK.csoSimplex.points[3];
            GJK.csoSimplex.points[3] = null;
            --GJK.csoSimplex.size;
            return GJK.triangleCase(ac, ad, ac.crossProduct(ad), ao);
        }
        if (ad.crossProduct(ab).dotProduct(ao) > 0.0) {
            GJK.csoSimplex.points[2] = GJK.csoSimplex.points[1];
            GJK.csoSimplex.points[1] = GJK.csoSimplex.points[3];
            GJK.csoSimplex.points[3] = null;
            --GJK.csoSimplex.size;
            return GJK.triangleCase(ad, ab, ad.crossProduct(ab), ao);
        }
        return null;
    }

    public static Mkv doCSOSupport(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b, Vec3 direction) {
        Vec3 supportCSO = new Vec3(0.0, 0.0, 0.0);
        GJK.csoSupport(bodyA, bodyB, a, b, direction, supportCSO);
        Mkv vert = new Mkv(supportCSO, direction);
        csoSimplex.push_back(vert);
        return vert;
    }

    public static void csoSupport(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b, Vec3 dir, Vec3 supportCSO) {
        supportCSO.set(GJK.localSupport(bodyA, a, dir).subtract(GJK.localSupport(bodyB, b, dir.negate())));
    }

    public static Vec3 localSupport(RigidBody body, Collider c, Vec3 worldDir) {
        if (body != null) {
            Vec3 localDir = body.globalToLocalVec(worldDir);
            if (margin != 0.0f) {
                localDir = localDir.normalize();
                return body.localToGlobalPos(c.support(localDir).add(localDir.mult(margin)));
            }
            return body.localToGlobalPos(c.support(localDir));
        }
        if (margin != 0.0f) {
            worldDir = worldDir.normalize();
            return c.support(worldDir).add(worldDir.mult(margin));
        }
        return c.support(worldDir);
    }

    public static void EPA(RigidBody bodyA, RigidBody bodyB, Collider a, Collider b, GJKInfo info) {
        faces.add(GJK.buildFace(GJK.csoSimplex.points[0], GJK.csoSimplex.points[1], GJK.csoSimplex.points[2]));
        faces.add(GJK.buildFace(GJK.csoSimplex.points[0], GJK.csoSimplex.points[2], GJK.csoSimplex.points[3]));
        faces.add(GJK.buildFace(GJK.csoSimplex.points[0], GJK.csoSimplex.points[3], GJK.csoSimplex.points[1]));
        faces.add(GJK.buildFace(GJK.csoSimplex.points[1], GJK.csoSimplex.points[2], GJK.csoSimplex.points[3]));
        for (int iter = 0; iter < 128; ++iter) {
            Mkv[] closestFace = null;
            double smallestDist = Double.MAX_VALUE;
            for (Mkv[] face : faces) {
                double lenSq = GJK.originDistToPlaneSq(face);
                if (!(lenSq < smallestDist)) continue;
                smallestDist = lenSq;
                closestFace = face;
            }
            Mkv support = GJK.doCSOSupport(bodyA, bodyB, a, b, closestFace[3].v);
            float epsilon = 1.0E-5f;
            if (GJK.distToPlaneSq(closestFace, support.v) < (double)1.0E-5f) {
                info.result = Result.COLLIDING;
                Vec3 separation = GJK.planeProjectOrigin(closestFace);
                info.normal = separation.normalize();
                info.depth = (float)separation.length();
                for (int i = 0; i < 3; ++i) {
                    GJK.features[0][i] = GJK.localSupport(bodyA, a, closestFace[i].r);
                    GJK.features[1][i] = GJK.localSupport(bodyB, b, closestFace[i].r.negate());
                }
                Vec3 bCoords = GJK.barycentricCoords(closestFace, separation);
                info.contactPointA = new Vec3(GJK.features[0][0].xCoord * bCoords.xCoord + GJK.features[0][1].xCoord * bCoords.yCoord + GJK.features[0][2].xCoord * bCoords.zCoord, GJK.features[0][0].yCoord * bCoords.xCoord + GJK.features[0][1].yCoord * bCoords.yCoord + GJK.features[0][2].yCoord * bCoords.zCoord, GJK.features[0][0].zCoord * bCoords.xCoord + GJK.features[0][1].zCoord * bCoords.yCoord + GJK.features[0][2].zCoord * bCoords.zCoord);
                info.contactPointB = new Vec3(GJK.features[1][0].xCoord * bCoords.xCoord + GJK.features[1][1].xCoord * bCoords.yCoord + GJK.features[1][2].xCoord * bCoords.zCoord, GJK.features[1][0].yCoord * bCoords.xCoord + GJK.features[1][1].yCoord * bCoords.yCoord + GJK.features[1][2].yCoord * bCoords.zCoord, GJK.features[1][0].zCoord * bCoords.xCoord + GJK.features[1][1].zCoord * bCoords.yCoord + GJK.features[1][2].zCoord * bCoords.zCoord);
                faces.clear();
                return;
            }
            Iterator<Mkv[]> itr = faces.iterator();
            while (itr.hasNext()) {
                Mkv[] face = itr.next();
                if (!(face[3].v.dotProduct(support.v.subtract(face[0].v)) > 0.0)) continue;
                itr.remove();
                Mkv[] edge = new Mkv[]{face[1], face[0]};
                if (!GJK.removeEdge(edge)) {
                    edge[0] = face[0];
                    edge[1] = face[1];
                    edges.add(edge);
                }
                if (!GJK.removeEdge(edge = new Mkv[]{face[2], face[1]})) {
                    edge[0] = face[1];
                    edge[1] = face[2];
                    edges.add(edge);
                }
                if (GJK.removeEdge(edge = new Mkv[]{face[0], face[2]})) continue;
                edge[0] = face[2];
                edge[1] = face[0];
                edges.add(edge);
            }
            for (Mkv[] edge : edges) {
                faces.add(GJK.buildFace(edge[0], edge[1], support));
            }
            edges.clear();
        }
        faces.clear();
        info.result = Result.EPA_FAILED;
    }

    public static boolean removeEdge(Mkv[] edge) {
        Iterator<Mkv[]> itr = edges.iterator();
        while (itr.hasNext()) {
            Mkv[] edge2 = itr.next();
            if (edge[0] != edge2[0] || edge[1] != edge2[1]) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public static Vec3 planeProjectOrigin(Mkv[] face) {
        Vec3 point = face[0].v.negate();
        double dot = face[3].v.dotProduct(point);
        return face[3].v.mult((float)dot).negate();
    }

    public static double distToPlaneSq(Mkv[] face, Vec3 point) {
        double dot = face[3].v.dotProduct(point.subtract(face[0].v));
        Vec3 proj = face[3].v.mult((float)dot);
        return proj.lengthSquared();
    }

    public static double originDistToPlaneSq(Mkv[] face) {
        double dot = face[0].v.dotProduct(face[3].v);
        Vec3 proj = face[3].v.mult((float)dot);
        return proj.lengthSquared();
    }

    public static Mkv[] buildFace(Mkv a, Mkv b, Mkv c) {
        Vec3 ab = b.v.subtract(a.v);
        Vec3 ac = c.v.subtract(a.v);
        Vec3 ao = a.v.negate();
        Vec3 normal = ab.crossProduct(ac).normalize();
        if (normal.dotProduct(ao) < 0.0) {
            return new Mkv[]{a, b, c, new Mkv(normal, null)};
        }
        return new Mkv[]{a, c, b, new Mkv(normal.negate(), null)};
    }

    public static Vec3 barycentricCoords(Mkv[] face, Vec3 point) {
        double u = face[1].v.subtract(point).crossProduct(face[2].v.subtract(point)).length();
        double v = face[0].v.subtract(point).crossProduct(face[2].v.subtract(point)).length();
        double w = face[0].v.subtract(point).crossProduct(face[1].v.subtract(point)).length();
        double uvw = u + v + w;
        return new Vec3(u, v, w).multd(1.0 / uvw);
    }

    public static class GJKInfo {
        public Result result;
        public Vec3 normal;
        public float depth;
        public Vec3 contactPointA;
        public Vec3 contactPointB;
    }

    public static class Simplex {
        public int size = 0;
        public Mkv[] points = new Mkv[4];

        public void push_back(Mkv vec) {
            for (int i = Math.min(this.size, 2); i >= 0; --i) {
                this.points[i + 1] = this.points[i];
            }
            this.points[0] = vec;
            ++this.size;
            if (this.size > 4) {
                this.size = 4;
            }
        }

        public void reset() {
            this.size = 0;
            for (int i = 0; i < 4; ++i) {
                this.points[i] = null;
            }
        }

        public Simplex copy() {
            Simplex simp = new Simplex();
            simp.size = this.size;
            for (int i = 0; i < 4; ++i) {
                simp.points[i] = this.points[i].copy();
            }
            return simp;
        }
    }

    public static class Mkv {
        public Vec3 v;
        public Vec3 r;

        public Mkv(Vec3 point, Vec3 direction) {
            this.v = point;
            this.r = direction;
        }

        public Mkv copy() {
            return new Mkv(this.v.copy(), this.r.copy());
        }
    }

    public static enum Result {
        COLLIDING,
        SEPARATED,
        GJK_FAILED,
        EPA_FAILED;

    }
}

