/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.lightning_test;

import com.hbm.render.GLCompat;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class TrailRenderer2 {
    public static final int BYTES_PER_VERTEX = 20;
    public static ByteBuffer aux_buf = GLAllocation.func_74524_c((int)512);
    public static int array_buf;
    public static int element_buf;
    public static int vao;
    public static int currentPointCount;
    private static boolean init;
    public static float[] color;

    public static void init() {
        array_buf = GLCompat.genBuffers();
        element_buf = GLCompat.genBuffers();
        vao = GLCompat.genVertexArrays();
        GLCompat.bindVertexArray(vao);
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, array_buf);
        GLCompat.bindBuffer(GLCompat.GL_ELEMENT_ARRAY_BUFFER, element_buf);
        GLCompat.vertexAttribPointer(0, 3, 5126, false, 20, 0L);
        GLCompat.enableVertexAttribArray(0);
        GLCompat.vertexAttribPointer(1, 2, 5123, true, 20, 12L);
        GLCompat.enableVertexAttribArray(1);
        GLCompat.vertexAttribPointer(2, 4, 5121, true, 20, 16L);
        GLCompat.enableVertexAttribArray(2);
        GLCompat.bindVertexArray(0);
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, 0);
        GLCompat.bindBuffer(GLCompat.GL_ELEMENT_ARRAY_BUFFER, 0);
    }

    public static void draw(Vec3d playerPos, List<Vec3d> points, float scale) {
        TrailRenderer2.draw(playerPos, points, scale, false, false, null);
    }

    public static void draw(Vec3d playerPos, List<Vec3d> points, float scale, boolean fadeEnd, boolean fadeEnd2, @Nullable IColorGetter c) {
        TrailRenderer2.generateAndBindVao(playerPos, points, scale, fadeEnd, fadeEnd2, c);
        TrailRenderer2.drawGeneratedVao();
        TrailRenderer2.unbindVao();
    }

    public static void drawGeneratedVao() {
        GL11.glDrawElements((int)4, (int)((currentPointCount - 1) * 12), (int)5125, (long)0L);
    }

    public static void generateAndBindVao(Vec3d playerPos, List<Vec3d> points, float scale, boolean fadeEnd, boolean fadeEnd2, @Nullable IColorGetter c) {
        int i;
        if (!init) {
            init = true;
            TrailRenderer2.init();
        }
        currentPointCount = points.size();
        int size = 20 * (points.size() * 3 + 2);
        if (size > aux_buf.capacity()) {
            aux_buf = GLAllocation.func_74524_c((int)size);
        }
        Vec3d first = points.get(0);
        Vec3d cross = points.get(1).func_178788_d(first).func_72431_c(playerPos.func_178788_d(first)).func_72432_b().func_186678_a((double)(scale * (fadeEnd ? 0.1f : 1.0f)));
        color = c != null ? c.color(0.0f) : new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        TrailRenderer2.putVertex(first.func_178787_e(cross), 0.0f, 1.0f);
        TrailRenderer2.putVertex(first.func_178787_e(cross.func_186678_a(-1.0)), 0.0f, 0.0f);
        for (i = 1; i < points.size(); ++i) {
            Vec3d last = points.get(i - 1);
            Vec3d current = points.get(i);
            Vec3d next = points.get(i);
            if (i < points.size() - 1) {
                next = points.get(i + 1);
            }
            Vec3d toNext = points.get(i).func_178788_d(last);
            Vec3d tangent = next.func_178788_d(last);
            float iN = (float)i / (float)(points.size() - 1);
            float bruh = 1.0f - MathHelper.func_76131_a((float)((iN - 0.8f) * 5.0f), (float)0.0f, (float)1.0f);
            if (fadeEnd) {
                bruh *= MathHelper.func_76131_a((float)(iN * 5.0f), (float)0.0f, (float)1.0f);
            }
            if (!fadeEnd2) {
                bruh = 1.0f;
            }
            cross = tangent.func_72431_c(playerPos.func_178788_d(last)).func_72432_b().func_186678_a((double)scale * Math.max((double)bruh, 0.1));
            float uMiddle = ((float)i - 0.5f) / (float)(points.size() - 1);
            if (c != null) {
                color = c.color(uMiddle);
            }
            TrailRenderer2.putVertex(last.func_178787_e(toNext.func_186678_a(0.5)), uMiddle, 0.5f);
            if (c != null) {
                color = c.color(iN);
            }
            TrailRenderer2.putVertex(current.func_178787_e(cross), iN, 1.0f);
            TrailRenderer2.putVertex(current.func_178787_e(cross.func_186678_a(-1.0)), iN, 0.0f);
        }
        GLCompat.bindVertexArray(vao);
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, array_buf);
        aux_buf.rewind();
        GLCompat.bufferData(GLCompat.GL_ARRAY_BUFFER, aux_buf, GLCompat.GL_DYNAMIC_DRAW);
        for (i = 0; i < points.size() - 1; ++i) {
            int offset2 = i * 3;
            aux_buf.putInt(0 + offset2);
            aux_buf.putInt(2 + offset2);
            aux_buf.putInt(1 + offset2);
            aux_buf.putInt(0 + offset2);
            aux_buf.putInt(3 + offset2);
            aux_buf.putInt(2 + offset2);
            aux_buf.putInt(2 + offset2);
            aux_buf.putInt(3 + offset2);
            aux_buf.putInt(4 + offset2);
            aux_buf.putInt(2 + offset2);
            aux_buf.putInt(4 + offset2);
            aux_buf.putInt(1 + offset2);
        }
        GLCompat.bindBuffer(GLCompat.GL_ELEMENT_ARRAY_BUFFER, element_buf);
        aux_buf.rewind();
        GLCompat.bufferData(GLCompat.GL_ELEMENT_ARRAY_BUFFER, aux_buf, GLCompat.GL_DYNAMIC_DRAW);
        GL11.glVertexPointer((int)3, (int)5126, (int)20, (long)0L);
        GL11.glTexCoordPointer((int)2, (int)5122, (int)20, (long)12L);
        GL11.glColorPointer((int)4, (int)5121, (int)20, (long)16L);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32886);
    }

    public static void unbindVao() {
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32886);
        GLCompat.bindVertexArray(0);
        GLCompat.bindBuffer(GLCompat.GL_ARRAY_BUFFER, 0);
        GLCompat.bindBuffer(GLCompat.GL_ELEMENT_ARRAY_BUFFER, 0);
    }

    private static void putVertex(Vec3d pos, float texU, float texV) {
        aux_buf.putFloat((float)pos.field_72450_a);
        aux_buf.putFloat((float)pos.field_72448_b);
        aux_buf.putFloat((float)pos.field_72449_c);
        aux_buf.putShort((short)(texU * 65535.0f));
        aux_buf.putShort((short)(texV * 65535.0f));
        aux_buf.put((byte)(color[0] * 255.0f));
        aux_buf.put((byte)(color[1] * 255.0f));
        aux_buf.put((byte)(color[2] * 255.0f));
        aux_buf.put((byte)(color[3] * 255.0f));
    }

    static {
        init = false;
        color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    }

    public static interface IColorGetter {
        public float[] color(float var1);
    }
}

