/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.items.ItemEnumMultiColor;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.render.icon.RGBMutatorInterpolatedComponentRemap;
import com.hbm.render.icon.TextureAtlasSpriteMutatable;
import com.hbm.util.EnumUtil;
import com.hbm.util.Function;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWatzPellet
extends ItemEnumMultiColor {
    final boolean isDesaturated;

    public ItemWatzPellet(String s, boolean isDesaturated) {
        super(s, EnumWatzType.class, true, true);
        this.func_77625_d(16);
        this.func_77637_a(MainRegistry.controlTab);
        this.isDesaturated = isDesaturated;
    }

    public static int desaturate(int color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        int avg = (r + g + b) / 3;
        double approach = 0.9;
        double mult = 0.75;
        r -= (int)((double)(r - avg) * approach);
        g -= (int)((double)(g - avg) * approach);
        b -= (int)((double)(b - avg) * approach);
        r = (int)((double)r * mult);
        g = (int)((double)g * mult);
        b = (int)((double)b * mult);
        return r << 16 | g << 8 | b;
    }

    public static double getEnrichment(ItemStack stack) {
        EnumWatzType num = (EnumWatzType)((Object)EnumUtil.grabEnumSafely(EnumWatzType.class, stack.func_77952_i()));
        return ItemWatzPellet.getYield(stack) / num.yield;
    }

    public static double getYield(ItemStack stack) {
        return ItemWatzPellet.getDouble(stack, "yield");
    }

    public static void setYield(ItemStack stack, double yieldv) {
        ItemWatzPellet.setDouble(stack, "yield", yieldv);
    }

    public static void setDouble(ItemStack stack, String key, double yieldv) {
        if (!stack.func_77942_o()) {
            ItemWatzPellet.setNBTDefaults(stack);
        }
        stack.func_77978_p().func_74780_a(key, yieldv);
    }

    public static double getDouble(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            ItemWatzPellet.setNBTDefaults(stack);
        }
        return stack.func_77978_p().func_74769_h(key);
    }

    private static void setNBTDefaults(ItemStack stack) {
        EnumWatzType num = (EnumWatzType)((Object)EnumUtil.grabEnumSafely(EnumWatzType.class, stack.func_77952_i()));
        stack.func_77982_d(new NBTTagCompound());
        ItemWatzPellet.setYield(stack, num.yield);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprite(TextureMap map) {
        for (int i = 0; i < EnumWatzType.values().length; ++i) {
            ResourceLocation spriteLoc = new ResourceLocation("hbm", "items/" + this.textures[i]);
            EnumWatzType type = EnumWatzType.values()[i];
            int light = this.isDesaturated ? ItemWatzPellet.desaturate(type.colorLight) : type.colorLight;
            int dark = this.isDesaturated ? ItemWatzPellet.desaturate(type.colorDark) : type.colorDark;
            TextureAtlasSpriteMutatable mutableIcon = new TextureAtlasSpriteMutatable(spriteLoc.toString(), new RGBMutatorInterpolatedComponentRemap(0xD2D2D2, 0x333333, light, dark));
            map.setTextureEntry((TextureAtlasSprite)mutableIcon);
        }
    }

    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flagIn) {
        if (this != ModItems.watz_pellet) {
            return;
        }
        EnumWatzType num = (EnumWatzType)((Object)EnumUtil.grabEnumSafely(EnumWatzType.class, stack.func_77952_i()));
        if (num.passive > 0.0) {
            list.add(TextFormatting.RED + "Self-igniting!");
        }
        list.add("\u00a7aDepletion: " + String.format(Locale.US, "%.1f", this.getDurabilityForDisplay(stack) * 100.0) + "%");
        if (num.burnFunc != null) {
            list.add("\u00a7eBase fission rate: \u00a7r" + num.passive);
            list.add("\u00a7eFlux function: \u00a7r" + num.burnFunc.getLabelForFuel());
            list.add("\u00a7eFunction type: \u00a7r" + num.burnFunc.getDangerFromFuel());
        }
        if (num.heatDiv != null) {
            list.add("\u00a7cThermal flux divider: \u00a7r" + num.heatDiv.getLabelForFuel() + " TU\u207b\u00b9");
        }
        if (num.heatEmission > 0.0) {
            list.add("\u00a76Heat output per flux: " + num.heatEmission + " TU");
        } else if (num.absorbFunc != null) {
            list.add("\u00a76Heat output with flux: " + num.absorbFunc.getLabelForFuel() + " TU");
        }
        if (num.mudContent > 0.0) {
            list.add("\u00a72Mud creation: \u00a7r" + num.mudContent * 1000.0 + "mB per flux");
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this == ModItems.watz_pellet && this.getDurabilityForDisplay(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemWatzPellet.getEnrichment(stack);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (this != ModItems.watz_pellet) {
            return;
        }
        ItemWatzPellet.setNBTDefaults(stack);
    }

    public static enum EnumWatzType {
        SCHRABIDIUM(0x32FFFF, 23644, 2000.0, 20.0, 0.01, new Function.FunctionLinear(1.5), new Function.FunctionSqrtFalling(10.0), null),
        HES(4451839, 17993, 1750.0, 20.0, 0.005, new Function.FunctionLinear(1.25), new Function.FunctionSqrtFalling(15.0), null),
        MES(11856884, 2515568, 1500.0, 15.0, 0.0025, new Function.FunctionLinear(1.15), new Function.FunctionSqrtFalling(15.0), null),
        LES(13098721, 0x3B555B, 1250.0, 15.0, 0.00125, new Function.FunctionLinear(1.0), new Function.FunctionSqrtFalling(20.0), null),
        HEN(10924710, 200451, 0.0, 10.0, 5.0E-4, new Function.FunctionSqrt(100.0), new Function.FunctionSqrtFalling(10.0), null),
        MEU(12699581, 2830887, 0.0, 10.0, 5.0E-4, new Function.FunctionSqrt(75.0), new Function.FunctionSqrtFalling(10.0), null),
        MEP(10134432, 0x111A17, 0.0, 15.0, 5.0E-4, new Function.FunctionSqrt(150.0), new Function.FunctionSqrtFalling(10.0), null),
        LEAD(10921650, 197391, 0.0, 0.0, 0.0025, null, null, new Function.FunctionSqrt(10.0)),
        BORON(12437714, 2700350, 0.0, 0.0, 0.0025, null, null, new Function.FunctionLinear(10.0)),
        DU(12699581, 2830887, 0.0, 0.0, 0.0025, null, null, new Function.FunctionQuadratic(1.0, 1.0).withDiv(100.0)),
        PU241(7897470, 394240, 1950.0, 25.0, 0.0025, new Function.FunctionLinear(1.3), new Function.FunctionSqrt(0.14777777777777779).withOff(576.0), null),
        AMF(12892856, 3286820, 2333.0, 44.0, 0.003, new Function.FunctionLinear(1.33), new Function.FunctionSqrt(0.18513513513513516).withOff(729.0), null),
        AMRG(13546425, 3808289, 2888.0, 48.0, 0.0035, new Function.FunctionLinear(1.33), new Function.FunctionSqrt(0.16980392156862745).withOff(784.0), null);

        public double yield = 5.0E8;
        public final int colorLight;
        public final int colorDark;
        public final double mudContent;
        public final double passive;
        public final double heatEmission;
        public final Function burnFunc;
        public final Function heatDiv;
        public final Function absorbFunc;

        private EnumWatzType(int colorLight, int colorDark, double passive, double heatEmission, double mudContent, Function burnFunction, Function heatDivisor, Function absorbFunction) {
            this.colorLight = colorLight;
            this.colorDark = colorDark;
            this.passive = passive;
            this.heatEmission = heatEmission;
            this.mudContent = mudContent / 2.0;
            this.burnFunc = burnFunction;
            this.heatDiv = heatDivisor;
            this.absorbFunc = absorbFunction;
        }
    }
}

