/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items;

import com.google.common.collect.ImmutableMap;
import com.hbm.items.IDynamicModels;
import com.hbm.items.ItemBase;
import com.hbm.util.EnumUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnumMultiColor
extends ItemBase
implements IDynamicModels {
    public static final String ROOT_PATH = "items/";
    protected final String[] textures;
    protected Class<? extends Enum> theEnum;
    protected boolean multiName;
    protected boolean multiTexture;

    public ItemEnumMultiColor(String registryName, Class<? extends Enum> theEnum, boolean multiName, boolean multiTexture) {
        super(registryName);
        this.func_77627_a(true);
        this.theEnum = theEnum;
        this.multiName = multiName;
        this.multiTexture = multiTexture;
        INSTANCES.add(this);
        this.textures = this.getTextures(registryName);
    }

    public String[] getTextures(String registryName) {
        return (String[])Arrays.stream(this.theEnum.getEnumConstants()).sorted(Comparator.comparing(Enum::ordinal)).map(Enum::name).map(name -> registryName + "-" + name.toLowerCase(Locale.US)).toArray(String[]::new);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprite(TextureMap map) {
        for (String texture : this.textures) {
            map.func_174942_a(new ResourceLocation("hbm", ROOT_PATH + texture));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        for (int i = 0; i < this.theEnum.getEnumConstants().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("hbm", ROOT_PATH + this.textures[i]), "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void bakeModel(ModelBakeEvent event) {
        try {
            IModel baseModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("minecraft", "item/generated"));
            for (int i = 0; i < this.theEnum.getEnumConstants().length; ++i) {
                ResourceLocation spriteLoc = new ResourceLocation("hbm", ROOT_PATH + this.textures[i]);
                IModel retexturedModel = baseModel.retexture(ImmutableMap.of((Object)"layer0", (Object)spriteLoc.toString()));
                IBakedModel bakedModel = retexturedModel.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
                ModelResourceLocation bakedModelLocation = new ModelResourceLocation(spriteLoc, "inventory");
                event.getModelRegistry().func_82595_a((Object)bakedModelLocation, (Object)bakedModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (int i = 0; i < this.theEnum.getEnumConstants().length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public Item func_77655_b(String unlocalizedName) {
        super.func_77655_b(unlocalizedName);
        return this;
    }

    public ItemStack stackFromEnum(int count, Enum num) {
        if (num.getClass() != this.theEnum) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((Item)this, count, num.ordinal());
    }

    public ItemStack stackFromEnum(Enum num) {
        return this.stackFromEnum(1, num);
    }

    public boolean isMultiTexture() {
        return this.multiTexture;
    }

    public Class<? extends Enum> getTheEnum() {
        return this.theEnum;
    }

    public String func_77667_c(ItemStack stack) {
        if (this.multiName) {
            Object num = EnumUtil.grabEnumSafely(this.theEnum, stack.func_77952_i());
            return super.func_77658_a() + "." + ((Enum)num).name().toLowerCase(Locale.US);
        }
        return super.func_77667_c(stack);
    }
}

