/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.inventory.control_panel.Control;
import com.hbm.inventory.control_panel.ControlPanel;
import com.hbm.inventory.control_panel.controls.ButtonEmergencyPush;
import com.hbm.inventory.control_panel.controls.ButtonEncasedPush;
import com.hbm.inventory.control_panel.controls.ButtonPush;
import com.hbm.inventory.control_panel.controls.ControlType;
import com.hbm.inventory.control_panel.controls.DialLarge;
import com.hbm.inventory.control_panel.controls.DialSquare;
import com.hbm.inventory.control_panel.controls.DisplaySevenSeg;
import com.hbm.inventory.control_panel.controls.DisplayText;
import com.hbm.inventory.control_panel.controls.IndicatorLamp;
import com.hbm.inventory.control_panel.controls.KnobControl;
import com.hbm.inventory.control_panel.controls.Label;
import com.hbm.inventory.control_panel.controls.SliderVertical;
import com.hbm.inventory.control_panel.controls.SwitchRotaryToggle;
import com.hbm.inventory.control_panel.controls.SwitchToggle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ControlRegistry {
    public static Map<String, Control> registry = new HashMap<String, Control>();
    private static Map<Class<? extends Control>, String> classToName = new HashMap<Class<? extends Control>, String>();

    private ControlRegistry() {
    }

    public static void init() {
        registry.put("button_push", new ButtonPush("Push Button", null));
        registry.put("button_emergency_push", new ButtonEmergencyPush("Emergency Push Button", null));
        registry.put("button_encased_push", new ButtonEncasedPush("Encased Push Button", null));
        registry.put("switch_toggle", new SwitchToggle("Toggle Switch", null));
        registry.put("switch_rotary_toggle", new SwitchRotaryToggle("Rotary Toggle Switch", null));
        registry.put("slider_vertical", new SliderVertical("Vertical Slider", null));
        registry.put("knob_control", new KnobControl("Control Knob", null));
        registry.put("display_7seg", new DisplaySevenSeg("7-seg Display", null));
        registry.put("display_text", new DisplayText("Text Display", null));
        registry.put("dial_square", new DialSquare("Square Dial", null));
        registry.put("dial_large", new DialLarge("Large Dial", null));
        registry.put("indicator_lamp", new IndicatorLamp("Indicator Lamp", null));
        registry.put("label", new Label("Label", null));
        for (Map.Entry<String, Control> e : registry.entrySet()) {
            classToName.put(e.getValue().getClass(), e.getKey());
        }
    }

    public static List<Control> getAllControls() {
        ArrayList<Control> l = new ArrayList<Control>(registry.size());
        l.addAll(registry.values());
        return l;
    }

    public static List<String> getAllControlsOfType(ControlType type) {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, Control> c : registry.entrySet()) {
            if (c.getValue().getControlType() != type) continue;
            l.add(c.getKey());
        }
        return l;
    }

    public static Control getNew(String name, ControlPanel panel) {
        return registry.get(name).newControl(panel);
    }

    public static String getName(Class<? extends Control> clazz) {
        return classToName.get(clazz);
    }
}

