/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.FluidFlameRecipes;
import com.hbm.inventory.OreDictManager;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.util.Tuple;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class SolidificationRecipes {
    public static final int SF_OIL = 200;
    public static final int SF_CRACK = 200;
    public static final int SF_HEAVY = 150;
    public static final int SF_BITUMEN = 100;
    public static final int SF_SMEAR = 100;
    public static final int SF_HEATING = 50;
    public static final int SF_RECLAIMED = 100;
    public static final int SF_PETROIL = 125;
    public static final int SF_LUBE = 100;
    public static final int SF_NAPH = 150;
    public static final int SF_DIESEL = 200;
    public static final int SF_LIGHT = 225;
    public static final int SF_KEROSENE = 275;
    public static final int SF_GAS = 375;
    public static final int SF_PETROLEUM = 300;
    public static final int SF_LPG = 150;
    public static final int SF_BIOGAS = 1750;
    public static final int SF_BIOFUEL = 750;
    public static final int SF_COALOIL = 200;
    public static final int SF_CREOSOTE = 200;
    public static final int SF_WOOD = 1000;
    public static final int SF_AROMA = 1000;
    public static final int SF_UNSAT = 1000;
    public static HashMap<Fluid, Tuple.Pair<Integer, ItemStack>> recipes = new HashMap();

    public static void registerDefaults() {
        SolidificationRecipes.registerRecipe(FluidRegistry.WATER, 1000, Blocks.field_150432_aD);
        SolidificationRecipes.registerRecipe(FluidRegistry.LAVA, 1000, Blocks.field_150343_Z);
        SolidificationRecipes.registerRecipe(ModForgeFluids.MERCURY, 125, ModItems.nugget_mercury);
        SolidificationRecipes.registerRecipe(ModForgeFluids.BIOGAS, 250, ModItems.biomass_compressed);
        SolidificationRecipes.registerRecipe(ModForgeFluids.ENDERJUICE, 250, Items.field_151079_bi);
        SolidificationRecipes.registerRecipe(ModForgeFluids.OIL, 200, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        SolidificationRecipes.registerRecipe(ModForgeFluids.CRACKOIL, 200, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRACK));
        SolidificationRecipes.registerRecipe(ModForgeFluids.COALOIL, 200, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL));
        SolidificationRecipes.registerRecipe(ModForgeFluids.HEAVYOIL, 150, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        SolidificationRecipes.registerRecipe(ModForgeFluids.HEAVYOIL_VACUUM, 150, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        SolidificationRecipes.registerRecipe(ModForgeFluids.BITUMEN, 100, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        SolidificationRecipes.registerRecipe(ModForgeFluids.COALCREOSOTE, 200, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL));
        SolidificationRecipes.registerRecipe(ModForgeFluids.WOODOIL, 1000, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.WOOD));
        SolidificationRecipes.registerRecipe(ModForgeFluids.LUBRICANT, 100, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.PARAFFIN));
        SolidificationRecipes.registerSFAuto(ModForgeFluids.SMEAR);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.HEATINGOIL);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.HEATINGOIL_VACUUM);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.RECLAIMED);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.PETROIL);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.NAPHTHA);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.NAPHTHA_CRACK);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.DIESEL);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.DIESEL_REFORM);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.DIESEL_CRACK);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.DIESEL_CRACK_REFORM);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.LIGHTOIL);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.LIGHTOIL_CRACK);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.LIGHTOIL_VACUUM);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.KEROSENE);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.KEROSENE_REFORM);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.GAS);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.SOURGAS);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.REFORMGAS);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.SYNGAS);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.PETROLEUM);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.BIOGAS);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.BIOGAS);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.AROMATICS);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.UNSATURATEDS);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.REFORMATE);
        SolidificationRecipes.registerSFAuto(ModForgeFluids.XYLENE);
        SolidificationRecipes.registerSF(ModForgeFluids.BALEFIRE, 24000L, ModItems.solid_fuel_bf);
        SolidificationRecipes.registerRecipe(ModForgeFluids.MUD_FLUID, 16000, ModItems.ingot_mud);
    }

    private static void registerSFAuto(Fluid fluid) {
        SolidificationRecipes.registerSF(fluid, 900L, ModItems.solid_fuel);
    }

    private static void registerSF(Fluid fluid, long tuPerSF, Item fuel) {
        long tuPermBucket = FluidFlameRecipes.getHeatEnergy(fluid);
        if (tuPermBucket == 0L) {
            return;
        }
        double penalty = 1.25;
        int mB = (int)((double)(1000L * tuPerSF) * penalty / (double)tuPermBucket);
        if (mB > 10000) {
            mB -= mB % 1000;
        } else if (mB > 1000) {
            mB -= mB % 100;
        } else if (mB > 100) {
            mB -= mB % 10;
        }
        mB = Math.max(mB, 1);
        if (mB > 24000) {
            return;
        }
        SolidificationRecipes.registerRecipe(fluid, mB, fuel);
    }

    private static void registerRecipe(Fluid type, int quantity, Item output) {
        SolidificationRecipes.registerRecipe(type, quantity, new ItemStack(output));
    }

    private static void registerRecipe(Fluid type, int quantity, Block output) {
        SolidificationRecipes.registerRecipe(type, quantity, new ItemStack(output));
    }

    private static void registerRecipe(Fluid type, int quantity, ItemStack output) {
        recipes.put(type, new Tuple.Pair<Integer, ItemStack>(quantity, output));
    }

    public static boolean hasRecipe(Fluid type) {
        return SolidificationRecipes.getOutput(type) != null;
    }

    public static Tuple.Pair<Integer, ItemStack> getOutput(Fluid type) {
        return recipes.get(type);
    }
}

