/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.ChemplantRecipes;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MixerRecipes {
    public static HashMap<Fluid, FluidStack[]> recipesFluidInputs = new HashMap();
    public static HashMap<Fluid, Integer> recipesFluidOutputAmount = new HashMap();
    public static LinkedHashMap<Fluid, Integer> recipesDurations = new LinkedHashMap();
    public static HashMap<Fluid, RecipesCommon.AStack> recipesItemInputs = new HashMap();

    public static void copyChemplantRecipes() {
        for (int i : ChemplantRecipes.recipeNames.keySet()) {
            RecipesCommon.AStack[] itemOut;
            FluidStack[] fStacks = ChemplantRecipes.recipeFluidOutputs.get(i);
            if (fStacks == null || fStacks.length != 1 || (itemOut = ChemplantRecipes.recipeItemOutputs.get(i)) != null) continue;
            RecipesCommon.AStack[] itemInputs = ChemplantRecipes.recipeItemInputs.get(i);
            RecipesCommon.AStack itemInput = null;
            if (itemInputs != null) {
                if (itemInputs.length != 1) continue;
                itemInput = itemInputs[0];
            }
            MixerRecipes.addRecipe(fStacks[0], ChemplantRecipes.recipeFluidInputs.get(i), itemInput, ChemplantRecipes.recipeDurations.get(i));
        }
    }

    public static void registerRecipes() {
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.ETHANOL, 100), new FluidStack[]{new FluidStack(FluidRegistry.WATER, 500)}, new RecipesCommon.ComparableStack(Items.field_151102_aT), 200);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.COLLOID, 500), new FluidStack[]{new FluidStack(FluidRegistry.WATER, 500)}, new RecipesCommon.ComparableStack(ModItems.dust), 20);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.FISHOIL, 100), null, new RecipesCommon.ComparableStack(Items.field_151115_aP, 1, Short.MAX_VALUE), 50);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.SUNFLOWEROIL, 100), null, new RecipesCommon.ComparableStack((Block)Blocks.field_150398_cm, 1, 0), 50);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.NITROGLYCERIN, 1000), new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 1000), new FluidStack(ModForgeFluids.NITRIC_ACID, 1000)}, null, 20);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.BIOFUEL, 250), new FluidStack[]{new FluidStack(ModForgeFluids.FISHOIL, 500), new FluidStack(ModForgeFluids.SUNFLOWEROIL, 500)}, null, 20);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.LUBRICANT, 1000), new FluidStack[]{new FluidStack(ModForgeFluids.ETHANOL, 200), new FluidStack(ModForgeFluids.SUNFLOWEROIL, 800)}, null, 20);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.PHOSGENE, 1000), new FluidStack[]{new FluidStack(ModForgeFluids.UNSATURATEDS, 500), new FluidStack(ModForgeFluids.CHLORINE, 500)}, null, 20);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.IONGEL, 1000), new FluidStack[]{new FluidStack(FluidRegistry.WATER, 1000), new FluidStack(ModForgeFluids.HYDROGEN, 200)}, new RecipesCommon.ComparableStack(ModItems.pellet_charged), 50);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.SYNGAS, 1000), new FluidStack[]{new FluidStack(ModForgeFluids.COALOIL, 500), new FluidStack(ModForgeFluids.STEAM, 500)}, null, 50);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.PETROIL_LEADED, 12000), new FluidStack[]{new FluidStack(ModForgeFluids.PETROIL, 10000)}, new RecipesCommon.ComparableStack(ModItems.antiknock, 1), 40);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.GASOLINE_LEADED, 12000), new FluidStack[]{new FluidStack(ModForgeFluids.GASOLINE, 10000)}, new RecipesCommon.ComparableStack(ModItems.antiknock, 1), 40);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.COALGAS_LEADED, 12000), new FluidStack[]{new FluidStack(ModForgeFluids.COALGAS, 10000)}, new RecipesCommon.ComparableStack(ModItems.antiknock, 1), 40);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.DIESEL_REFORM, 1000), new FluidStack[]{new FluidStack(ModForgeFluids.DIESEL, 900), new FluidStack(ModForgeFluids.REFORMATE, 100)}, null, 50);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.DIESEL_CRACK_REFORM, 1000), new FluidStack[]{new FluidStack(ModForgeFluids.DIESEL_CRACK, 900), new FluidStack(ModForgeFluids.REFORMATE, 100)}, null, 50);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.KEROSENE_REFORM, 1000), new FluidStack[]{new FluidStack(ModForgeFluids.KEROSENE, 900), new FluidStack(ModForgeFluids.REFORMATE, 100)}, null, 50);
        MixerRecipes.addRecipe(new FluidStack(ModForgeFluids.PERFLUOROMETHYL, 1000), new FluidStack[]{new FluidStack(ModForgeFluids.PETROLEUM, 1000), new FluidStack(ModForgeFluids.UNSATURATEDS, 500)}, new RecipesCommon.OreDictStack(OreDictManager.F.dust()), 20);
    }

    public static void addRecipe(FluidStack output, FluidStack[] inputs, RecipesCommon.AStack inputItem, int duration) {
        Fluid f = output.getFluid();
        if (inputs != null) {
            recipesFluidInputs.put(f, inputs);
        }
        recipesFluidOutputAmount.put(f, output.amount);
        recipesDurations.put(f, duration > 0 ? duration : 100);
        if (inputItem != null) {
            recipesItemInputs.put(f, inputItem);
        }
    }

    public static int getFluidOutputAmount(Fluid output) {
        Integer x = recipesFluidOutputAmount.get(output);
        if (x == null) {
            return 1;
        }
        return x;
    }

    public static int getRecipeDuration(Fluid output) {
        Integer x = recipesDurations.get(output);
        if (x == null) {
            return 20;
        }
        return x;
    }

    public static boolean hasMixerRecipe(Fluid output) {
        return recipesDurations.containsKey(output);
    }

    public static FluidStack[] getInputFluidStacks(Fluid output) {
        return recipesFluidInputs.get(output);
    }

    public static boolean matchesInputItem(Fluid output, ItemStack inputItem) {
        if (output == null) {
            return false;
        }
        RecipesCommon.AStack in = recipesItemInputs.get(output);
        if (in == null) {
            return true;
        }
        return in.matchesRecipe(inputItem, true);
    }

    public static int getInputItemCount(Fluid output) {
        RecipesCommon.AStack in = recipesItemInputs.get(output);
        if (in == null) {
            return 0;
        }
        return in.count();
    }

    public static RecipesCommon.AStack getInputItem(Fluid output) {
        return recipesItemInputs.get(output);
    }

    public static Fluid[] getInputFluids(Fluid output) {
        FluidStack[] f = recipesFluidInputs.get(output);
        if (f == null) {
            return null;
        }
        if (f.length == 1) {
            return new Fluid[]{f[0].getFluid()};
        }
        if (f.length == 2) {
            return new Fluid[]{f[0].getFluid(), f[1].getFluid()};
        }
        return null;
    }
}

