/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import java.util.HashMap;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidCombustionRecipes {
    public static HashMap<Fluid, Long> combustionEnergies = new HashMap();
    public static HashMap<Fluid, FuelGrade> fuelGrades = new HashMap();

    public static void registerFluidCombustionRecipes() {
        FluidCombustionRecipes.addFuel("biofuel", FuelGrade.HIGH, 400000L);
        FluidCombustionRecipes.addFuel("petroil", FuelGrade.MEDIUM, 300000L);
        FluidCombustionRecipes.addFuel("refined_fuel", FuelGrade.HIGH, 1000000L);
        FluidCombustionRecipes.addFuel("refined_biofuel", FuelGrade.HIGH, 400000L);
    }

    public static long getCombustionEnergy(Fluid f) {
        if (f != null && combustionEnergies.get(f) != null) {
            return combustionEnergies.get(f);
        }
        return 0L;
    }

    public static FuelGrade getFuelGrade(Fluid f) {
        if (f != null) {
            return fuelGrades.get(f);
        }
        return null;
    }

    public static boolean isAero(Fluid f) {
        return FluidCombustionRecipes.getFuelGrade(f) == FuelGrade.AERO;
    }

    public static void addFuel(Fluid f, FuelGrade g, long power) {
        if (f != null && power > 0L) {
            combustionEnergies.put(f, power);
            fuelGrades.put(f, g);
        }
    }

    public static boolean hasFuelRecipe(Fluid f) {
        if (f == null) {
            return false;
        }
        return combustionEnergies.containsKey(f);
    }

    public static void addFuel(String f, FuelGrade g, long power) {
        if (FluidRegistry.isFluidRegistered((String)f)) {
            FluidCombustionRecipes.addFuel(FluidRegistry.getFluid((String)f), g, power);
        }
    }

    public static void removeFuel(Fluid f) {
        if (f != null) {
            combustionEnergies.remove(f);
            fuelGrades.remove(f);
        }
    }

    public static void removeFuel(String f) {
        if (FluidRegistry.isFluidRegistered((String)f)) {
            FluidCombustionRecipes.removeFuel(FluidRegistry.getFluid((String)f));
        }
    }

    public static enum FuelGrade {
        LOW("trait.fuelgrade.low"),
        MEDIUM("trait.fuelgrade.medium"),
        HIGH("trait.fuelgrade.high"),
        AERO("trait.fuelgrade.aero"),
        GAS("trait.fuelgrade.gas");

        private final String grade;

        private FuelGrade(String grade) {
            this.grade = grade;
        }

        public String getGrade() {
            return this.grade;
        }
    }
}

