/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.particle.lightning_test.TrailRenderer2;
import com.hbm.util.BobMathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LightningGenerator {
    private static Random rand = new Random();

    public static LightningNode generateLightning(Vec3d from, Vec3d to, LightningGenInfo info) {
        rand.setSeed(Minecraft.func_71410_x().field_71441_e.func_82737_E());
        LightningNode lfrom = new LightningNode(from);
        LightningNode lto = new LightningNode(to);
        lfrom.children.add(lto);
        lto.parent = lfrom;
        LightningGenerator.generateLightning(lfrom, info);
        return lfrom;
    }

    public static void generateLightning(LightningNode node, LightningGenInfo info) {
        Vec3d from = node.pos;
        Vec3d to = node.children.get((int)0).pos;
        LightningGenerator.subdivide(node, info.subdivisions, info.subdivMult, info.subdivRecurse - 1, info.randAmount, info.randAmountSubdivMultiplier);
        LightningNode child = node.children.get(0);
        float value = 0.0f;
        while (!child.children.isEmpty()) {
            value += 0.02f;
            LightningNode next = child.children.get(0);
            if (rand.nextFloat() < info.forkChance - value) {
                Vec3d randVec = BobMathUtil.randVecInCone(to.func_178788_d(from).func_72432_b(), info.forkConeDegrees, rand);
                LightningNode fork1 = new LightningNode(child.pos);
                float len = 1.0f + rand.nextFloat() * info.forkLengthRandom;
                LightningNode fork2 = new LightningNode(child.pos.func_178787_e(randVec.func_186678_a((double)len * from.func_178788_d(to).func_72433_c() * 0.25)));
                fork1.children.add(fork2);
                fork2.parent = fork1;
                LightningGenerator.subdivide(fork1, (int)((double)len * 0.75 * (double)info.forkSubdivisions), info.forkSubdivMult, info.forkSubdivRecurse, info.forkRandAmount * info.randAmount * rand.nextFloat() * 0.8f, info.forkRandAmountSubdivMultiplier);
                child.children.add(fork1);
            }
            child = next;
        }
    }

    public static void subdivide(LightningNode n, int subdivisions, float subdivMult, int recurse, float randAmount, float randAmountSubdivMultiplier) {
        LightningNode parent = n;
        LightningNode child = n.children.get(0);
        float subdivision = 1.0f / (float)(subdivisions + 1);
        for (int i = 1; i <= subdivisions; ++i) {
            Vec3d newPos = BobMathUtil.mix(n.pos, child.pos, subdivision * (float)i).func_72441_c((double)((rand.nextFloat() * 2.0f - 1.0f) * randAmount), (double)((rand.nextFloat() * 2.0f - 1.0f) * randAmount), (double)((rand.nextFloat() * 2.0f - 1.0f) * randAmount));
            LightningNode insert = new LightningNode(newPos);
            insert.parent = parent;
            insert.children.add(child);
            parent.children.set(0, insert);
            child.parent = insert;
            parent = insert;
        }
        if (recurse <= 0) {
            return;
        }
        child = n;
        while (!child.children.isEmpty()) {
            LightningNode next = child.children.get(0);
            LightningGenerator.subdivide(child, (int)((float)subdivisions * subdivMult), subdivMult, recurse - 1, randAmount * randAmountSubdivMultiplier, randAmountSubdivMultiplier);
            child = next;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(LightningNode n, Vec3d playerPos, float scale) {
        LightningGenerator.render(n, playerPos, scale, 0.0f, 0.0f, 0.0f, false, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void render(LightningNode n, Vec3d playerPos, float scale, float x, float y, float z, boolean fadeEnd, @Nullable TrailRenderer2.IColorGetter c) {
        ArrayList<Vec3d> toRender = new ArrayList<Vec3d>();
        toRender.add(n.pos.func_72441_c((double)x, (double)y, (double)z));
        while (!n.children.isEmpty()) {
            for (int i = 1; i < n.children.size(); ++i) {
                LightningGenerator.render(n.children.get(i), playerPos, scale * 0.5f, x, y, z, fadeEnd, c);
            }
            n = n.children.get(0);
            toRender.add(n.pos.func_72441_c((double)x, (double)y, (double)z));
        }
        TrailRenderer2.draw(playerPos, toRender, scale, fadeEnd, true, c);
    }

    public static class LightningNode {
        public LightningNode parent = null;
        public List<LightningNode> children = new ArrayList<LightningNode>(1);
        public Vec3d pos;

        public LightningNode(Vec3d pos) {
            this.pos = pos;
        }
    }

    public static class LightningGenInfo {
        public int subdivisions = 4;
        public int subdivRecurse = 2;
        public float randAmount = 0.2f;
        public float forkChance = 0.1f;
        public float forkSubdivMult = 1.0f;
        public float forkSubdivisions = 1.0f;
        public int forkSubdivRecurse = 1;
        public float forkLengthRandom = 4.0f;
        public float forkRandAmount = 0.2f;
        public float forkRandAmountSubdivMultiplier = 0.25f;
        public float randAmountSubdivMultiplier = 0.25f;
        public float forkConeDegrees = 25.0f;
        public float subdivMult = 1.5f;
    }
}

