/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.config.CompatibilityConfig;
import com.hbm.entity.projectile.EntityRubble;
import com.hbm.interfaces.IConstantRenderer;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBlackHole
extends Entity
implements IConstantRenderer {
    public static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityBlackHole.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityBlackHole(World worldIn) {
        super(worldIn);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public EntityBlackHole(World w, float size) {
        this(w);
        this.func_184212_Q().func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!CompatibilityConfig.isWarDim(this.field_70170_p)) {
            this.func_70106_y();
            return;
        }
        float size = ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
        if (!this.field_70170_p.field_72995_K) {
            int k = 0;
            while ((float)k < size * 2.0f) {
                double phi = this.field_70146_Z.nextDouble() * (Math.PI * 2);
                double costheta = this.field_70146_Z.nextDouble() * 2.0 - 1.0;
                double theta = Math.acos(costheta);
                double x = Math.sin(theta) * Math.cos(phi);
                double y = Math.sin(theta) * Math.sin(phi);
                double z = Math.cos(theta);
                Vec3 vec = Vec3.createVectorHelper(x, y, z);
                int length = (int)Math.ceil(size * 15.0f);
                for (int i = 0; i < length; ++i) {
                    int x0 = (int)(this.field_70165_t + vec.xCoord * (double)i);
                    int y0 = (int)(this.field_70163_u + vec.yCoord * (double)i);
                    int z0 = (int)(this.field_70161_v + vec.zCoord * (double)i);
                    BlockPos des = new BlockPos(x0, y0, z0);
                    if (this.field_70170_p.func_180495_p(des).func_185904_a().func_76224_d()) {
                        this.field_70170_p.func_175656_a(des, Blocks.field_150350_a.func_176223_P());
                    }
                    if (this.field_70170_p.func_180495_p(des).func_177230_c() == Blocks.field_150350_a) continue;
                    EntityRubble rubble = new EntityRubble(this.field_70170_p);
                    rubble.field_70165_t = (float)x0 + 0.5f;
                    rubble.field_70163_u = y0;
                    rubble.field_70161_v = (float)z0 + 0.5f;
                    IBlockState st = this.field_70170_p.func_180495_p(new BlockPos(x0, y0, z0));
                    rubble.setMetaBasedOnBlock(st.func_177230_c(), st.func_177230_c().func_176201_c(st));
                    this.field_70170_p.func_72838_d((Entity)rubble);
                    this.field_70170_p.func_175656_a(des, Blocks.field_150350_a.func_176223_P());
                    break;
                }
                ++k;
            }
        }
        double range = size * 15.0f;
        List entities = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t - range, this.field_70163_u - range, this.field_70161_v - range, this.field_70165_t + range, this.field_70163_u + range, this.field_70161_v + range));
        for (Entity e : entities) {
            EntityItem item;
            ItemStack stack;
            Vec3 vec;
            double dist;
            if (Library.isCreative(e)) continue;
            if (e instanceof EntityFallingBlock && !this.field_70170_p.field_72995_K && e.field_70173_aa > 1) {
                double x = e.field_70165_t;
                double y = e.field_70163_u;
                double z = e.field_70161_v;
                Block b = ((EntityFallingBlock)e).func_175131_l().func_177230_c();
                int meta = b.func_176201_c(((EntityFallingBlock)e).func_175131_l());
                e.func_70106_y();
                EntityRubble rubble = new EntityRubble(this.field_70170_p);
                rubble.setMetaBasedOnBlock(b, meta);
                rubble.func_70080_a(x, y, z, 0.0f, 0.0f);
                rubble.field_70159_w = e.field_70159_w;
                rubble.field_70181_x = e.field_70181_x;
                rubble.field_70179_y = e.field_70179_y;
                this.field_70170_p.func_72838_d((Entity)rubble);
            }
            if ((dist = (vec = Vec3.createVectorHelper(this.field_70165_t - e.field_70165_t, this.field_70163_u - e.field_70163_u, this.field_70161_v - e.field_70161_v)).length()) > range) continue;
            vec = vec.normalize();
            if (!(e instanceof EntityItem)) {
                vec.rotateAroundY((float)Math.toRadians(15.0));
            }
            double speed = 0.1;
            e.field_70159_w += vec.xCoord * speed;
            e.field_70181_x += vec.yCoord * speed * 2.0;
            e.field_70179_y += vec.zCoord * speed;
            if (e instanceof EntityBlackHole || !(dist < (double)size * 1.5)) continue;
            e.func_70097_a(ModDamageSource.blackhole, 1000.0f);
            if (!(e instanceof EntityLivingBase)) {
                e.func_70106_y();
            }
            if (this.field_70170_p.field_72995_K || !(e instanceof EntityItem) || (stack = (item = (EntityItem)e).func_92059_d()).func_77973_b() != ModItems.pellet_antimatter && stack.func_77973_b() != ModItems.flame_pony) continue;
            this.func_70106_y();
            this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, true);
            return;
        }
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.99;
        this.field_70179_y *= 0.99;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SIZE, (Object)Float.valueOf(0.5f));
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.func_184212_Q().func_187227_b(SIZE, (Object)Float.valueOf(compound.func_74760_g("size")));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74776_a("size", ((Float)this.func_184212_Q().func_187225_a(SIZE)).floatValue());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 25000.0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }
}

